/*
 * Decompiled with CFR 0.152.
 */
package org.nerd4j.lang.bitfield;

import org.nerd4j.lang.bitfield.AbstractBitField;

public class EnumBitField<E extends Enum<E>>
extends AbstractBitField<E> {
    private static final long serialVersionUID = 1L;
    private final Class<E> enumClass;

    public EnumBitField(Class<E> enumType) {
        super(((Enum[])enumType.getEnumConstants()).length);
        this.enumClass = enumType;
    }

    public EnumBitField(Class<E> clazz, byte[] data) {
        super(((Enum[])clazz.getEnumConstants()).length, data);
        this.enumClass = clazz;
    }

    @Override
    protected int evaluateIndex(E index) throws NullPointerException {
        this.check(index);
        return ((Enum)index).ordinal();
    }

    private void check(Object index) {
        if (this.enumClass != index.getClass()) {
            throw new ClassCastException("Trying to cast " + index.getClass().getSimpleName() + " to " + this.enumClass.getSimpleName() + ".");
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        EnumBitField other = (EnumBitField)obj;
        return this.enumClass.equals(other.enumClass);
    }
}

