/*
 * Decompiled with CFR 0.152.
 */
package org.nerd4j.net;

import java.io.Serializable;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IPv4Address
implements Serializable,
Comparable<IPv4Address> {
    private static final long serialVersionUID = -9003117636518262197L;
    private static final int BYTE_NUMBER = 4;
    private static final String DOT = "\\.";
    private static final String DEC_BYTE = "(25[0-5]|2[0-4][0-9]|[0-1]?[0-9]{1,2})";
    private static final String HEX_BYTE = "([A-Fa-f0-9]{1,2})";
    private static final Pattern DEC_IP_PATTERN = Pattern.compile("(25[0-5]|2[0-4][0-9]|[0-1]?[0-9]{1,2})\\.(25[0-5]|2[0-4][0-9]|[0-1]?[0-9]{1,2})\\.(25[0-5]|2[0-4][0-9]|[0-1]?[0-9]{1,2})\\.(25[0-5]|2[0-4][0-9]|[0-1]?[0-9]{1,2})");
    private static final Pattern HEX_IP_PATTERN = Pattern.compile("([A-Fa-f0-9]{1,2})\\.([A-Fa-f0-9]{1,2})\\.([A-Fa-f0-9]{1,2})\\.([A-Fa-f0-9]{1,2})");
    private static final int LOW_BYTE_MASK = 255;
    private int intIp;
    private transient String strIp;
    private transient byte[] rawIp;

    private IPv4Address(int ip) {
        this.intIp = ip;
    }

    public static IPv4Address valueOf(int ip) {
        return new IPv4Address(ip);
    }

    public static IPv4Address valueOf(String ip) throws IllegalArgumentException {
        IPv4Address ipAddress;
        try {
            int intIp = IPv4Address.computeIntValue(ip, DEC_IP_PATTERN, 10);
            ipAddress = new IPv4Address(intIp);
            ipAddress.strIp = ip;
        }
        catch (IllegalArgumentException e) {
            int intIp = IPv4Address.computeIntValue(ip, HEX_IP_PATTERN, 16);
            ipAddress = new IPv4Address(intIp);
        }
        return ipAddress;
    }

    public static IPv4Address valueOf(byte[] ip) throws IllegalArgumentException {
        int intIp = IPv4Address.computeIntValue(ip);
        IPv4Address ipAddress = new IPv4Address(intIp);
        ipAddress.rawIp = new byte[4];
        System.arraycopy(ip, 0, ipAddress.rawIp, 0, ip.length);
        return ipAddress;
    }

    public static IPv4Address valueOf(InetAddress inet) throws IllegalArgumentException {
        byte[] raw;
        if (inet == null) {
            throw new IllegalArgumentException("Null isn't a valid inet address.");
        }
        if (inet instanceof Inet6Address) {
            Inet6Address inet6 = (Inet6Address)inet;
            if (!inet6.isIPv4CompatibleAddress()) {
                throw new IllegalArgumentException("Not a compatible IPv4 IPv6 address: " + inet);
            }
            raw = new byte[4];
            System.arraycopy(inet6.getAddress(), 12, raw, 0, 4);
        } else {
            raw = inet.getAddress();
        }
        return IPv4Address.valueOf(raw);
    }

    private static int computeIntValue(String ip, Pattern pattern, int base) throws IllegalArgumentException {
        Matcher matcher = pattern.matcher(ip);
        if (matcher.matches()) {
            int intIp = 0;
            for (int i = 1; i < 5; ++i) {
                String strBlock = matcher.group(i);
                int intBlock = Integer.valueOf(strBlock, base);
                intIp = intIp << 8 | intBlock;
            }
            return intIp;
        }
        throw new IllegalArgumentException("Not a valid IP string: \"" + ip + "\".");
    }

    private static int computeIntValue(byte[] ip) {
        if (ip == null || ip.length != 4) {
            throw new IllegalArgumentException("Not a valid raw IP.");
        }
        int intIp = 0;
        for (byte byteBlock : ip) {
            intIp = intIp << 8 | byteBlock & 0xFF;
        }
        return intIp;
    }

    private String computeStringValue(int ip) {
        StringBuilder sb = new StringBuilder(16);
        for (int i = 0; i < 4; ++i) {
            int intBlock = ip >> 8 * (3 - i) & 0xFF;
            sb.append(intBlock).append('.');
        }
        int end = sb.length() - 1;
        return sb.substring(0, end);
    }

    private byte[] computeRawValue(int ip) {
        byte[] rawIp = new byte[4];
        for (int i = 0; i < 4; ++i) {
            rawIp[i] = (byte)(ip >> 8 * (3 - i));
        }
        return rawIp;
    }

    public int intValue() {
        return this.intIp;
    }

    public String stringValue() {
        if (this.strIp == null) {
            this.strIp = this.computeStringValue(this.intIp);
        }
        return this.strIp;
    }

    public byte[] rawValue() {
        if (this.rawIp == null) {
            this.rawIp = this.computeRawValue(this.intIp);
        }
        return this.rawIp;
    }

    @Override
    public int compareTo(IPv4Address other) {
        if ((this.intIp ^ other.intIp) >>> 31 == 1) {
            return other.intIp - this.intIp;
        }
        return this.intIp - other.intIp;
    }

    public int hashCode() {
        return this.intIp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IPv4Address other = (IPv4Address)obj;
        return this.intIp == other.intIp;
    }

    public String toString() {
        return this.stringValue();
    }
}

