/*
 * Decompiled with CFR 0.152.
 */
package org.nerd4j.time;

import java.util.Date;
import org.nerd4j.lang.ComparableInterval;

public class UnixTimeInterval
extends ComparableInterval<Date> {
    private static final long serialVersionUID = 1L;
    public static final Date BEGIN_OF_UNIXTIME = new Date(0L);
    public static final Date END_OF_UNIXTIME = new Date(2147483647000L);
    private static final UnixTimeInterval UNIX_TIME_INTERVAL = new UnixTimeInterval();

    protected UnixTimeInterval() {
        super(BEGIN_OF_UNIXTIME, END_OF_UNIXTIME);
    }

    public UnixTimeInterval(Date begin) {
        this(begin, END_OF_UNIXTIME);
    }

    public UnixTimeInterval(Date begin, Date end) {
        super(begin, end);
        if (begin.before(BEGIN_OF_UNIXTIME)) {
            throw new IllegalArgumentException("The begin date is not in the unix time range");
        }
        if (end.after(END_OF_UNIXTIME)) {
            throw new IllegalArgumentException("The end date is not in the unix time range");
        }
    }

    public static UnixTimeInterval getUnixTimeInterval() {
        return UNIX_TIME_INTERVAL;
    }
}

