/*
 * Decompiled with CFR 0.152.
 */
package org.nerd4j.util;

import java.util.Collection;
import java.util.Map;
import org.nerd4j.exception.DataConsistencyException;

public class DataConsistency {
    public static void checkIfNotNull(String name, Object value) {
        if (value == null) {
            throw new DataConsistencyException("Invalid argument, field " + name + " must be not null");
        }
    }

    public static void checkIfValued(String name, String value) {
        if (value == null || value.isEmpty()) {
            throw new DataConsistencyException("Invalid argument, field " + name + " must be valued, but was " + value);
        }
    }

    public static void checkIfValued(String name, Collection<?> value) {
        if (value == null || value.isEmpty()) {
            throw new DataConsistencyException("Invalid argument, field " + name + " must be not null and have at least one element, but was " + value);
        }
    }

    public static void checkIfValued(String name, Map<?, ?> value) {
        if (value == null || value.isEmpty()) {
            throw new DataConsistencyException("Invalid argument, field " + name + " must be not null and have at least one element, but was " + value);
        }
    }

    public static void checkIfStrictPositive(String name, long value) {
        if (value <= 0L) {
            throw new DataConsistencyException("Invalid argument, field " + name + " must be positive, but was " + value);
        }
    }

    public static void checkIfStrictPositive(String name, double value) {
        if (value <= 0.0) {
            throw new DataConsistencyException("Invalid argument, field " + name + " must be positive, but was " + value);
        }
    }

    public static void checkIfTrue(String proposition, boolean value) {
        if (!value) {
            throw new DataConsistencyException("The proposition '" + proposition + "' has to be true");
        }
    }

    public static void checkIfFalse(String proposition, boolean value) {
        if (value) {
            throw new DataConsistencyException("The proposition '" + proposition + "' has to be false");
        }
    }
}

