/*
 * Decompiled with CFR 0.152.
 */
package org.nerd4j.util;

import java.util.Arrays;
import java.util.Iterator;

public class EqualsUtils {
    public static <Type> Type castIfSameClass(Object otherObj, Class<Type> thisClass) {
        if (otherObj != null && otherObj.getClass().equals(thisClass)) {
            return (Type)otherObj;
        }
        return null;
    }

    public static <Type> Type castIfInstanceOf(Object otherObj, Class<Type> thisClass) {
        if (otherObj != null && thisClass.isInstance(otherObj)) {
            return (Type)otherObj;
        }
        return null;
    }

    public static <Field> boolean equalsFields(Field thisField, Field otherField) {
        if (thisField == otherField) {
            return true;
        }
        if (thisField == null ^ otherField == null) {
            return false;
        }
        if (thisField.getClass().isArray()) {
            return EqualsUtils.equalsArrays(thisField, otherField);
        }
        if (thisField instanceof Iterable) {
            return EqualsUtils.equalsIterables((Iterable)thisField, (Iterable)otherField);
        }
        return thisField.equals(otherField);
    }

    public static <Field> boolean equalsFields(Field thisField, Field otherField, Field ... others) {
        if (others != null && others.length % 2 != 0) {
            throw new IllegalArgumentException("Number of arguments must be even but was " + (others.length + 2));
        }
        if (!EqualsUtils.equalsFields(thisField, otherField)) {
            return false;
        }
        if (others != null && others.length > 0) {
            for (int i = 0; i < others.length; ++i) {
                if (EqualsUtils.equalsFields(others[i], others[++i])) continue;
                return false;
            }
        }
        return true;
    }

    public static <Field> boolean deepEqualsFields(Field thisField, Field otherField) {
        if (thisField == otherField) {
            return true;
        }
        if (thisField == null ^ otherField == null) {
            return false;
        }
        if (thisField.getClass().isArray()) {
            return EqualsUtils.deepEqualsArrays(thisField, otherField);
        }
        if (thisField instanceof Iterable) {
            return EqualsUtils.deepEqualsIterables((Iterable)thisField, (Iterable)otherField);
        }
        return thisField.equals(otherField);
    }

    public static <Field> boolean deepEqualsFields(Field thisField, Field otherField, Field ... others) {
        if (others != null && others.length % 2 == 1) {
            throw new IllegalArgumentException("Number of arguments must be even but was " + (others.length + 2));
        }
        if (!EqualsUtils.deepEqualsFields(thisField, otherField)) {
            return false;
        }
        if (others != null && others.length > 0) {
            for (int i = 0; i < others.length; ++i) {
                if (EqualsUtils.deepEqualsFields(others[i], others[++i])) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean equalsIterables(Iterable<?> fst, Iterable<?> snd) {
        Iterator<?> fstIter = fst.iterator();
        Iterator<?> sndIter = snd.iterator();
        while (fstIter.hasNext()) {
            Object sndValue;
            if (!sndIter.hasNext()) {
                return false;
            }
            Object fstValue = fstIter.next();
            if (EqualsUtils.equalsFields(fstValue, sndValue = sndIter.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsArrays(Object fst, Object snd) {
        if (fst instanceof Object[]) {
            return Arrays.equals((Object[])fst, (Object[])snd);
        }
        if (fst instanceof int[]) {
            return Arrays.equals((int[])fst, (int[])snd);
        }
        if (fst instanceof byte[]) {
            return Arrays.equals((byte[])fst, (byte[])snd);
        }
        if (fst instanceof long[]) {
            return Arrays.equals((long[])fst, (long[])snd);
        }
        if (fst instanceof short[]) {
            return Arrays.equals((short[])fst, (short[])snd);
        }
        if (fst instanceof boolean[]) {
            return Arrays.equals((boolean[])fst, (boolean[])snd);
        }
        if (fst instanceof float[]) {
            return Arrays.equals((float[])fst, (float[])snd);
        }
        if (fst instanceof double[]) {
            return Arrays.equals((double[])fst, (double[])snd);
        }
        if (fst instanceof char[]) {
            return Arrays.equals((char[])fst, (char[])snd);
        }
        return false;
    }

    private static boolean deepEqualsIterables(Iterable<?> fst, Iterable<?> snd) {
        Iterator<?> fstIter = fst.iterator();
        Iterator<?> sndIter = snd.iterator();
        while (fstIter.hasNext()) {
            Object sndValue;
            if (!sndIter.hasNext()) {
                return false;
            }
            Object fstValue = fstIter.next();
            if (EqualsUtils.deepEqualsFields(fstValue, sndValue = sndIter.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean deepEqualsArrays(Object fst, Object snd) {
        if (fst instanceof Object[]) {
            Object[] fstArray = (Object[])fst;
            Object[] sndArray = (Object[])snd;
            if (fstArray.length != sndArray.length) {
                return false;
            }
            for (int i = 0; i < fstArray.length; ++i) {
                if (EqualsUtils.deepEqualsFields(fstArray[i], sndArray[i])) continue;
                return false;
            }
            return true;
        }
        if (fst instanceof int[]) {
            return Arrays.equals((int[])fst, (int[])snd);
        }
        if (fst instanceof byte[]) {
            return Arrays.equals((byte[])fst, (byte[])snd);
        }
        if (fst instanceof long[]) {
            return Arrays.equals((long[])fst, (long[])snd);
        }
        if (fst instanceof short[]) {
            return Arrays.equals((short[])fst, (short[])snd);
        }
        if (fst instanceof boolean[]) {
            return Arrays.equals((boolean[])fst, (boolean[])snd);
        }
        if (fst instanceof float[]) {
            return Arrays.equals((float[])fst, (float[])snd);
        }
        if (fst instanceof double[]) {
            return Arrays.equals((double[])fst, (double[])snd);
        }
        if (fst instanceof char[]) {
            return Arrays.equals((char[])fst, (char[])snd);
        }
        return false;
    }
}

