/*
 * Decompiled with CFR 0.152.
 */
package org.nerd4j.util;

import java.util.Arrays;

public class HashCoder {
    public static int hashCode(int prime, int base) {
        int actual = prime == 0 ? 79 : prime;
        return base == 0 ? actual : actual * base;
    }

    public static int hashCode(int prime, int base, int offset) {
        return HashCoder.hashCode(prime, base) + offset;
    }

    public static int hashCode(int prime, Object base) {
        if (base == null) {
            return HashCoder.hashCode(prime, 0);
        }
        if (base instanceof Iterable) {
            return HashCoder.hashIterable(prime, (Iterable)base);
        }
        if (base.getClass().isArray()) {
            return HashCoder.hashCode(prime, HashCoder.hashArray(base));
        }
        return HashCoder.hashCode(prime, base.hashCode());
    }

    public static int hashCode(int prime, Object base, Object ... offsets) {
        int result = HashCoder.hashCode(prime, base);
        for (Object offset : offsets) {
            result += HashCoder.hashCode(result, offset);
        }
        return result;
    }

    private static int hashIterable(int prime, Iterable<?> iterable) {
        int result = 0;
        for (Object value : iterable) {
            result += HashCoder.hashCode(result, value);
        }
        return result;
    }

    private static int hashArray(Object array) {
        if (array instanceof Object[]) {
            return Arrays.deepHashCode((Object[])array);
        }
        if (array instanceof int[]) {
            return Arrays.hashCode((int[])array);
        }
        if (array instanceof byte[]) {
            return Arrays.hashCode((byte[])array);
        }
        if (array instanceof long[]) {
            return Arrays.hashCode((long[])array);
        }
        if (array instanceof short[]) {
            return Arrays.hashCode((short[])array);
        }
        if (array instanceof boolean[]) {
            return Arrays.hashCode((boolean[])array);
        }
        if (array instanceof float[]) {
            return Arrays.hashCode((float[])array);
        }
        if (array instanceof double[]) {
            return Arrays.hashCode((double[])array);
        }
        if (array instanceof char[]) {
            return Arrays.hashCode((char[])array);
        }
        return 0;
    }
}

