/*
 * Decompiled with CFR 0.152.
 */
package org.nerd4j.util;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class PartitionCount<B> {
    private AtomicInteger totalCount = new AtomicInteger(0);
    private Map<B, AtomicInteger> partitionCount = new ConcurrentHashMap<B, AtomicInteger>();

    public int getTotalCount() {
        return this.totalCount.get();
    }

    public int getCount(B block) {
        AtomicInteger count = this.partitionCount.get(block);
        return count != null ? count.get() : 0;
    }

    public synchronized int addElement(B block) {
        return this.unsafeAddElement(block);
    }

    public synchronized int remElement(B block) {
        return this.unsafeRemElement(block);
    }

    public synchronized void init(B block, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("The initial count can't be negative.");
        }
        if (this.partitionCount.containsKey(block)) {
            throw new IllegalArgumentException("The block " + block + " was already initialized.");
        }
        this.partitionCount.put(block, new AtomicInteger(count));
        this.totalCount.addAndGet(count);
    }

    public Set<B> getPartition() {
        return this.partitionCount.keySet();
    }

    protected int unsafeAddElement(B block) {
        AtomicInteger count = this.partitionCount.get(block);
        if (count == null) {
            count = new AtomicInteger(0);
            this.partitionCount.put(block, count);
        }
        this.totalCount.incrementAndGet();
        return count.incrementAndGet();
    }

    protected int unsafeRemElement(B block) {
        AtomicInteger blockCount = this.partitionCount.get(block);
        if (blockCount == null) {
            throw new NoSuchElementException("The block " + block + " is empty, no more elements can be removed");
        }
        int currentCount = blockCount.decrementAndGet();
        if (currentCount < 1) {
            this.partitionCount.remove(block);
        }
        this.totalCount.decrementAndGet();
        return currentCount;
    }
}

