/*
 * Decompiled with CFR 0.152.
 */
package org.nerd4j.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtil {
    private static Logger logger = LoggerFactory.getLogger(ReflectionUtil.class);
    private static final Pattern getterPattern = Pattern.compile("^(?:get|is)([A-Z]{1})(.*)$");
    private static final Map<Class<?>, Class<?>> PRIMITIVES = new HashMap();

    public static Field findField(Class<?> fieldType, String fieldName, Class<?> clazz) throws SecurityException, NullPointerException {
        if (clazz == null || fieldName == null || fieldType == null) {
            throw new NullPointerException("Neither class or fieldName or fieldType can be null.");
        }
        for (Class<?> currClazz = clazz; currClazz != null; currClazz = currClazz.getSuperclass()) {
            try {
                Field field;
                Class<?> currFieldType;
                if (logger.isDebugEnabled()) {
                    logger.debug("Looking for field " + currClazz.getCanonicalName() + "." + fieldName + ".");
                }
                if ((currFieldType = (field = currClazz.getDeclaredField(fieldName)).getType()).isAssignableFrom(fieldType)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Field " + fieldName + " found in " + currClazz.getSimpleName() + ".");
                    }
                    return field;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Field " + fieldName + " found in " + currClazz.getSimpleName() + " but with an incompatible type " + currFieldType.getCanonicalName() + ", requested " + fieldType.getCanonicalName() + ".");
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("The field " + currClazz.getCanonicalName() + "." + fieldName + " doesn't exists; looking for it in superclass.");
        }
        if (logger.isErrorEnabled()) {
            logger.error("Field " + fieldName + " cannot be found in class " + clazz.getCanonicalName() + " or any superclass.");
        }
        return null;
    }

    public static <A extends Annotation> Map<Field, A> findAnnotatedFields(Class<A> annotationClass, Class<?> clazz) throws NullPointerException {
        if (annotationClass == null || clazz == null) {
            throw new NullPointerException("Annotation and class cannot be null.");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Looking for anntation " + annotationClass.getCanonicalName() + " in class " + clazz.getCanonicalName() + ".");
        }
        HashMap<Field, A> result = new HashMap<Field, A>();
        for (Class<?> currClazz = clazz; currClazz != null; currClazz = currClazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = currClazz.getDeclaredFields()) {
                A annotation = field.getAnnotation(annotationClass);
                if (annotation == null) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace("Found anntation " + annotationClass.getCanonicalName() + " on field " + field + ".");
                }
                result.put(field, annotation);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Found " + result.size() + " " + annotationClass.getCanonicalName() + " annoted field in class " + clazz.getCanonicalName() + " and its superclasses.");
        }
        return result;
    }

    public static <A extends Annotation> Map<Method, A> findAnnotatedMethods(Class<A> annotationClass, Class<?> clazz) throws NullPointerException {
        if (annotationClass == null || clazz == null) {
            throw new NullPointerException("Annotation and class cannot be null.");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Looking for anntation " + annotationClass.getCanonicalName() + " in class " + clazz.getCanonicalName() + ".");
        }
        HashMap<Method, A> result = new HashMap<Method, A>();
        for (Class<?> currClazz = clazz; currClazz != null; currClazz = currClazz.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = currClazz.getDeclaredMethods()) {
                A annotation;
                if (method.isSynthetic() || method.isBridge() || (annotation = method.getAnnotation(annotationClass)) == null) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace("Found anntation " + annotationClass.getCanonicalName() + " on method " + method + ".");
                }
                result.put(method, annotation);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Found " + result.size() + " " + annotationClass.getCanonicalName() + " annoted method in class " + clazz.getCanonicalName() + " and its superclasses.");
        }
        return result;
    }

    public static Method findPublicMethod(String methodName, Class<?> clazz) throws NullPointerException {
        if (methodName == null || methodName.isEmpty() || clazz == null) {
            if (logger.isErrorEnabled()) {
                logger.error("Method name and class cannot be null.");
            }
            throw new NullPointerException("Method name and class cannot be null.");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Looking for public method " + methodName + " in class " + clazz.getCanonicalName() + ".");
        }
        try {
            Method method = clazz.getMethod(methodName, null);
            if (logger.isDebugEnabled()) {
                logger.debug("Public method " + methodName + " found in class " + clazz.getCanonicalName() + ".");
            }
            return method;
        }
        catch (NoSuchMethodException ex) {
            if (logger.isWarnEnabled()) {
                logger.warn("Public method " + methodName + " cannot be found!");
            }
            return null;
        }
    }

    public static Method findMethod(String name, Class<?> clazz) throws SecurityException, NullPointerException {
        return ReflectionUtil.findMethod(name, null, clazz);
    }

    public static Method findMethod(String name, Class<?>[] parameterTypes, Class<?> clazz) throws SecurityException, NullPointerException {
        if (name == null || name.isEmpty() || clazz == null) {
            if (logger.isErrorEnabled()) {
                logger.error("Method name and class cannot be null.");
            }
            throw new NullPointerException("Method name and class cannot be null.");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Looking for method {} with parameter types {} in class {} hierarchy.", new Object[]{name, parameterTypes, clazz.getSimpleName()});
        }
        Method method = null;
        Class<?> currClazz = clazz;
        while (true) {
            try {
                method = currClazz.getDeclaredMethod(name, parameterTypes);
                logger.debug("Found matching method {} in class {} hierarchy.", (Object)method, clazz);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if ((currClazz = currClazz.getSuperclass()) != null) continue;
                if (logger.isWarnEnabled()) {
                    logger.warn("Hierarchy root reached; method {} with parameter types {} cannot be found in class {} hierarchy!", new Object[]{name, parameterTypes, clazz.getSimpleName()});
                }
                return null;
            }
            break;
        }
    }

    public static Method findGetter(String property, Class<?> clazz) throws SecurityException, NullPointerException {
        if (property == null || property.isEmpty() || clazz == null) {
            logger.error("Property name and class cannot be null.");
            throw new NullPointerException("Property name and class cannot be null.");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Looking for getter for property {} in class {} hierarchy.", (Object)property, clazz);
        }
        Method method = null;
        String name = Character.toUpperCase(property.charAt(0)) + property.substring(1);
        String[] methodNames = new String[]{"get" + name, "is" + name};
        Class<?> currClazz = clazz;
        Class[] none = null;
        do {
            for (String methodName : methodNames) {
                try {
                    method = currClazz.getDeclaredMethod(methodName, none);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Found matching method {} in class {} hierarchy.", (Object)method, clazz);
                    }
                    return method;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        } while ((currClazz = currClazz.getSuperclass()) != null);
        if (logger.isWarnEnabled()) {
            logger.warn("Hierarchy root reached; a getter for property {} cannot be found!", (Object)property);
        }
        return null;
    }

    public static Method findPublicSetter(String property, Class<?> clazz) throws SecurityException, NullPointerException {
        Method[] allPublicMethods;
        if (property == null || property.isEmpty() || clazz == null) {
            logger.error("Property name and class cannot be null.");
            throw new NullPointerException("Property name and class cannot be null.");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Looking for public setter for property {} in class {} hierarchy.", (Object)property, clazz);
        }
        String setterName = "set" + Character.toUpperCase(property.charAt(0)) + property.substring(1);
        LinkedList<Method> setters = new LinkedList<Method>();
        for (Method method : allPublicMethods = clazz.getMethods()) {
            if (method.isSynthetic() || method.isBridge() || method.getParameterTypes().length != 1 || !method.getName().equals(setterName)) continue;
            setters.add(method);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Found matching method {} in class {} hierarchy.", (Object)method, clazz);
        }
        if (setters.size() == 1) {
            return (Method)setters.get(0);
        }
        if (setters.isEmpty()) {
            if (logger.isWarnEnabled()) {
                logger.warn("A public setter for property {} cannot be found!", (Object)property);
            }
            return null;
        }
        Method getter = ReflectionUtil.findPublicGetter(property, clazz);
        if (getter != null) {
            for (Method setter : setters) {
                if (!getter.getReturnType().equals(setter.getParameterTypes()[0])) continue;
                return setter;
            }
        }
        Field field = null;
        Class<?> currentClass = clazz;
        do {
            try {
                field = currentClass.getDeclaredField(property);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            currentClass = currentClass.getSuperclass();
        } while (field == null && currentClass != null);
        if (field != null) {
            for (Method setter : setters) {
                if (!field.getType().equals(setter.getParameterTypes()[0])) continue;
                return setter;
            }
        }
        return null;
    }

    public static Method findPublicGetter(String property, Class<?> clazz) throws SecurityException, NullPointerException {
        if (property == null || property.isEmpty() || clazz == null) {
            logger.error("Property name and class cannot be null.");
            throw new NullPointerException("Property name and class cannot be null.");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Looking for public getter for property {} in class {} hierarchy.", (Object)property, clazz);
        }
        Method method = null;
        String name = Character.toUpperCase(property.charAt(0)) + property.substring(1);
        String[] methodNames = new String[]{"get" + name, "is" + name, "has" + name};
        Class[] none = null;
        for (String methodName : methodNames) {
            try {
                method = clazz.getMethod(methodName, none);
                if (logger.isDebugEnabled()) {
                    logger.debug("Found matching method {} in class {} hierarchy.", (Object)method, clazz);
                }
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        if (logger.isWarnEnabled()) {
            logger.warn("A public getter for property {} cannot be found!", (Object)property);
        }
        return null;
    }

    public static boolean isBoolean(Class<?> clazz) {
        return clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE);
    }

    public static boolean isGetter(Method method) {
        if (ReflectionUtil.hasParameters(method)) {
            logger.debug("Method {} has parameters.", (Object)method);
            return false;
        }
        if (!ReflectionUtil.hasReturn(method)) {
            logger.debug("Method {} returns void.", (Object)method);
            return false;
        }
        if (!getterPattern.matcher(method.getName()).matches()) {
            logger.debug("Method {} doesn't match '{}'.", (Object)method, (Object)getterPattern.pattern());
            return false;
        }
        return true;
    }

    public static String propertyFromGetter(Method method) {
        if (ReflectionUtil.hasParameters(method)) {
            logger.debug("Method {} has parameters.", (Object)method);
            return null;
        }
        if (!ReflectionUtil.hasReturn(method)) {
            logger.debug("Method {} returns void.", (Object)method);
            return null;
        }
        Matcher matcher = getterPattern.matcher(method.getName());
        if (!matcher.matches()) {
            logger.debug("Method {} doesn't match '{}'.", (Object)method, (Object)getterPattern.pattern());
            return null;
        }
        return matcher.group(1).toLowerCase() + matcher.group(2);
    }

    public static boolean hasParameters(Method method) {
        return method.getParameterTypes().length != 0;
    }

    public static boolean hasReturn(Method method) {
        Class<?> returnType = method.getReturnType();
        return !returnType.equals(Void.TYPE) && !returnType.equals(Void.class);
    }

    public static <X> Constructor<X> findPublicConstructor(Class<X> clazz, Object[] values) throws IllegalArgumentException, SecurityException {
        Class[] types = null;
        if (values != null) {
            types = new Class[values.length];
            for (int i = 0; i < values.length; ++i) {
                Object value = values[i];
                types[i] = value == null ? null : value.getClass();
            }
        }
        return ReflectionUtil.findPublicConstructor(clazz, types);
    }

    public static <X> Constructor<X> findPublicConstructor(Class<X> clazz, Class<?>[] types) throws IllegalArgumentException, SecurityException {
        Constructor<Object> constructor = null;
        if (types == null || types.length == 0) {
            try {
                constructor = clazz.getConstructor(null);
                logger.debug("Found default constructor {} in class {}", constructor, clazz);
            }
            catch (NoSuchMethodException e) {
                logger.warn("A default constructor in class {} cannot be found!", clazz);
            }
        } else {
            Constructor<?>[] constructors = clazz.getConstructors();
            int matches = 0;
            block11: for (Constructor<?> checking : constructors) {
                Compatibility compatibility = ReflectionUtil.checkCompatibility(types, checking);
                switch (compatibility) {
                    case PERFECT: {
                        matches = 1;
                        constructor = checking;
                        logger.debug("Found perfect matching constructor {}", constructor);
                        break block11;
                    }
                    case SOME: {
                        ++matches;
                        constructor = checking;
                        logger.debug("Found compatible constructor {}, looking for a better match", constructor, clazz);
                    }
                    case NONE: {
                        continue block11;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected compatibility state " + (Object)((Object)compatibility));
                    }
                }
            }
            switch (matches) {
                case 0: {
                    logger.warn("A constructor in class {} for parameters {} cannot be found!", clazz, types);
                    break;
                }
                case 1: {
                    logger.debug("Found matching constructor {} in class {}.", constructor, clazz);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Ambiguous constructor with type parameters " + Arrays.toString(types) + ". Fount " + matches);
                }
            }
        }
        return constructor;
    }

    private static Compatibility checkCompatibility(Class<?>[] types, Constructor<?> constructor) {
        Class<?>[] ctypes = constructor.getParameterTypes();
        if (ctypes.length != types.length) {
            return Compatibility.NONE;
        }
        Compatibility compatibility = Compatibility.PERFECT;
        block11: for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            Class<?> ctype = ctypes[i];
            if (type == null) {
                compatibility = Compatibility.SOME;
                continue;
            }
            if (type.equals(ctype)) {
                switch (compatibility) {
                    case PERFECT: {
                        compatibility = Compatibility.PERFECT;
                        continue block11;
                    }
                    case SOME: {
                        continue block11;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected compatibility state " + (Object)((Object)compatibility));
                    }
                }
            }
            if (ctype.isAssignableFrom(type)) {
                switch (compatibility) {
                    case PERFECT: {
                        compatibility = Compatibility.SOME;
                        continue block11;
                    }
                    case SOME: {
                        continue block11;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected compatibility state " + (Object)((Object)compatibility));
                    }
                }
            }
            boolean boxed = false;
            if (type.isPrimitive()) {
                type = PRIMITIVES.get(type);
                boxed = true;
            }
            if (ctype.isPrimitive()) {
                ctype = PRIMITIVES.get(ctype);
                boxed = true;
            }
            if (boxed && ctype.isAssignableFrom(type)) {
                switch (compatibility) {
                    case PERFECT: 
                    case SOME: {
                        compatibility = Compatibility.SOME;
                        continue block11;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected compatibility state " + (Object)((Object)compatibility));
                    }
                }
            }
            return Compatibility.NONE;
        }
        return compatibility;
    }

    static {
        PRIMITIVES.put(Boolean.TYPE, Boolean.class);
        PRIMITIVES.put(Character.TYPE, Character.class);
        PRIMITIVES.put(Byte.TYPE, Byte.class);
        PRIMITIVES.put(Short.TYPE, Short.class);
        PRIMITIVES.put(Integer.TYPE, Integer.class);
        PRIMITIVES.put(Long.TYPE, Long.class);
        PRIMITIVES.put(Float.TYPE, Float.class);
        PRIMITIVES.put(Double.TYPE, Double.class);
        PRIMITIVES.put(Void.TYPE, Void.class);
    }

    private static enum Compatibility {
        PERFECT,
        SOME,
        NONE;

    }
}

