/*
 * #%L
 * Nuiton Utils
 * 
 * $Author: tchemit $
 * $LastChangedDate: 2010-04-12 15:46:06 +0200 (lun., 12 avril 2010) $
 * $LastChangedRevision: 1821 $
 * $Id: Config.java 1821 2010-04-12 13:46:06Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-1.2.2/src/main/java/org/nuiton/util/config/Config.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.util.config;

import java.util.EnumMap;
import java.util.EnumSet;

/**
 * config contract based on a Enum to obtain properties
 *
 * @author tchemit <chemit@codelutin.com>
 */
public interface Config<E extends Enum<E>> {

    EnumMap<E, Object> getProperties();

    Object getProperty(E key);

    EnumSet<E> getUniverse();

    void setProperties(EnumMap<E, Object> properties);

    void setProperty(E key, Object value);

    void copyFrom(Object src);

    void copyFrom(Object src, EnumSet<E> keys);

    void copyTo(Object dst);

    void copyTo(Object dst, EnumSet<E> keys);


}
