/*
 * #%L
 * Nuiton Utils
 * 
 * $Author: tchemit $
 * $LastChangedDate: 2010-04-12 15:46:06 +0200 (lun., 12 avril 2010) $
 * $LastChangedRevision: 1821 $
 * $Id: SimpleConfig.java 1821 2010-04-12 13:46:06Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-1.2.2/src/main/java/org/nuiton/util/config/SimpleConfig.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.util.config;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;

/**
 * simple config implementation based on a Enum to obtain properties
 *
 * @author tchemit <chemit@codelutin.com>
 * @deprecated since 1.2.2 (will be remove soon), use {@link ApplicationConfig}
 *             instead
 */
@Deprecated
public class SimpleConfig<E extends Enum<E>> implements Config<E> {

    static protected final Log log = LogFactory.getLog(Config.class);

    protected EnumMap<E, Object> properties;

    protected final EnumSet<E> universe;

    protected final Class<E> klass;

    public SimpleConfig(Class<E> klass) {
        this.klass = klass;
        this.properties = new EnumMap<E, Object>(klass);
        this.universe = java.util.EnumSet.allOf(klass);
    }

    public SimpleConfig(Class<E> klass, EnumMap<E, Object> properties) {
        this(klass);
        setProperties(properties);
    }

    public EnumMap<E, Object> getProperties() {
        return properties.clone();
    }

    public Object getProperty(E key) {
        return properties.get(key);
    }

    public EnumSet<E> getUniverse() {
        return universe;
    }

    public void setProperties(EnumMap<E, Object> properties) {
        for (Map.Entry<E, Object> entry : properties.entrySet()) {
            setProperty(entry.getKey(), entry.getValue());
        }
    }

    public void setProperty(E key, Object value) {
        if (value == null) {
            if (properties.containsKey(key)) {
                // never keep a reference on a null value property
                properties.remove(key);
            }
        } else {
            log.info("key:" + key + ", value:" + value + ", type:" + value.getClass().getSimpleName());
            properties.put(key, value);
        }
    }

    @SuppressWarnings({"unchecked"})
    public void copyFrom(Object src) {
        copyFrom(src, getUniverse());
    }

    public void copyFrom(Object src, EnumSet<E> keys) {
        for (E key : keys) {
            Object value = null;
            try {
                value = BeanUtilsBean.getInstance().getPropertyUtils().getProperty(src, key.name());
                setProperty(key, value);
            } catch (Exception e) {
                //TODO
                log.warn("could not retreave property <" + key + ":" + value + "> on object " + src, e);
            }
        }
    }

    public void copyTo(Object dst) {
        copyTo(dst, getUniverse());
    }


    public void copyTo(Object dst, EnumSet<E> keys) {
        for (E key : keys) {
            Object value = properties.get(key);
            try {
                log.info("save " + key);
                BeanUtils.setProperty(dst, key.name(), value);
            } catch (Exception e) {
                //TODO
                log.warn("could not set property <" + key + ":" + value + "> to object " + dst, e);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (properties.isEmpty()) {
            sb.append("  empty");
        } else {
            for (Map.Entry<E, Object> entry : properties.entrySet()) {
                sb.append(", ").append(entry.getKey()).append(':').append(entry.getValue());
            }
        }
        return super.toString() + '<' + sb.toString().substring(2) + '>';
    }

}
