/*
 * #%L
 * Nuiton Utils
 * 
 * $Author: tchemit $
 * $LastChangedDate: 2010-04-12 15:46:06 +0200 (lun., 12 avril 2010) $
 * $LastChangedRevision: 1821 $
 * $Id: SimpleIdentityConfig.java 1821 2010-04-12 13:46:06Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-1.2.2/src/main/java/org/nuiton/util/config/SimpleIdentityConfig.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.util.config;

import org.nuiton.util.ApplicationConfig;

import static org.nuiton.util.config.IdentityConfigProperty.email;
import static org.nuiton.util.config.IdentityConfigProperty.firstName;
import static org.nuiton.util.config.IdentityConfigProperty.lastName;

import java.util.EnumMap;

/** @author tchemit <chemit@codelutin.com>
 * @deprecated since 1.2.2 (will be remove soon), use {@link ApplicationConfig}
 *             instead*/
@Deprecated
public class SimpleIdentityConfig extends SimpleConfig<IdentityConfigProperty> implements IdentityConfig {

    public SimpleIdentityConfig() {
        super(IdentityConfigProperty.class);
    }

    public SimpleIdentityConfig(String firstName, String lastName, String email) {
        this();
        setFirstName(firstName);
        setLastName(lastName);
        setEmail(email);
    }

    public SimpleIdentityConfig(EnumMap<IdentityConfigProperty, Object> properties) {
        super(IdentityConfigProperty.class, properties);
    }

    public String getFirstName() {
        return (String) properties.get(firstName);
    }

    public String getLastName() {
        return (String) properties.get(lastName);
    }

    public String getEmail() {
        return (String) properties.get(email);
    }

    public void setFirstName(String newFirstName) {
        setProperty(firstName, newFirstName);
    }

    public void setLastName(String newLastName) {
        setProperty(lastName, newLastName);
    }

    public void setEmail(String newEmail) {
        setProperty(email, newEmail);
    }

}
