/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class HashList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = -334941610313293930L;
    protected HashSet<E> set = new HashSet();

    public HashList() {
    }

    public HashList(Collection<? extends E> c) {
        this.addAll(c);
    }

    public HashList(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException("You can't use set method in HashList");
    }

    @Override
    public boolean add(E o) {
        boolean result = !this.contains(o);
        this.add(this.size(), o);
        return result;
    }

    @Override
    public void add(int index, E element) {
        if (this.set.add(element)) {
            super.add(index, element);
        }
    }

    @Override
    public E remove(int index) {
        if (this.set.remove(this.get(index))) {
            return super.remove(index);
        }
        return null;
    }

    @Override
    public void clear() {
        this.set.clear();
        super.clear();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        Iterator<E> e = c.iterator();
        while (e.hasNext()) {
            if (!this.add(e.next())) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean modified = false;
        Iterator<E> e = c.iterator();
        while (e.hasNext()) {
            this.add(index++, e.next());
            modified = true;
        }
        return modified;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        for (int i = toIndex - 1; i >= fromIndex; --i) {
            this.remove(i);
        }
    }

    @Override
    public boolean contains(Object elem) {
        return this.set.contains(elem);
    }

    @Override
    public Object clone() {
        HashList<E> result = new HashList<E>(this);
        return result;
    }
}

