/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ReflectUtil {
    private static Log log = LogFactory.getLog(ReflectUtil.class);

    public static boolean isConstantField(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    public static <T> List<T> getConstants(Class<?> klass, Class<T> searchingClass) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Field field : klass.getDeclaredFields()) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (!searchingClass.isAssignableFrom(field.getType()) || !ReflectUtil.isConstantField(field)) continue;
            try {
                result.add(field.get(null));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        Class<?> superClass = klass.getSuperclass();
        if (superClass != null) {
            result.addAll(ReflectUtil.getConstants(superClass, searchingClass));
        }
        return result;
    }

    public static <T> T getConstant(Class<?> klass, String fieldName) {
        try {
            Object result = null;
            Field f = klass.getDeclaredField(fieldName);
            if (ReflectUtil.isConstantField(f)) {
                f.setAccessible(true);
                result = f.get(null);
            }
            return (T)result;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Enum<T>> Class<T> getEnumClass(Class<?> type) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException(I18n._((String)"nuitonutil.error.null.parameter", (Object[])new Object[]{"type"}));
        }
        if (!type.isEnum()) {
            throw new IllegalArgumentException(I18n._((String)"nuitonutil.error.not.an.enum", (Object[])new Object[]{type}));
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method getDeclaredMethod(Class<?> klass, String methodName, boolean strict, Object ... arguments) throws IllegalArgumentException {
        Method method;
        HashSet classes = new HashSet();
        try {
            method = ReflectUtil.getDeclaredMethod(klass, methodName, classes, arguments);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Inspected classes : " + classes));
            }
            classes.clear();
        }
        if (method == null && strict) {
            throw new IllegalArgumentException("could not find method " + methodName + " on type " + klass.getName());
        }
        return method;
    }

    public static Class<?> boxType(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.class;
        }
        if (Character.TYPE.equals(type)) {
            return Character.class;
        }
        if (Byte.TYPE.equals(type)) {
            return Byte.class;
        }
        if (Short.TYPE.equals(type)) {
            return Short.class;
        }
        if (Integer.TYPE.equals(type)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(type)) {
            return Long.class;
        }
        if (Float.TYPE.equals(type)) {
            return Float.class;
        }
        if (Double.TYPE.equals(type)) {
            return Double.class;
        }
        if (Void.TYPE.equals(type)) {
            return Void.class;
        }
        return type;
    }

    public static Class<?> unboxType(Class<?> type) {
        if (type.isPrimitive()) {
            return type;
        }
        if (Boolean.class.equals(type)) {
            return Boolean.TYPE;
        }
        if (Character.class.equals(type)) {
            return Character.TYPE;
        }
        if (Byte.class.equals(type)) {
            return Byte.TYPE;
        }
        if (Short.class.equals(type)) {
            return Short.TYPE;
        }
        if (Integer.class.equals(type)) {
            return Integer.TYPE;
        }
        if (Long.class.equals(type)) {
            return Long.TYPE;
        }
        if (Float.class.equals(type)) {
            return Float.TYPE;
        }
        if (Double.class.equals(type)) {
            return Double.TYPE;
        }
        if (Void.class.equals(type)) {
            return Void.TYPE;
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Field> getAllDeclaredFields(Class<?> objectClass) {
        HashSet<Field> result = new HashSet<Field>();
        HashSet visitedClasses = new HashSet();
        try {
            ReflectUtil.getAllDeclaredFields(objectClass, visitedClasses, result);
        }
        finally {
            visitedClasses.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Method> getAllDeclaredMethods(Class<?> objectClass) {
        HashSet<Method> result = new HashSet<Method>();
        HashSet visitedClasses = new HashSet();
        try {
            ReflectUtil.getAllDeclaredMethods(objectClass, visitedClasses, result);
        }
        finally {
            visitedClasses.clear();
        }
        return result;
    }

    public static <A extends Annotation> Map<Field, A> getFieldAnnotation(Class<?> objectClass, Class<A> annotationClass) {
        Map<Field, A> result = ReflectUtil.getFieldAnnotation(objectClass, annotationClass, false);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A extends Annotation> Map<Field, A> getFieldAnnotation(Class<?> objectClass, Class<A> annotationClass, boolean deepVisit) {
        HashMap result = new HashMap();
        HashSet visitedClasses = new HashSet();
        try {
            ReflectUtil.getFieldAnnotation(objectClass, annotationClass, deepVisit, visitedClasses, result);
        }
        finally {
            visitedClasses.clear();
        }
        return result;
    }

    public static <A extends Annotation> Map<Method, A> getMethodAnnotation(Class<?> objectClass, Class<A> annotationClass) {
        Map<Method, A> result = ReflectUtil.getMethodAnnotation(objectClass, annotationClass, false);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A extends Annotation> Map<Method, A> getMethodAnnotation(Class<?> objectClass, Class<A> annotationClass, boolean deepVisit) {
        HashMap result = new HashMap();
        HashSet visitedClasses = new HashSet();
        try {
            ReflectUtil.getMethodAnnotation(objectClass, annotationClass, deepVisit, visitedClasses, result);
        }
        finally {
            visitedClasses.clear();
        }
        return result;
    }

    protected static Method getDeclaredMethod(Class<?> klass, String methodName, Set<Class<?>> visitedClasses, Object ... arguments) {
        if (visitedClasses.contains(klass)) {
            return null;
        }
        visitedClasses.add(klass);
        Method method = null;
        for (Method m : klass.getDeclaredMethods()) {
            Class<?>[] types;
            if (!methodName.equals(m.getName()) || arguments.length != (types = m.getParameterTypes()).length) continue;
            Object[] prototype = m.getParameterTypes();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found a method with same parameters size : " + m.getName() + " : " + Arrays.toString(prototype)));
            }
            int index = 0;
            boolean parametersMatches = true;
            for (Object argument : arguments) {
                Class<?> type = prototype[index++];
                if (argument == null) continue;
                Class<?> runtimeType = argument.getClass();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Test parameter [" + (index - 1) + "] : " + type + " vs  " + runtimeType));
                }
                if ((type = ReflectUtil.boxType(type)).equals(runtimeType = ReflectUtil.boxType(runtimeType)) || type.isAssignableFrom(runtimeType)) continue;
                parametersMatches = false;
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"Types are not matching.");
                break;
            }
            if (!parametersMatches) break;
            method = m;
            break;
        }
        if (method == null && klass.getSuperclass() != null) {
            method = ReflectUtil.getDeclaredMethod(klass.getSuperclass(), methodName, visitedClasses, arguments);
        }
        if (method == null) {
            Class<?> anInterface;
            Class<?>[] interfaces;
            Class<?>[] arr$ = interfaces = klass.getInterfaces();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (method = ReflectUtil.getDeclaredMethod(anInterface = arr$[i$], methodName, visitedClasses, arguments)) == null; ++i$) {
            }
        }
        return method;
    }

    protected static void getAllDeclaredFields(Class<?> objectClass, Set<Class<?>> visitedClasses, Set<Field> result) {
        Class<?>[] interfaces;
        if (visitedClasses.contains(objectClass) || Object.class.equals(objectClass)) {
            return;
        }
        visitedClasses.add(objectClass);
        Field[] declaredFields = objectClass.getDeclaredFields();
        result.addAll(Arrays.asList(declaredFields));
        Class<?> superclass = objectClass.getSuperclass();
        if (superclass != null) {
            ReflectUtil.getAllDeclaredFields(superclass, visitedClasses, result);
        }
        for (Class<?> anInterface : interfaces = objectClass.getInterfaces()) {
            ReflectUtil.getAllDeclaredFields(anInterface, visitedClasses, result);
        }
    }

    protected static void getAllDeclaredMethods(Class<?> objectClass, Set<Class<?>> visitedClasses, Set<Method> result) {
        Class<?>[] interfaces;
        if (visitedClasses.contains(objectClass) || Object.class.equals(objectClass)) {
            return;
        }
        visitedClasses.add(objectClass);
        Method[] declaredFields = objectClass.getDeclaredMethods();
        result.addAll(Arrays.asList(declaredFields));
        Class<?> superclass = objectClass.getSuperclass();
        if (superclass != null) {
            ReflectUtil.getAllDeclaredMethods(superclass, visitedClasses, result);
        }
        for (Class<?> anInterface : interfaces = objectClass.getInterfaces()) {
            ReflectUtil.getAllDeclaredMethods(anInterface, visitedClasses, result);
        }
    }

    protected static <A extends Annotation> void getFieldAnnotation(Class<?> objectClass, Class<A> annotationClass, boolean deepVisit, Set<Class<?>> visitedClasses, Map<Field, A> result) {
        if (visitedClasses.contains(objectClass) || Object.class.equals(objectClass)) {
            return;
        }
        visitedClasses.add(objectClass);
        for (Field field : objectClass.getDeclaredFields()) {
            A annotation = field.getAnnotation(annotationClass);
            if (annotation == null) continue;
            result.put(field, annotation);
        }
        if (deepVisit) {
            Class<?>[] interfaces;
            Class<?> superclass = objectClass.getSuperclass();
            if (superclass != null) {
                ReflectUtil.getFieldAnnotation(superclass, annotationClass, deepVisit, visitedClasses, result);
            }
            for (Class<?> anInterface : interfaces = objectClass.getInterfaces()) {
                ReflectUtil.getFieldAnnotation(anInterface, annotationClass, deepVisit, visitedClasses, result);
            }
        }
    }

    protected static <A extends Annotation> void getMethodAnnotation(Class<?> objectClass, Class<A> annotationClass, boolean deepVisit, Set<Class<?>> visitedClasses, Map<Method, A> result) {
        if (visitedClasses.contains(objectClass) || Object.class.equals(objectClass)) {
            return;
        }
        visitedClasses.add(objectClass);
        for (Method method : objectClass.getDeclaredMethods()) {
            A annotation = method.getAnnotation(annotationClass);
            if (annotation == null) continue;
            result.put(method, annotation);
        }
        if (deepVisit) {
            Class<?>[] interfaces;
            Class<?> superclass = objectClass.getSuperclass();
            if (superclass != null) {
                ReflectUtil.getMethodAnnotation(superclass, annotationClass, deepVisit, visitedClasses, result);
            }
            for (Class<?> anInterface : interfaces = objectClass.getInterfaces()) {
                ReflectUtil.getMethodAnnotation(anInterface, annotationClass, deepVisit, visitedClasses, result);
            }
        }
    }
}

