/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.beans;

import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.PropertyUtils;

public class BeanUtil {
    public static final String ADD_PROPERTY_CHANGE_LISTENER = "addPropertyChangeListener";
    public static final String REMOVE_PROPERTY_CHANGE_LISTENER = "removePropertyChangeListener";

    protected BeanUtil() {
    }

    public static boolean isJavaBeanCompiliant(Class<?> type) {
        try {
            type.getMethod(ADD_PROPERTY_CHANGE_LISTENER, PropertyChangeListener.class);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        try {
            type.getMethod(REMOVE_PROPERTY_CHANGE_LISTENER, PropertyChangeListener.class);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    public static void addPropertyChangeListener(PropertyChangeListener listener, Object bean) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        MethodUtils.invokeExactMethod((Object)bean, (String)ADD_PROPERTY_CHANGE_LISTENER, (Object[])new Object[]{listener}, (Class[])new Class[]{PropertyChangeListener.class});
    }

    public static void removePropertyChangeListener(PropertyChangeListener listener, Object bean) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        MethodUtils.invokeExactMethod((Object)bean, (String)REMOVE_PROPERTY_CHANGE_LISTENER, (Object[])new Object[]{listener}, (Class[])new Class[]{PropertyChangeListener.class});
    }

    public static Set<String> getReadableProperties(Class<?> beanType) {
        HashSet exploredTypes = new HashSet();
        HashSet<String> result = new HashSet<String>();
        BeanUtil.getReadableProperties(beanType, result, exploredTypes);
        result.remove("class");
        return result;
    }

    public static Set<String> getWriteableProperties(Class<?> beanType) {
        HashSet exploredTypes = new HashSet();
        HashSet<String> result = new HashSet<String>();
        BeanUtil.getWriteableProperties(beanType, result, exploredTypes);
        return result;
    }

    public static boolean isNestedReadableProperty(Class<?> beanType, String propertyName) {
        boolean result = propertyName.contains(".");
        if (result) {
            int dotIndex = propertyName.indexOf(".");
            String firstLevelProperty = propertyName.substring(0, dotIndex);
            Class<?> nestedType = BeanUtil.getReadableType(beanType, firstLevelProperty);
            if (nestedType == null) {
                result = false;
            } else {
                String rest = propertyName.substring(dotIndex + 1);
                result = BeanUtil.isNestedReadableProperty(nestedType, rest);
            }
        } else {
            Class<?> nestedType = BeanUtil.getReadableType(beanType, propertyName);
            result = nestedType != null;
        }
        return result;
    }

    public static Class<?> getReadableType(Class<?> beanType, String propertyName) {
        PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors(beanType);
        Class<?> result = null;
        for (PropertyDescriptor descriptor : descriptors) {
            String name = descriptor.getName();
            if (descriptor.getReadMethod() == null || !propertyName.equals(name)) continue;
            result = descriptor.getReadMethod().getReturnType();
            break;
        }
        if (result == null && beanType.getSuperclass() != null) {
            result = BeanUtil.getReadableType(beanType.getSuperclass(), propertyName);
        }
        if (result == null) {
            Class<?> anInterface;
            Class<?>[] interfaces;
            Class<?>[] arr$ = interfaces = beanType.getInterfaces();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (result = BeanUtil.getReadableType(anInterface = arr$[i$], propertyName)) == null; ++i$) {
            }
        }
        return result;
    }

    protected static void getReadableProperties(Class<?> beanType, Set<String> result, Set<Class<?>> exploredTypes) {
        Class<?>[] interfaces;
        if (exploredTypes.contains(beanType)) {
            return;
        }
        exploredTypes.add(beanType);
        BeanUtil.getReadableProperties(beanType, result);
        if (beanType.getSuperclass() != null) {
            BeanUtil.getReadableProperties(beanType.getSuperclass(), result, exploredTypes);
        }
        for (Class<?> anInterface : interfaces = beanType.getInterfaces()) {
            BeanUtil.getReadableProperties(anInterface, result, exploredTypes);
        }
    }

    protected static void getReadableProperties(Class<?> beanType, Set<String> result) {
        PropertyDescriptor[] descriptors;
        for (PropertyDescriptor descriptor : descriptors = PropertyUtils.getPropertyDescriptors(beanType)) {
            String name = descriptor.getName();
            if (descriptor.getReadMethod() == null) continue;
            result.add(name);
        }
    }

    protected static void getWriteableProperties(Class<?> beanType, Set<String> result, Set<Class<?>> exploredTypes) {
        Class<?>[] interfaces;
        if (exploredTypes.contains(beanType)) {
            return;
        }
        exploredTypes.add(beanType);
        BeanUtil.getWriteableProperties(beanType, result);
        if (beanType.getSuperclass() != null) {
            BeanUtil.getWriteableProperties(beanType.getSuperclass(), result, exploredTypes);
        }
        for (Class<?> anInterface : interfaces = beanType.getInterfaces()) {
            BeanUtil.getWriteableProperties(anInterface, result, exploredTypes);
        }
    }

    protected static void getWriteableProperties(Class<?> beanType, Set<String> result) {
        PropertyDescriptor[] descriptors;
        for (PropertyDescriptor descriptor : descriptors = PropertyUtils.getPropertyDescriptors(beanType)) {
            String name = descriptor.getName();
            if (descriptor.getReadMethod() == null) continue;
            result.add(name);
        }
    }
}

