/*
 * Decompiled with CFR 0.152.
 */
package org.objenesis.tck;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.objenesis.tck.Reporter;

public class TextReporter
implements Reporter {
    private final PrintStream summary;
    private final PrintStream log;
    private long startTime;
    private long totalTime = 0L;
    private int errorCount = 0;
    private SortedSet allCandidates = new TreeSet();
    private SortedSet allInstantiators = new TreeSet();
    private String currentObjenesis;
    private String currentCandidate;
    private Map objenesisResults = new HashMap();
    private String platformDescription;

    public TextReporter(PrintStream summary, PrintStream log) {
        this.summary = summary;
        this.log = log;
    }

    public void startTests(String platformDescription, Collection allCandidates, Collection allInstantiators) {
        this.platformDescription = platformDescription;
        this.allCandidates.addAll(allCandidates);
        this.allInstantiators.addAll(allInstantiators);
        Iterator it = allInstantiators.iterator();
        while (it.hasNext()) {
            this.objenesisResults.put(it.next(), new HashMap());
        }
        this.startTime = System.currentTimeMillis();
    }

    public void startTest(String candidateDescription, String objenesisDescription) {
        this.currentCandidate = candidateDescription;
        this.currentObjenesis = objenesisDescription;
    }

    public void result(boolean instantiatedObject) {
        if (!instantiatedObject) {
            ++this.errorCount;
        }
        ((Map)this.objenesisResults.get(this.currentObjenesis)).put(this.currentCandidate, new Result(this.currentObjenesis, this.currentCandidate, instantiatedObject, null));
    }

    public void exception(Exception exception) {
        ++this.errorCount;
        ((Map)this.objenesisResults.get(this.currentObjenesis)).put(this.currentCandidate, new Result(this.currentObjenesis, this.currentCandidate, false, exception));
    }

    public void endTest() {
    }

    public void endTests() {
        this.totalTime += System.currentTimeMillis() - this.startTime;
    }

    public void printResult(boolean parentConstructorTest) {
        this.summary.println("Running TCK on platform: " + this.platformDescription);
        this.summary.println();
        this.summary.println("Not serializable parent constructor called: " + (parentConstructorTest ? (char)'Y' : 'N'));
        this.summary.println();
        if (!parentConstructorTest) {
            ++this.errorCount;
        }
        int maxObjenesisWidth = this.lengthOfLongestStringIn(this.allInstantiators);
        int maxCandidateWidth = this.lengthOfLongestStringIn(this.allCandidates);
        this.summary.print(this.pad("", maxCandidateWidth) + ' ');
        Iterator it = this.allInstantiators.iterator();
        while (it.hasNext()) {
            String desc = (String)it.next();
            this.summary.print(this.pad(desc, maxObjenesisWidth) + ' ');
        }
        this.summary.println();
        ArrayList<Result> exceptions = new ArrayList<Result>();
        Iterator it2 = this.allCandidates.iterator();
        while (it2.hasNext()) {
            String candidateDesc = (String)it2.next();
            this.summary.print(this.pad(candidateDesc, maxCandidateWidth) + ' ');
            Iterator itInst = this.allInstantiators.iterator();
            while (itInst.hasNext()) {
                String instDesc = (String)itInst.next();
                Result result = (Result)((Map)this.objenesisResults.get(instDesc)).get(candidateDesc);
                if (result == null) {
                    this.summary.print(this.pad("N/A", maxObjenesisWidth) + " ");
                    continue;
                }
                this.summary.print(this.pad(result.result ? "Y" : "n", maxObjenesisWidth) + " ");
                if (result.exception == null) continue;
                exceptions.add(result);
            }
            this.summary.println();
        }
        this.summary.println();
        if (this.errorCount != 0) {
            it2 = exceptions.iterator();
            while (it2.hasNext()) {
                Result element = (Result)it2.next();
                this.log.println("--- Candidate '" + element.candidateDescription + "', Instantiator '" + element.objenesisDescription + "' ---");
                element.exception.printStackTrace(this.log);
                this.log.println();
            }
            this.log.println();
            this.summary.println("--- FAILED: " + this.errorCount + " error(s) occured ---");
        } else {
            this.summary.println("--- SUCCESSFUL: TCK tests passed without errors in " + this.totalTime + " ms");
        }
        this.summary.println();
    }

    private String pad(String text, int width) {
        if (text.length() == width) {
            return text;
        }
        if (text.length() > width) {
            return text.substring(0, width);
        }
        StringBuffer padded = new StringBuffer(text);
        while (padded.length() < width) {
            padded.append(' ');
        }
        return padded.toString();
    }

    private int lengthOfLongestStringIn(Collection descriptions) {
        int result = 0;
        Iterator it = descriptions.iterator();
        while (it.hasNext()) {
            result = Math.max(result, ((String)it.next()).length());
        }
        return result;
    }

    private static class Result {
        String objenesisDescription;
        String candidateDescription;
        boolean result;
        Exception exception;

        public Result(String objenesisDescription, String candidateDescription, boolean result, Exception exception) {
            this.objenesisDescription = objenesisDescription;
            this.candidateDescription = candidateDescription;
            this.result = result;
            this.exception = exception;
        }
    }
}

