/*
 * Decompiled with CFR 0.152.
 */
package org.onepf.opfiab.google;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.util.HashMap;
import java.util.Map;
import org.onepf.opfiab.google.GoogleSkuResolver;
import org.onepf.opfiab.model.billing.SkuType;
import org.onepf.opfiab.sku.MapSkuResolver;

public class GoogleMapSkuResolver
implements GoogleSkuResolver {
    protected final MapSkuResolver mapSkuResolver = new MapSkuResolver();
    protected final Map<String, SkuType> typeMap = new HashMap<String, SkuType>();

    public void add(@NonNull String sku, @Nullable String resolvedSku, @NonNull SkuType skuType) {
        this.typeMap.put(sku, skuType);
        if (!TextUtils.isEmpty((CharSequence)resolvedSku)) {
            this.typeMap.put(resolvedSku, skuType);
            this.mapSkuResolver.add(sku, resolvedSku);
        }
    }

    public void add(@NonNull String sku, @NonNull SkuType skuType) {
        this.add(sku, null, skuType);
    }

    @NonNull
    public String resolve(@NonNull String sku) {
        return this.mapSkuResolver.resolve(sku);
    }

    @NonNull
    public String revert(@NonNull String resolvedSku) {
        return this.mapSkuResolver.revert(resolvedSku);
    }

    @Override
    @NonNull
    public SkuType resolveType(@NonNull String sku) {
        SkuType skuType = this.typeMap.get(sku);
        return skuType != null ? skuType : SkuType.UNKNOWN;
    }
}

