/*
 * Decompiled with CFR 0.152.
 */
package org.onepf.opfiab.google.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import org.onepf.opfiab.model.billing.SkuType;

public enum ItemType {
    SUBSCRIPTION("subs"),
    CONSUMABLE_OR_ENTITLEMENT("inapp");

    private final String code;

    @Nullable
    public static ItemType fromCode(@Nullable String code) {
        if (code == null) {
            return null;
        }
        for (ItemType type : ItemType.values()) {
            if (!type.code.equals(code)) continue;
            return type;
        }
        return null;
    }

    @Nullable
    public static ItemType fromSkuType(@NonNull SkuType skuType) {
        switch (skuType) {
            case SUBSCRIPTION: {
                return SUBSCRIPTION;
            }
            case CONSUMABLE: 
            case ENTITLEMENT: {
                return CONSUMABLE_OR_ENTITLEMENT;
            }
        }
        return null;
    }

    private ItemType(String code) {
        this.code = code;
    }

    public String toString() {
        return this.code;
    }
}

