/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.device;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.onlab.packet.VlanId;
import org.onosproject.net.device.DeviceInterfaceDescription;

public class DefaultDeviceInterfaceDescription
implements DeviceInterfaceDescription {
    private String name;
    private DeviceInterfaceDescription.Mode mode;
    private List<VlanId> vlans;
    private boolean isRateLimited;
    private short rateLimit;

    public DefaultDeviceInterfaceDescription(String name, DeviceInterfaceDescription.Mode mode, List<VlanId> vlans, boolean isRateLimited, short rateLimit) {
        this.name = name;
        this.mode = mode != null ? mode : DeviceInterfaceDescription.Mode.NORMAL;
        this.vlans = vlans != null ? vlans : Lists.newArrayList();
        this.isRateLimited = isRateLimited;
        this.rateLimit = rateLimit;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public DeviceInterfaceDescription.Mode mode() {
        return this.mode;
    }

    @Override
    public List<VlanId> vlans() {
        return this.vlans;
    }

    @Override
    public boolean isRateLimited() {
        return this.isRateLimited;
    }

    @Override
    public short rateLimit() {
        return this.rateLimit;
    }

    public boolean equals(Object other) {
        if (!(other instanceof DefaultDeviceInterfaceDescription)) {
            return false;
        }
        DefaultDeviceInterfaceDescription otherInterface = (DefaultDeviceInterfaceDescription)other;
        return Objects.equals(this.name, otherInterface.name) && Objects.equals((Object)this.mode, (Object)otherInterface.mode) && Objects.equals(this.vlans, otherInterface.vlans) && Objects.equals(this.isRateLimited, otherInterface.isRateLimited) && Objects.equals(this.rateLimit, otherInterface.rateLimit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.mode, this.vlans, this.isRateLimited, this.rateLimit});
    }
}

