/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.domain.DomainIntent;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Key;

@Beta
public class DomainPointToPointIntent
extends DomainIntent {
    private final List<Link> links;

    private DomainPointToPointIntent(ApplicationId appId, Key key, int priority, FilteredConnectPoint filteredIngressPoint, FilteredConnectPoint filteredEgressPoint, TrafficTreatment treatment, List<Constraint> constraints, List<Link> links) {
        super(appId, key, DomainPointToPointIntent.resources(links), priority, (Set<FilteredConnectPoint>)ImmutableSet.of((Object)filteredIngressPoint), (Set<FilteredConnectPoint>)ImmutableSet.of((Object)filteredEgressPoint), treatment, constraints);
        this.links = links;
    }

    protected DomainPointToPointIntent() {
        this.links = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<Link> links() {
        return this.links;
    }

    protected static Collection<NetworkResource> resources(Collection<Link> links) {
        Preconditions.checkNotNull(links, (Object)"links cannot be null");
        return ImmutableSet.copyOf(links);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id()).add("key", (Object)this.key()).add("appId", (Object)this.appId()).add("priority", this.priority()).add("resources", this.resources()).add("filtered ingress", this.filteredIngressPoints()).add("filtered egress", this.filteredEgressPoints()).toString();
    }

    public static final class Builder
    extends DomainIntent.Builder {
        private FilteredConnectPoint filteredIngressPoint;
        private FilteredConnectPoint filteredEgressPoint;
        private List<Link> links;

        private Builder() {
        }

        @Override
        public Builder appId(ApplicationId appId) {
            this.appId = appId;
            return this;
        }

        @Override
        public Builder key(Key key) {
            this.key = key;
            return this;
        }

        @Override
        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public Builder treatment(TrafficTreatment treatment) {
            this.treatment = treatment;
            return this;
        }

        @Override
        public Builder constraints(List<Constraint> constraints) {
            this.constraints = ImmutableList.copyOf(constraints);
            return this;
        }

        public Builder filteredIngressPoint(FilteredConnectPoint ingressPoint) {
            this.filteredIngressPoint = ingressPoint;
            return this;
        }

        public Builder filteredEgressPoint(FilteredConnectPoint egressPoint) {
            this.filteredEgressPoint = egressPoint;
            return this;
        }

        public Builder links(List<Link> links) {
            this.links = ImmutableList.copyOf(links);
            return this;
        }

        public DomainPointToPointIntent build() {
            return new DomainPointToPointIntent(this.appId, this.key, this.priority, this.filteredIngressPoint, this.filteredEgressPoint, this.treatment, this.constraints, this.links);
        }
    }
}

