/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.onosproject.net.flow.Extension;
import org.onosproject.net.flow.instructions.ExtensionPropertyException;

public abstract class AbstractExtension
implements Extension {
    private static final String INVALID_KEY = "Invalid property key: ";
    private static final String INVALID_TYPE = "Given type does not match field type: ";

    @Override
    public <T> void setPropertyValue(String key, T value) throws ExtensionPropertyException {
        Class<?> clazz = this.getClass();
        try {
            Field field = clazz.getDeclaredField(key);
            field.setAccessible(true);
            field.set(this, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExtensionPropertyException(INVALID_KEY + key);
        }
    }

    @Override
    public <T> T getPropertyValue(String key) throws ExtensionPropertyException {
        Class<?> clazz = this.getClass();
        try {
            Field field = clazz.getDeclaredField(key);
            field.setAccessible(true);
            Object result = field.get(this);
            return (T)result;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExtensionPropertyException(INVALID_KEY + key);
        }
        catch (ClassCastException e) {
            throw new ExtensionPropertyException(INVALID_TYPE + key);
        }
    }

    @Override
    public List<String> getProperties() {
        Class<?> clazz = this.getClass();
        ArrayList<String> fields = new ArrayList<String>();
        for (Field field : clazz.getDeclaredFields()) {
            fields.add(field.getName());
        }
        return fields;
    }
}

