/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.statistic;

import com.google.common.base.Preconditions;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.DefaultTypedFlowEntry;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.TypedStoredFlowEntry;
import org.onosproject.net.statistic.DefaultLoad;
import org.onosproject.net.statistic.Load;
import org.onosproject.net.statistic.PollInterval;

public class TypedFlowEntryWithLoad {
    private final ConnectPoint cp;
    private final TypedStoredFlowEntry tfe;
    private final Load load;

    public TypedFlowEntryWithLoad(ConnectPoint cp, TypedStoredFlowEntry tfe, Load load) {
        this.cp = cp;
        this.tfe = tfe;
        this.load = load;
    }

    public TypedFlowEntryWithLoad(ConnectPoint cp, TypedStoredFlowEntry tfe) {
        this.cp = cp;
        this.tfe = tfe;
        this.load = new DefaultLoad(tfe.bytes(), 0L, TypedFlowEntryWithLoad.typedPollInterval(tfe));
    }

    public TypedFlowEntryWithLoad(ConnectPoint cp, FlowEntry fe) {
        this.cp = cp;
        this.tfe = TypedFlowEntryWithLoad.newTypedStoredFlowEntry(fe);
        this.load = new DefaultLoad(fe.bytes(), 0L, TypedFlowEntryWithLoad.typedPollInterval(this.tfe));
    }

    public ConnectPoint connectPoint() {
        return this.cp;
    }

    public TypedStoredFlowEntry typedStoredFlowEntry() {
        return this.tfe;
    }

    public Load load() {
        return this.load;
    }

    public static long typedPollInterval(TypedStoredFlowEntry tfe) {
        Preconditions.checkNotNull((Object)tfe, (Object)"TypedStoredFlowEntry cannot be null");
        PollInterval pollIntervalInstance = PollInterval.getInstance();
        switch (tfe.flowLiveType()) {
            case LONG_FLOW: {
                return pollIntervalInstance.getLongPollInterval();
            }
            case MID_FLOW: {
                return pollIntervalInstance.getMidPollInterval();
            }
        }
        return pollIntervalInstance.getPollInterval();
    }

    public static TypedStoredFlowEntry newTypedStoredFlowEntry(FlowEntry fe) {
        if (fe == null) {
            return null;
        }
        long life = fe.life();
        PollInterval pollIntervalInstance = PollInterval.getInstance();
        if (life < 0L) {
            return new DefaultTypedFlowEntry(fe, TypedStoredFlowEntry.FlowLiveType.UNKNOWN_FLOW);
        }
        if (life < pollIntervalInstance.getPollInterval()) {
            return new DefaultTypedFlowEntry(fe, TypedStoredFlowEntry.FlowLiveType.IMMEDIATE_FLOW);
        }
        if (life < pollIntervalInstance.getMidPollInterval()) {
            return new DefaultTypedFlowEntry(fe, TypedStoredFlowEntry.FlowLiveType.SHORT_FLOW);
        }
        if (life < pollIntervalInstance.getLongPollInterval()) {
            return new DefaultTypedFlowEntry(fe, TypedStoredFlowEntry.FlowLiveType.MID_FLOW);
        }
        return new DefaultTypedFlowEntry(fe, TypedStoredFlowEntry.FlowLiveType.LONG_FLOW);
    }
}

