/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.model.topo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.onosproject.net.DeviceId;
import org.onosproject.net.HostId;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionId;
import org.onosproject.ui.model.topo.UiDevice;
import org.onosproject.ui.model.topo.UiDeviceLink;
import org.onosproject.ui.model.topo.UiEdgeLink;
import org.onosproject.ui.model.topo.UiHost;
import org.onosproject.ui.model.topo.UiLink;
import org.onosproject.ui.model.topo.UiModelEvent;
import org.onosproject.ui.model.topo.UiNode;
import org.onosproject.ui.model.topo.UiRegionDeviceLink;
import org.onosproject.ui.model.topo.UiRegionLink;
import org.onosproject.ui.model.topo.UiTopology;

public class UiRegion
extends UiNode {
    private static final String NULL_NAME = "(root)";
    private static final String NO_NAME = "???";
    public static final RegionId NULL_ID = RegionId.regionId("(root)");
    private static final String[] DEFAULT_LAYER_TAGS = new String[]{"opt", "pkt", "def"};
    private final Set<DeviceId> deviceIds = new HashSet<DeviceId>();
    private final Set<HostId> hostIds = new HashSet<HostId>();
    private final List<String> layerOrder = new ArrayList<String>();
    private final UiTopology topology;
    private final RegionId regionId;
    private RegionId parent;
    private final Set<RegionId> kids = new HashSet<RegionId>();

    public UiRegion(UiTopology topology, Region region) {
        this.topology = topology;
        this.regionId = region == null ? NULL_ID : region.id();
        this.setLayerOrder(DEFAULT_LAYER_TAGS);
    }

    @Override
    protected void destroy() {
        this.deviceIds.clear();
        this.hostIds.clear();
    }

    public void setLayerOrder(String ... layers) {
        this.layerOrder.clear();
        Collections.addAll(this.layerOrder, layers);
    }

    public RegionId id() {
        return this.regionId;
    }

    public RegionId parent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public Set<RegionId> children() {
        return ImmutableSet.copyOf(this.kids);
    }

    public UiRegion parentRegion() {
        return this.topology.findRegion(this.parent);
    }

    public void setParent(RegionId parentId) {
        this.parent = parentId;
    }

    public void setChildren(Set<RegionId> children) {
        this.kids.clear();
        this.kids.addAll(children);
    }

    @Override
    public String idAsString() {
        return this.id().toString();
    }

    @Override
    public String name() {
        Region region = this.backingRegion();
        return region == null ? NULL_NAME : region.name();
    }

    public Region backingRegion() {
        return this.isRoot() ? null : this.topology.services.region().getRegion(this.regionId);
    }

    public void reconcileDevices(Set<DeviceId> devices) {
        this.deviceIds.clear();
        this.deviceIds.addAll(devices);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id()).add("name", (Object)this.name()).add("parent", (Object)this.parent).add("kids", this.kids).add("devices", this.deviceIds).add("#hosts", this.hostIds.size()).toString();
    }

    public Region.Type type() {
        Region region = this.backingRegion();
        return region == null ? null : region.type();
    }

    public int deviceCount() {
        return this.deviceIds.size();
    }

    public Set<DeviceId> deviceIds() {
        return ImmutableSet.copyOf(this.deviceIds);
    }

    public Set<UiDevice> devices() {
        return this.topology.deviceSet(this.deviceIds);
    }

    public void reconcileHosts(Set<HostId> hosts) {
        this.hostIds.clear();
        this.hostIds.addAll(hosts);
    }

    public Set<HostId> hostIds() {
        return ImmutableSet.copyOf(this.hostIds);
    }

    public Set<UiHost> hosts() {
        return this.topology.hostSet(this.hostIds);
    }

    public int hostCount() {
        return this.hostIds.size();
    }

    public List<String> layerOrder() {
        return Collections.unmodifiableList(this.layerOrder);
    }

    public static String safeName(Region region) {
        if (region == null) {
            return NULL_NAME;
        }
        String name = region.name();
        return Strings.isNullOrEmpty((String)name) ? NO_NAME : name;
    }

    public boolean isRelevant(UiModelEvent event) {
        switch ((UiModelEvent.Type)((Object)event.type())) {
            case CLUSTER_MEMBER_ADDED_OR_UPDATED: 
            case CLUSTER_MEMBER_REMOVED: {
                return true;
            }
            case REGION_ADDED_OR_UPDATED: 
            case REGION_REMOVED: {
                return this.isRegionRelevant(((UiRegion)event.subject()).id());
            }
            case DEVICE_ADDED_OR_UPDATED: 
            case DEVICE_REMOVED: {
                return this.isDeviceRelevant(((UiDevice)event.subject()).id());
            }
            case LINK_ADDED_OR_UPDATED: 
            case LINK_REMOVED: {
                return this.isLinkRelevant((UiLink)event.subject());
            }
            case HOST_ADDED_OR_UPDATED: 
            case HOST_MOVED: 
            case HOST_REMOVED: {
                return this.isDeviceRelevant(((UiHost)event.subject()).locationDevice());
            }
        }
        return true;
    }

    private boolean isDeviceRelevant(DeviceId deviceId) {
        return this.deviceIds.contains(deviceId);
    }

    private boolean isLinkRelevant(UiLink uiLink) {
        if (uiLink instanceof UiDeviceLink) {
            UiDeviceLink uiDeviceLink = (UiDeviceLink)uiLink;
            return this.isDeviceRelevant(uiDeviceLink.deviceA()) || this.isDeviceRelevant(uiDeviceLink.deviceB());
        }
        if (uiLink instanceof UiRegionLink) {
            UiRegionLink uiRegionLink = (UiRegionLink)uiLink;
            return this.isRegionRelevant(uiRegionLink.regionA()) || this.isRegionRelevant(uiRegionLink.regionB());
        }
        if (uiLink instanceof UiRegionDeviceLink) {
            UiRegionDeviceLink uiRegionDeviceLink = (UiRegionDeviceLink)uiLink;
            return this.isRegionRelevant(uiRegionDeviceLink.region()) || this.isDeviceRelevant(uiRegionDeviceLink.device());
        }
        if (uiLink instanceof UiEdgeLink) {
            UiEdgeLink uiEdgeLink = (UiEdgeLink)uiLink;
            return this.isDeviceRelevant(uiEdgeLink.deviceId());
        }
        return false;
    }

    private boolean isRegionRelevant(RegionId regionId) {
        return this.kids.contains((Object)regionId);
    }
}

