/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.model.topo;

import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.region.RegionId;
import org.onosproject.ui.model.topo.UiLink;
import org.onosproject.ui.model.topo.UiLinkId;
import org.onosproject.ui.model.topo.UiTopology;

public class UiRegionDeviceLink
extends UiLink {
    private static final String E_NOT_REGION_DEVICE_ID = "UI link identifier not region to device";
    private final RegionId region;
    private final DeviceId device;
    private final PortNumber port;

    public UiRegionDeviceLink(UiTopology topology, UiLinkId id) {
        super(topology, id);
        this.region = id.regionA();
        this.device = (DeviceId)id.elementB();
        this.port = id.portB();
        if (this.region == null || this.device == null || this.port == null) {
            throw new IllegalArgumentException(E_NOT_REGION_DEVICE_ID);
        }
    }

    @Override
    public String endPointA() {
        return (String)this.region.id();
    }

    @Override
    public String endPointB() {
        return this.device + "/" + this.port;
    }

    @Override
    public String endPortB() {
        return this.port.toString();
    }

    public RegionId region() {
        return this.region;
    }

    public DeviceId device() {
        return this.device;
    }

    public PortNumber port() {
        return this.port;
    }
}

