/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstackinterface.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.onlab.packet.Ip4Address;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.openstackinterface.OpenstackSubnet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenstackSubnetCodec
extends JsonCodec<OpenstackSubnet> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String SUBNET = "subnet";
    private static final String NAME = "name";
    private static final String ENABLE_DHCP = "enable_dhcp";
    private static final String NETWORK_ID = "network_id";
    private static final String TENANT_ID = "tenant_id";
    private static final String DNS_NAMESERVERS = "dns_nameservers";
    private static final String GATEWAY_IP = "gateway_ip";
    private static final String CIDR = "cidr";
    private static final String ID = "id";

    public OpenstackSubnet decode(ObjectNode json, CodecContext context) {
        Preconditions.checkNotNull((Object)json);
        JsonNode subnetInfo = json.get(SUBNET);
        if (subnetInfo == null) {
            subnetInfo = json;
        }
        String name = subnetInfo.path(NAME).asText();
        boolean enableDhcp = subnetInfo.path(ENABLE_DHCP).asBoolean();
        String networkId = subnetInfo.path(NETWORK_ID).asText();
        String tenantId = subnetInfo.path(TENANT_ID).asText();
        ArrayNode dnsNameservsers = (ArrayNode)subnetInfo.path(DNS_NAMESERVERS);
        ArrayList dnsList = Lists.newArrayList();
        if (dnsNameservsers != null && !dnsNameservsers.isMissingNode()) {
            dnsNameservsers.forEach(dns -> dnsList.add(Ip4Address.valueOf((String)dns.asText())));
        }
        String gatewayIp = subnetInfo.path(GATEWAY_IP).asText();
        String cidr = subnetInfo.path(CIDR).asText();
        String id = subnetInfo.path(ID).asText();
        OpenstackSubnet openstackSubnet = OpenstackSubnet.builder().setName(name).setEnableDhcp(enableDhcp).setNetworkId(networkId).setTenantId(tenantId).setDnsNameservers((List)dnsList).setGatewayIp(gatewayIp).setCidr(cidr).setId(id).build();
        return openstackSubnet;
    }
}

