/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.pattern;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.FatalImplementationErrorException;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.pattern.HashGenerator;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObservable<T>
implements Observable<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractObservable.class);
    private static final boolean DEFAULT_UNCHANGED_VALUE_FILTER = true;
    private static final Object DEFAULT_SOURCE = null;
    protected final boolean unchangedValueFilter;
    private boolean notificationInProgess;
    protected final Object NOTIFICATION_LOCK = new Object(){

        public String toString() {
            return "ObservableNotificationLock";
        }
    };
    private final Object OBSERVER_LOCK = new Object(){

        public String toString() {
            return "ObserverLock";
        }
    };
    private final Object NOTIFICATION_METHOD_LOCK = new Object(){

        public String toString() {
            return "notifyObserverMethodLock";
        }
    };
    protected final List<Observer<T>> observers = new ArrayList<Observer<T>>();
    protected int latestValueHash;
    private Object source;
    private ExecutorService executorService;
    private HashGenerator<T> hashGenerator;

    public AbstractObservable() {
        this(true, DEFAULT_SOURCE);
    }

    public AbstractObservable(Object source) {
        this(true, source);
    }

    public AbstractObservable(boolean unchangedValueFilter) {
        this(unchangedValueFilter, DEFAULT_SOURCE);
    }

    public AbstractObservable(boolean unchangedValueFilter, Object source) {
        this.unchangedValueFilter = unchangedValueFilter;
        this.notificationInProgess = false;
        this.source = source == DEFAULT_SOURCE ? this : source;
        this.hashGenerator = new HashGenerator<T>(){

            @Override
            public int computeHash(T value) throws CouldNotPerformException {
                try {
                    return value.hashCode();
                }
                catch (ConcurrentModificationException ex) {
                    throw new FatalImplementationErrorException("Observable has changed during hash computation in notification! Set a HashGenerator for the observable to control the hash computation yourself!", (Object)this, (Throwable)ex);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObserver(Observer<T> observer) {
        Object object = this.OBSERVER_LOCK;
        synchronized (object) {
            if (this.observers.contains(observer)) {
                LOGGER.warn("Skip observer registration. Observer[" + observer + "] is already registered!");
                return;
            }
            this.observers.add(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObserver(Observer<T> observer) {
        Object object = this.OBSERVER_LOCK;
        synchronized (object) {
            this.observers.remove(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.OBSERVER_LOCK;
        synchronized (object) {
            this.observers.clear();
        }
    }

    public boolean notifyObservers(T observable) throws MultiException, CouldNotPerformException {
        return this.notifyObservers(this, observable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean notifyObservers(final Observable<T> source, final T observable) throws MultiException, CouldNotPerformException {
        Object object = this.NOTIFICATION_METHOD_LOCK;
        synchronized (object) {
            HashMap<Observer<T>, Future<Void>> notificationFutureList;
            MultiException.ExceptionStack exceptionStack;
            block35: {
                ArrayList<Observer<T>> tempObserverList;
                if (observable == null) {
                    LOGGER.debug("Skip notification because observable is null!");
                    return false;
                }
                exceptionStack = null;
                notificationFutureList = new HashMap<Observer<T>, Future<Void>>();
                this.notificationInProgess = true;
                int observableHash = this.hashGenerator.computeHash(observable);
                if (this.unchangedValueFilter && this.isValueAvailable() && observableHash == this.latestValueHash) {
                    LOGGER.debug("Skip notification because " + this + " has not been changed!");
                    boolean bl = false;
                    return bl;
                }
                this.applyValueUpdate(observable);
                int lastHashValue = this.latestValueHash;
                this.latestValueHash = observableHash;
                Iterator<Observer<T>> iterator = this.OBSERVER_LOCK;
                synchronized (iterator) {
                    tempObserverList = new ArrayList<Observer<T>>(this.observers);
                }
                for (final Observer<T> observer : tempObserverList) {
                    if (this.executorService == null) {
                        if (Thread.currentThread().isInterrupted()) {
                            this.latestValueHash = lastHashValue;
                            boolean bl = false;
                            return bl;
                        }
                        try {
                            observer.update(source, observable);
                            continue;
                        }
                        catch (InterruptedException ex) {
                            this.latestValueHash = lastHashValue;
                            Thread.currentThread().interrupt();
                            boolean bl = false;
                            assert (observable != null);
                            this.notificationInProgess = false;
                            Object object2 = this.NOTIFICATION_LOCK;
                            synchronized (object2) {
                                this.NOTIFICATION_LOCK.notifyAll();
                                return bl;
                            }
                        }
                        catch (Exception ex) {
                            exceptionStack = MultiException.push(observer, (Exception)ex, exceptionStack);
                            continue;
                        }
                    }
                    notificationFutureList.put(observer, this.executorService.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            observer.update(source, observable);
                            return null;
                        }
                    }));
                }
                break block35;
                {
                    continue;
                    break;
                }
                finally {
                    assert (observable != null);
                    this.notificationInProgess = false;
                    Object object3 = this.NOTIFICATION_LOCK;
                    synchronized (object3) {
                        this.NOTIFICATION_LOCK.notifyAll();
                    }
                }
            }
            if (this.executorService == null) {
                for (Map.Entry notificationFuture : notificationFutureList.entrySet()) {
                    try {
                        ((Future)notificationFuture.getValue()).get();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        return true;
                    }
                    catch (Exception ex) {
                        exceptionStack = MultiException.push(notificationFuture.getKey(), (Exception)ex, (MultiException.ExceptionStack)exceptionStack);
                    }
                }
            }
            MultiException.checkAndThrow((String)("Could not notify Data[" + observable + "] to all observer!"), (MultiException.ExceptionStack)exceptionStack);
            return true;
        }
    }

    protected void applyValueUpdate(T value) {
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setHashGenerator(HashGenerator<T> hashGenerator) {
        this.hashGenerator = hashGenerator;
    }

    public boolean isNotificationInProgess() {
        return this.notificationInProgess;
    }

    public String toString() {
        return Observable.class.getSimpleName() + "[" + (this.source == this ? this.source.getClass().getSimpleName() : this.source) + "]";
    }
}

