/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.pattern;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.TimeoutException;
import org.openbase.jul.pattern.AbstractObservable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservableImpl<T>
extends AbstractObservable<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObservableImpl.class);
    private T value;
    private CompletableFuture<T> valueFuture = new CompletableFuture();

    public ObservableImpl() {
    }

    public ObservableImpl(Object source) {
        super(source);
    }

    public ObservableImpl(boolean unchangedValueFilter) {
        super(unchangedValueFilter);
    }

    public ObservableImpl(boolean unchangedValueFilter, Object source) {
        super(unchangedValueFilter, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForValue(long timeout, TimeUnit timeUnit) throws CouldNotPerformException, InterruptedException {
        Object object = this.NOTIFICATION_LOCK;
        synchronized (object) {
            if (this.value != null) {
                return;
            }
            if (timeUnit.toMillis(timeout) == 0L) {
                this.NOTIFICATION_LOCK.wait();
            } else {
                timeUnit.timedWait(this.NOTIFICATION_LOCK, timeout);
            }
            if (this.value == null) {
                throw new NotAvailableException("Observable was not available in time.", (Throwable)new TimeoutException());
            }
        }
    }

    @Override
    public T getValue() throws NotAvailableException {
        if (this.value == null) {
            throw new NotAvailableException("Value");
        }
        return this.value;
    }

    @Override
    public CompletableFuture<T> getValueFuture() {
        return this.valueFuture;
    }

    @Override
    public boolean isValueAvailable() {
        return this.value != null;
    }

    @Override
    protected void applyValueUpdate(T value) {
        this.value = value;
        this.valueFuture.complete(value);
    }
}

