/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jps.preset.JPTestMode;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.EnumNotSupportedException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.pattern.ObservableImpl;
import org.openbase.jul.processing.FileProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSynchronizer<D>
extends ObservableImpl<D> {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final FileProcessor<D> fileProcessor;
    private D data;
    private final File file;

    public FileSynchronizer(File file, FileProcessor<D> fileProcessor) throws InstantiationException {
        this(null, file, InitMode.LOAD, fileProcessor);
    }

    public FileSynchronizer(D data, File file, InitMode initMode, FileProcessor<D> fileProcessor) throws InstantiationException {
        this.fileProcessor = fileProcessor;
        this.file = file;
        try {
            switch (initMode) {
                case CREATE: {
                    this.create(data);
                    break;
                }
                case LOAD: {
                    this.load();
                    break;
                }
                case AUTO: {
                    if (file.exists()) {
                        this.load();
                        break;
                    }
                    this.create(data);
                    break;
                }
                case REPLACE: {
                    try {
                        this.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.create(data);
                    break;
                }
                default: {
                    throw new EnumNotSupportedException((Enum)initMode, null);
                }
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public final D load() throws CouldNotPerformException {
        this.logger.debug("Load " + this.file);
        this.data = this.fileProcessor.deserialize(this.file);
        return this.data;
    }

    public final File save(D data) throws CouldNotPerformException {
        this.logger.debug("Save " + data + " into " + this.file);
        try {
            if (((Boolean)((JPTestMode)JPService.getProperty(JPTestMode.class)).getValue()).booleanValue()) {
                this.logger.debug("Skip data save because " + JPTestMode.class.getSimpleName() + " is enabled!");
                return this.file;
            }
        }
        catch (JPServiceException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not access java property!", (Throwable)ex), (Logger)this.logger);
        }
        try {
            if (data == null) {
                throw new NotAvailableException("data");
            }
            this.data = data;
            if (!this.file.exists()) {
                throw new NotAvailableException(File.class, (Object)this.file, (Throwable)new InvalidStateException("File does not exist!"));
            }
            if (!this.file.canWrite()) {
                throw new InvalidStateException((Throwable)new InvalidStateException("File[" + this.file.getAbsolutePath() + "] does not provide write access!"));
            }
            return (File)this.fileProcessor.serialize(data, (Object)this.file);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not save " + data + "!", (Throwable)ex);
        }
    }

    public final File save() throws CouldNotPerformException {
        this.logger.debug("Save " + this.data + " into " + this.file);
        return this.save(this.data);
    }

    private File create(D data) throws CouldNotPerformException {
        this.logger.debug("Create " + this.file);
        try {
            if (((Boolean)((JPTestMode)JPService.getProperty(JPTestMode.class)).getValue()).booleanValue()) {
                this.logger.debug("Skip file creation because " + JPTestMode.class.getSimpleName() + " is enabled!");
                return this.file;
            }
        }
        catch (JPServiceException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not access java property!", (Throwable)ex), (Logger)this.logger);
        }
        try {
            if (data == null) {
                throw new NotAvailableException("data");
            }
            if (!this.file.createNewFile()) {
                throw new CouldNotPerformException("Could not create " + this.file + "!");
            }
        }
        catch (IOException | CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not create data entry for " + data + "!", ex);
        }
        return this.save(data);
    }

    public void delete() throws CouldNotPerformException {
        try {
            if (((Boolean)((JPTestMode)JPService.getProperty(JPTestMode.class)).getValue()).booleanValue()) {
                this.logger.debug("Skip file deletion because " + JPTestMode.class.getSimpleName() + " is enabled!");
                return;
            }
        }
        catch (JPServiceException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not access java property!", (Throwable)ex), (Logger)this.logger);
        }
        try {
            if (!this.file.exists()) {
                throw new FileNotFoundException(this.file.getAbsolutePath());
            }
            if (!this.file.delete()) {
                throw new CouldNotPerformException("Could not delete File[" + this.file.getAbsolutePath() + "]!");
            }
        }
        catch (FileNotFoundException | NullPointerException | CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not delete database " + this.file + "!", ex);
        }
    }

    public D getData() throws NotAvailableException {
        if (this.data == null) {
            throw new NotAvailableException("data");
        }
        return this.data;
    }

    public File getFile() {
        return this.file;
    }

    public static enum InitMode {
        AUTO,
        CREATE,
        LOAD,
        REPLACE;

    }
}

