/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.FatalImplementationErrorException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.RejectedException;
import org.openbase.jul.exception.VerificationFailedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.exception.printer.LogLevelFilter;
import org.openbase.jul.exception.printer.Printer;
import org.openbase.jul.iface.Identifiable;
import org.openbase.jul.iface.Shutdownable;
import org.openbase.jul.pattern.HashGenerator;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.ObservableImpl;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.RecurrenceEventFilter;
import org.openbase.jul.storage.registry.ConsistencyHandler;
import org.openbase.jul.storage.registry.MockRegistrySandbox;
import org.openbase.jul.storage.registry.Registry;
import org.openbase.jul.storage.registry.RegistrySandbox;
import org.openbase.jul.storage.registry.RemoteRegistry;
import org.openbase.jul.storage.registry.plugin.RegistryPlugin;
import org.openbase.jul.storage.registry.plugin.RegistryPluginPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractRegistry<KEY, ENTRY extends Identifiable<KEY>, MAP extends Map<KEY, ENTRY>, R extends Registry<KEY, ENTRY>, P extends RegistryPlugin<KEY, ENTRY>>
extends ObservableImpl<Map<KEY, ENTRY>>
implements Registry<KEY, ENTRY> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String name;
    private final MAP entryMap;
    private final Random randomJitter;
    protected final RegistryPluginPool<KEY, ENTRY, P> pluginPool;
    protected RegistrySandbox<KEY, ENTRY, MAP, R> sandbox;
    protected boolean consistent;
    private final ReentrantReadWriteLock registryLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock consistencyCheckLock = new ReentrantReadWriteLock();
    private final Set<Registry> lockedRegistries = new HashSet<Registry>();
    private int lockCounter = 0;
    private final List<ConsistencyHandler<KEY, ENTRY, MAP, R>> consistencyHandlerList;
    private final Map<Registry, DependencyConsistencyCheckTrigger> dependingRegistryMap;
    private final ObservableImpl<Map<KEY, ENTRY>> dependingRegistryObservable;
    private RecurrenceEventFilter<String> consistencyFeedbackEventFilter;
    private boolean notificationSkipped;
    private boolean shutdownInitiated = false;

    public AbstractRegistry(MAP entryMap) throws InstantiationException {
        this(entryMap, new RegistryPluginPool());
    }

    public AbstractRegistry(MAP entryMap, RegistryPluginPool<KEY, ENTRY, P> pluginPool) throws InstantiationException {
        try {
            if (entryMap == null) {
                throw new NotAvailableException("entryMap");
            }
            if (pluginPool == null) {
                throw new NotAvailableException("pluginPool");
            }
            this.randomJitter = new Random(System.currentTimeMillis());
            this.consistent = true;
            this.notificationSkipped = false;
            this.entryMap = entryMap;
            this.pluginPool = pluginPool;
            this.pluginPool.init(this);
            this.consistencyHandlerList = new ArrayList<ConsistencyHandler<KEY, ENTRY, MAP, R>>();
            this.dependingRegistryMap = new HashMap<Registry, DependencyConsistencyCheckTrigger>();
            this.sandbox = new MockRegistrySandbox(this);
            this.dependingRegistryObservable = new ObservableImpl();
            this.consistencyFeedbackEventFilter = new RecurrenceEventFilter<String>(10000L){

                public void relay() throws Exception {
                    AbstractRegistry.this.log((String)this.getLatestValue());
                }
            };
            this.setHashGenerator(new HashGenerator<Map<KEY, ENTRY>>(){

                public int computeHash(Map<KEY, ENTRY> value) throws CouldNotPerformException {
                    try {
                        AbstractRegistry.this.registryLock.readLock().lock();
                        int n = value.hashCode();
                        return n;
                    }
                    finally {
                        AbstractRegistry.this.registryLock.readLock().unlock();
                    }
                }
            });
            this.finishTransaction();
            this.notifyObservers();
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    protected <S extends AbstractRegistry<KEY, ENTRY, MAP, R, P>> void setupSandbox(S sandbox) throws CouldNotPerformException {
        RegistrySandbox oldSandbox = (RegistrySandbox)((Object)sandbox);
        try {
            if (sandbox == null) {
                throw new NotAvailableException("sandbox");
            }
            this.sandbox = (RegistrySandbox)((Object)sandbox);
            this.sandbox.sync(this.entryMap);
            for (ConsistencyHandler<KEY, ENTRY, MAP, R> consistencyHandler : this.consistencyHandlerList) {
                this.sandbox.registerConsistencyHandler(consistencyHandler);
            }
        }
        catch (CouldNotPerformException ex) {
            this.sandbox = oldSandbox;
            throw new CouldNotPerformException("Could not setup sandbox!", (Throwable)ex);
        }
    }

    @Override
    public ENTRY register(ENTRY entry) throws CouldNotPerformException {
        if (entry == null) {
            throw new NotAvailableException("entry");
        }
        this.log("Register " + entry + "...");
        try {
            this.checkWriteAccess();
            this.lock();
            try {
                if (this.entryMap.containsKey(entry.getId())) {
                    throw new CouldNotPerformException("Could not register " + entry + "! Entry with same Id[" + entry.getId() + "] already registered!");
                }
                this.sandbox.register(entry);
                this.pluginPool.beforeRegister(entry);
                this.entryMap.put((Object)entry.getId(), entry);
                this.finishTransaction();
                this.pluginPool.afterRegister(entry);
            }
            finally {
                this.unlock();
            }
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not register " + entry + " in " + this + "!", (Throwable)ex);
        }
        finally {
            this.syncSandbox();
        }
        this.notifyObservers();
        return this.get((KEY)entry);
    }

    public ENTRY load(ENTRY entry) throws CouldNotPerformException {
        if (entry == null) {
            throw new NotAvailableException("entry");
        }
        this.logger.debug("Load " + entry + "...");
        try {
            this.lock();
            try {
                if (this.entryMap.containsKey(entry.getId())) {
                    throw new CouldNotPerformException("Could not register " + entry + "! Entry with same Id[" + entry.getId() + "] already registered!");
                }
                this.sandbox.load(entry);
                this.pluginPool.beforeRegister(entry);
                this.entryMap.put((Object)entry.getId(), entry);
                this.pluginPool.afterRegister(entry);
            }
            finally {
                this.unlock();
            }
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not register " + entry + " in " + this + "!", (Throwable)ex);
        }
        finally {
            this.syncSandbox();
        }
        return entry;
    }

    @Override
    public ENTRY update(ENTRY entry) throws CouldNotPerformException {
        if (entry == null) {
            throw new NotAvailableException("entry");
        }
        this.log("Update " + entry + "...");
        try {
            this.checkWriteAccess();
            this.lock();
            try {
                if (!this.entryMap.containsKey(entry.getId())) {
                    throw new InvalidStateException("Entry not registered!");
                }
                this.sandbox.update(entry);
                this.pluginPool.beforeUpdate(entry);
                this.entryMap.put((Object)entry.getId(), entry);
                this.finishTransaction();
                this.pluginPool.afterUpdate(entry);
            }
            finally {
                this.unlock();
            }
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not update " + entry + " in " + this + "!", (Throwable)ex);
        }
        finally {
            this.syncSandbox();
        }
        this.notifyObservers();
        return this.get((KEY)entry);
    }

    @Override
    public ENTRY remove(KEY key) throws CouldNotPerformException {
        return this.remove(this.get(key));
    }

    @Override
    public ENTRY remove(ENTRY entry) throws CouldNotPerformException {
        return this.superRemove(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ENTRY superRemove(ENTRY entry) throws CouldNotPerformException {
        Identifiable oldEntry;
        if (entry == null) {
            throw new NotAvailableException("entry");
        }
        this.log("Remove " + entry + "...");
        try {
            this.checkWriteAccess();
            this.lock();
            try {
                if (!this.entryMap.containsKey(entry.getId())) {
                    throw new InvalidStateException("Entry not registered!");
                }
                this.pluginPool.beforeRemove(entry);
                this.sandbox.remove(entry);
                try {
                    oldEntry = (Identifiable)this.entryMap.remove(entry.getId());
                }
                finally {
                    this.finishTransaction();
                }
                this.pluginPool.afterRemove(entry);
            }
            finally {
                this.unlock();
            }
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not remove " + entry + " in " + this + "!", (Throwable)ex);
        }
        finally {
            this.syncSandbox();
        }
        this.notifyObservers();
        return (ENTRY)oldEntry;
    }

    @Override
    public ENTRY get(KEY key) throws CouldNotPerformException {
        if (key == null) {
            throw new NotAvailableException("key");
        }
        this.verifyID(key);
        this.registryLock.readLock().lock();
        try {
            if (!this.entryMap.containsKey(key)) {
                if (this.entryMap.isEmpty()) {
                    throw new NotAvailableException("Entry", key.toString(), (Throwable)new InvalidStateException(this + " is empty!"));
                }
                TreeMap sortedMap = new TreeMap((o1, o2) -> {
                    if (o1 instanceof String && o2 instanceof String) {
                        return ((String)o1).toLowerCase().compareTo(((String)o2).toLowerCase());
                    }
                    if (o1 instanceof Comparable && o2 instanceof Comparable) {
                        return ((Comparable)o1).compareTo((Comparable)o2);
                    }
                    return o1.toString().compareTo(o2.toString());
                });
                sortedMap.putAll(this.entryMap);
                if (sortedMap.floorKey(key) != null && sortedMap.ceilingKey(key) != null) {
                    throw new NotAvailableException("Entry", key.toString(), "Nearest neighbor is " + this.get((KEY)sortedMap.floorKey(key)) + " or " + this.get((KEY)sortedMap.ceilingKey(key)) + ".");
                }
                if (sortedMap.floorKey(key) != null) {
                    throw new NotAvailableException("Entry", key.toString(), "Nearest neighbor is " + this.get((KEY)sortedMap.floorKey(key)) + ".");
                }
                if (sortedMap.ceilingKey(key) != null) {
                    throw new NotAvailableException("Entry", key.toString(), "Nearest neighbor is " + this.get((KEY)sortedMap.ceilingKey(key)) + ".");
                }
                throw new InvalidStateException("Implementation error, case not handled.");
            }
            this.pluginPool.beforeGet(key);
            Identifiable identifiable = (Identifiable)this.entryMap.get(key);
            return (ENTRY)identifiable;
        }
        finally {
            this.registryLock.readLock().unlock();
        }
    }

    @Override
    public List<ENTRY> getEntries() throws CouldNotPerformException {
        this.registryLock.readLock().lock();
        try {
            this.pluginPool.beforeGetEntries();
            ArrayList arrayList = new ArrayList(this.entryMap.values());
            return arrayList;
        }
        finally {
            this.registryLock.readLock().unlock();
        }
    }

    @Override
    public Map<KEY, ENTRY> getEntryMap() {
        this.registryLock.readLock().lock();
        try {
            Map map = Collections.unmodifiableMap(this.entryMap);
            return map;
        }
        finally {
            this.registryLock.readLock().unlock();
        }
    }

    @Override
    public int size() {
        this.registryLock.readLock().lock();
        try {
            int n = this.entryMap.size();
            return n;
        }
        finally {
            this.registryLock.readLock().unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.registryLock.readLock().lock();
        try {
            boolean bl = this.entryMap.isEmpty();
            return bl;
        }
        finally {
            this.registryLock.readLock().unlock();
        }
    }

    @Override
    public boolean contains(ENTRY entry) throws CouldNotPerformException {
        if (entry == null) {
            throw new NotAvailableException("entry");
        }
        return this.contains((KEY)entry.getId());
    }

    @Override
    public boolean contains(KEY key) throws CouldNotPerformException {
        if (key == null) {
            throw new NotAvailableException("key");
        }
        return this.entryMap.containsKey(this.verifyID(key));
    }

    @Override
    public void clear() throws CouldNotPerformException {
        this.lock();
        try {
            this.pluginPool.beforeClear();
            this.sandbox.clear();
            this.entryMap.clear();
            this.consistent = true;
        }
        finally {
            this.unlock();
        }
        this.notifyObservers();
    }

    public void replaceInternalMap(Map<KEY, ENTRY> map) throws CouldNotPerformException {
        this.replaceInternalMap(map, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceInternalMap(Map<KEY, ENTRY> map, boolean finishTransaction) throws CouldNotPerformException {
        if (map == null) {
            throw new NotAvailableException("map");
        }
        this.lock();
        try {
            try {
                this.sandbox.replaceInternalMap(map);
                this.entryMap.clear();
                this.entryMap.putAll(map);
                if (finishTransaction) {
                    this.finishTransaction();
                }
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Internal map replaced by invalid data!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
            }
            finally {
                this.syncSandbox();
            }
        }
        finally {
            this.unlock();
        }
        this.notifyObservers();
    }

    public void checkWriteAccess() throws RejectedException {
        this.logger.debug("checkWriteAccess of " + this);
        if (!this.isDependingOnConsistentRegistries()) {
            throw new RejectedException("At least one depending registry is inconsistent!");
        }
        this.pluginPool.checkAccess();
        if (!this.consistent) {
            this.log(this.getName() + " is inconsistent! To fix registry manually start the registry in force mode.", LogLevel.WARN);
            throw new RejectedException("Registry is inconsistent!");
        }
    }

    protected boolean isDependingOnConsistentRegistries() {
        return new ArrayList<Registry>(this.dependingRegistryMap.keySet()).stream().noneMatch(registry -> !registry.isConsistent());
    }

    public void registerDependency(Registry registry) throws CouldNotPerformException {
        if (registry == null) {
            throw new NotAvailableException("registry");
        }
        this.registryLock.writeLock().lock();
        try {
            if (this.dependingRegistryMap.containsKey(registry)) {
                return;
            }
            this.dependingRegistryMap.put(registry, new DependencyConsistencyCheckTrigger(registry));
        }
        finally {
            this.registryLock.writeLock().unlock();
        }
    }

    public void removeDependency(Registry registry) throws CouldNotPerformException {
        if (registry == null) {
            throw new NotAvailableException("registry");
        }
        this.registryLock.writeLock().lock();
        try {
            if (!this.dependingRegistryMap.containsKey(registry)) {
                this.logger.warn("Could not remove a dependency which was never registered!");
                return;
            }
            this.dependingRegistryMap.remove(registry).shutdown();
        }
        finally {
            this.registryLock.writeLock().unlock();
        }
    }

    public void removeAllDependencies() {
        this.registryLock.writeLock().lock();
        try {
            ArrayList<Registry> dependingRegistryList = new ArrayList<Registry>(this.dependingRegistryMap.keySet());
            Collections.reverse(dependingRegistryList);
            dependingRegistryList.stream().forEach(registry -> this.dependingRegistryMap.remove(registry).shutdown());
        }
        finally {
            this.registryLock.writeLock().unlock();
        }
    }

    @Override
    public boolean isReadOnly() {
        try {
            this.checkWriteAccess();
        }
        catch (RejectedException ex) {
            return true;
        }
        return false;
    }

    protected final void notifyObservers() {
        try {
            if (this.registryLock.isWriteLockedByCurrentThread()) {
                this.logger.debug("Notification of registry[" + this + "] change skipped because of running write operations!");
                this.notificationSkipped = true;
                return;
            }
            if (super.notifyObservers(this.entryMap)) {
                try {
                    this.pluginPool.afterRegistryChange();
                }
                catch (CouldNotPerformException ex) {
                    MultiException.ExceptionStack exceptionStack = new MultiException.ExceptionStack();
                    exceptionStack.push(this.pluginPool, (Exception)((Object)ex));
                    throw new MultiException("PluginPool could not execute afterRegistryChange", exceptionStack);
                }
            }
            this.notificationSkipped = false;
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not notify all registry observer!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
        }
    }

    protected KEY verifyID(ENTRY entry) throws VerificationFailedException {
        try {
            if (entry == null) {
                throw new NotAvailableException("entry");
            }
            return (KEY)this.verifyID((KEY)entry.getId());
        }
        catch (CouldNotPerformException ex) {
            throw new VerificationFailedException("Could not verify message!", (Throwable)ex);
        }
    }

    protected KEY verifyID(KEY key) throws VerificationFailedException {
        if (key == null) {
            throw new VerificationFailedException("Invalid id!", (Throwable)new NotAvailableException("id"));
        }
        if (key instanceof String && ((String)key).isEmpty()) {
            throw new VerificationFailedException("Invalid id!", (Throwable)new InvalidStateException("id is empty!"));
        }
        return key;
    }

    public void registerConsistencyHandler(ConsistencyHandler<KEY, ENTRY, MAP, R> consistencyHandler) throws CouldNotPerformException {
        try {
            if (consistencyHandler == null) {
                throw new NotAvailableException("consistencyHandler");
            }
            this.consistencyHandlerList.add(consistencyHandler);
            this.sandbox.registerConsistencyHandler(consistencyHandler);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not register ConsistencyHandler[" + consistencyHandler + "]", (Throwable)ex);
        }
    }

    public void removeConsistencyHandler(ConsistencyHandler<KEY, ENTRY, MAP, R> consistencyHandler) throws CouldNotPerformException {
        try {
            if (consistencyHandler == null) {
                throw new NotAvailableException("consistencyHandler");
            }
            this.consistencyHandlerList.remove(consistencyHandler);
            this.sandbox.removeConsistencyHandler(consistencyHandler);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not remove ConsistencyHandler[" + consistencyHandler + "]", (Throwable)ex);
        }
    }

    /*
     * Exception decompiling
     */
    public final int checkConsistency() throws CouldNotPerformException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void afterConsistencyCheck() throws CouldNotPerformException {
        this.pluginPool.afterConsistencyCheck();
    }

    protected void finishTransaction() throws CouldNotPerformException {
        try {
            this.checkConsistency();
            this.dependingRegistryObservable.notifyObservers(this.entryMap);
        }
        catch (CouldNotPerformException ex) {
            throw (FatalImplementationErrorException)ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)new FatalImplementationErrorException("Registry consistency check failed but sandbox check was successful!", (Object)this, (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
        }
    }

    private void syncSandbox() throws CouldNotPerformException {
        this.registryLock.readLock().lock();
        try {
            this.sandbox.sync(this.entryMap);
        }
        finally {
            this.registryLock.readLock().unlock();
        }
    }

    @Override
    public boolean isConsistent() {
        return this.consistent;
    }

    @Override
    public boolean isReady() {
        return this.isConsistent() && !this.isBusy() && !this.isNotificationInProgess() && this.registryLock.getReadLockCount() == 0;
    }

    public void shutdown() {
        this.shutdownInitiated = true;
        try {
            this.registryLock.writeLock().lock();
            try {
                super.shutdown();
                this.removeAllDependencies();
                this.pluginPool.shutdown();
                this.consistencyHandlerList.stream().forEach(consistencyHandler -> consistencyHandler.shutdown());
                this.clear();
            }
            finally {
                this.registryLock.writeLock().unlock();
            }
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)("Could not shutdown " + this), (Throwable)ex, (Logger)this.logger);
        }
    }

    public void registerPlugin(P plugin) throws CouldNotPerformException, InterruptedException {
        try {
            if (plugin == null) {
                throw new NotAvailableException("plugin");
            }
            this.pluginPool.addPlugin(plugin);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not register Plugin[" + plugin + "]", (Throwable)ex);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return this.getClass().getSimpleName();
        }
        return this.name;
    }

    @Override
    public boolean isSandbox() {
        return false;
    }

    protected void log(String message) {
        try {
            Printer.print((String)("[" + this.getName() + "]: " + message), (LogLevel)LogLevelFilter.getFilteredLogLevel((LogLevel)LogLevel.INFO, (boolean)this.isSandbox()), (Logger)this.logger);
        }
        catch (Throwable ex) {
            System.out.println("fallback message: " + message);
        }
    }

    protected void log(String message, LogLevel logLevel, Throwable throwable) {
        Printer.print((String)message, (Throwable)throwable, (LogLevel)LogLevelFilter.getFilteredLogLevel((LogLevel)logLevel, (boolean)this.isSandbox()), (Logger)this.logger);
    }

    protected void log(String message, LogLevel logLevel) {
        Printer.print((String)message, (LogLevel)LogLevelFilter.getFilteredLogLevel((LogLevel)logLevel, (boolean)this.isSandbox()), (Logger)this.logger);
    }

    @Deprecated
    public void info(String message) {
        this.log(message);
    }

    public String toString() {
        return this.getName();
    }

    /*
     * Unable to fully structure code
     */
    protected void lock() throws CouldNotPerformException {
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                if (this.registryLock.writeLock().tryLock()) {
                    try {
                        successfullyLocked = this instanceof RemoteRegistry != false ? ((RemoteRegistry)this).internalRecursiveTryLockRegistry(this.lockedRegistries) : this.recursiveTryLockRegistry(this.lockedRegistries);
                        if (successfullyLocked) {
                            ++this.lockCounter;
                            return;
                        }
                        this.unlockRegistries(this.lockedRegistries);
                    }
                    finally {
                        this.registryLock.writeLock().unlock();
                    }
                }
                try {
                    Thread.sleep(20 + this.randomJitter.nextInt(30));
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    if (!this.shutdownInitiated) ** break;
                    continue;
                    throw new CouldNotPerformException("Could not lock registry because thread was externally interrupted!", (Throwable)ex);
                }
                break;
            }
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not lock registry!", (Throwable)ex);
        }
        ** GOTO lbl-1000
    }

    private void unlockRegistries(Set<Registry> lockedRegistries) {
        assert (this.registryLock.writeLock().isHeldByCurrentThread());
        this.registryLock.writeLock().lock();
        try {
            lockedRegistries.stream().forEach(registry -> {
                if (registry instanceof RemoteRegistry) {
                    ((RemoteRegistry)registry).internalUnlockRegistry();
                } else {
                    registry.unlockRegistry();
                }
            });
            lockedRegistries.clear();
        }
        finally {
            this.registryLock.writeLock().unlock();
        }
    }

    public boolean isBusy() {
        return this.registryLock.isWriteLocked();
    }

    public boolean isBusyByCurrentThread() {
        return this.registryLock.isWriteLockedByCurrentThread();
    }

    protected void unlock() {
        assert (this.registryLock.writeLock().isHeldByCurrentThread());
        if (this.lockCounter > 1) {
            --this.lockCounter;
        } else {
            --this.lockCounter;
            this.unlockRegistries(this.lockedRegistries);
        }
    }

    protected boolean isWriteLockedByCurrentThread() {
        return this.registryLock.writeLock().isHeldByCurrentThread();
    }

    @Override
    public boolean tryLockRegistry() throws RejectedException {
        return this.registryLock.writeLock().tryLock();
    }

    @Override
    public boolean recursiveTryLockRegistry(Set<Registry> lockedRegistries) throws RejectedException {
        if (lockedRegistries.contains(this)) {
            return true;
        }
        if (this.registryLock.writeLock().tryLock()) {
            lockedRegistries.add(this);
            for (Registry registry : this.dependingRegistryMap.keySet()) {
                if (!(registry instanceof RemoteRegistry ? !((RemoteRegistry)registry).internalRecursiveTryLockRegistry(lockedRegistries) : !registry.recursiveTryLockRegistry(lockedRegistries))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void unlockRegistry() {
        assert (this.registryLock.writeLock().isHeldByCurrentThread());
        this.registryLock.writeLock().unlock();
    }

    @Override
    public void addDependencyObserver(Observer<Map<KEY, ENTRY>> observer) {
        this.dependingRegistryObservable.addObserver(observer);
    }

    @Override
    public void removeDependencyObserver(Observer<Map<KEY, ENTRY>> observer) {
        this.dependingRegistryObservable.removeObserver(observer);
    }

    private class DependencyConsistencyCheckTrigger
    implements Observer,
    Shutdownable {
        private final Registry dependency;

        public DependencyConsistencyCheckTrigger(Registry dependency) {
            this.dependency = dependency;
            dependency.addDependencyObserver(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(Observable source, Object data) throws Exception {
            block10: {
                try {
                    if (!this.dependency.isConsistent()) break block10;
                    boolean notificationNeeded = false;
                    AbstractRegistry.this.lock();
                    try {
                        boolean bl = notificationNeeded = AbstractRegistry.this.checkConsistency() > 0 || AbstractRegistry.this.notificationSkipped;
                        if (notificationNeeded) {
                            AbstractRegistry.this.dependingRegistryObservable.notifyObservers((Object)AbstractRegistry.this.entryMap);
                        }
                    }
                    finally {
                        AbstractRegistry.this.unlock();
                    }
                    if (notificationNeeded) {
                        AbstractRegistry.this.notifyObservers();
                    }
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((String)("Registry inconsistend after change of depending " + source + " change."), (Throwable)ex, (Logger)AbstractRegistry.this.logger);
                }
                finally {
                    AbstractRegistry.this.syncSandbox();
                }
            }
        }

        public void shutdown() {
            AbstractRegistry.this.removeObserver(this);
        }
    }
}

