/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.registry;

import com.google.protobuf.GeneratedMessage;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.iface.Activatable;
import org.openbase.jul.iface.Configurable;
import org.openbase.jul.iface.Shutdownable;
import org.openbase.jul.pattern.Factory;
import org.openbase.jul.storage.registry.RegistryRemote;
import org.openbase.jul.storage.registry.RegistrySynchronizer;
import org.openbase.jul.storage.registry.RemoteRegistry;
import org.openbase.jul.storage.registry.SynchronizableRegistry;
import org.slf4j.Logger;

public abstract class ActivatableEntryRegistrySynchronizer<KEY, ENTRY extends Configurable<KEY, CONFIG_M> & Activatable, CONFIG_M extends GeneratedMessage, CONFIG_MB extends GeneratedMessage.Builder<CONFIG_MB>>
extends RegistrySynchronizer<KEY, ENTRY, CONFIG_M, CONFIG_MB> {
    public ActivatableEntryRegistrySynchronizer(SynchronizableRegistry<KEY, ENTRY> registry, RemoteRegistry<KEY, CONFIG_M, CONFIG_MB> remoteRegistry, RegistryRemote registryRemote, Factory<ENTRY, CONFIG_M> factory) throws InstantiationException {
        super(registry, remoteRegistry, registryRemote, factory);
    }

    @Override
    public ENTRY update(CONFIG_M config) throws CouldNotPerformException, InterruptedException {
        Object entry = super.update(config);
        if (this.activationCondition(config)) {
            ((Activatable)entry).activate();
        } else {
            ((Activatable)entry).deactivate();
        }
        return entry;
    }

    @Override
    public ENTRY register(CONFIG_M config) throws CouldNotPerformException, InterruptedException {
        Object entry = super.register(config);
        if (this.activationCondition(config)) {
            ((Activatable)entry).activate();
        }
        return entry;
    }

    @Override
    public ENTRY remove(CONFIG_M config) throws CouldNotPerformException, InterruptedException {
        Object entry = super.remove(config);
        ((Activatable)entry).deactivate();
        return entry;
    }

    @Override
    public void deactivate() throws CouldNotPerformException, InterruptedException {
        super.deactivate();
        for (Configurable entry : this.localRegistry.getEntries()) {
            ((Activatable)entry).deactivate();
        }
    }

    @Override
    public void shutdown() {
        try {
            for (Configurable entry : this.localRegistry.getEntries()) {
                ((Shutdownable)entry).shutdown();
            }
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.logger);
        }
        super.shutdown();
    }

    public abstract boolean activationCondition(CONFIG_M var1);
}

