/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.registry;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.RejectedException;
import org.openbase.jul.iface.Identifiable;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.storage.registry.ConsistencyHandler;
import org.openbase.jul.storage.registry.Registry;
import org.openbase.jul.storage.registry.RegistrySandbox;

public class MockRegistrySandbox<KEY, ENTRY extends Identifiable<KEY>, MAP extends Map<KEY, ENTRY>, R extends Registry<KEY, ENTRY>>
implements RegistrySandbox<KEY, ENTRY, MAP, R> {
    private final Registry<KEY, ENTRY> registry;

    public MockRegistrySandbox(Registry<KEY, ENTRY> registry) {
        this.registry = registry;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public ENTRY register(ENTRY entry) throws CouldNotPerformException {
        return entry;
    }

    @Override
    public ENTRY update(ENTRY entry) throws CouldNotPerformException {
        return entry;
    }

    @Override
    public void sync(MAP map) {
    }

    @Override
    public void registerConsistencyHandler(ConsistencyHandler<KEY, ENTRY, MAP, R> consistencyHandler) throws CouldNotPerformException {
    }

    @Override
    public void removeConsistencyHandler(ConsistencyHandler<KEY, ENTRY, MAP, R> consistencyHandler) throws CouldNotPerformException {
    }

    @Override
    public ENTRY remove(ENTRY entry) throws CouldNotPerformException {
        return null;
    }

    @Override
    public ENTRY remove(KEY entry) throws CouldNotPerformException {
        return null;
    }

    @Override
    public ENTRY get(KEY key) throws CouldNotPerformException {
        throw new UnsupportedOperationException("Not supported for mock sandbox.");
    }

    @Override
    public List<ENTRY> getEntries() {
        throw new UnsupportedOperationException("Not supported for mock sandbox.");
    }

    @Override
    public boolean contains(ENTRY entry) throws CouldNotPerformException {
        throw new UnsupportedOperationException("Not supported for mock sandbox.");
    }

    @Override
    public boolean contains(KEY key) throws CouldNotPerformException {
        throw new UnsupportedOperationException("Not supported for mock sandbox.");
    }

    @Override
    public void clear() throws CouldNotPerformException {
    }

    public void checkWriteAccess() throws RejectedException {
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void replaceInternalMap(Map<KEY, ENTRY> map) {
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("Not supported for mock sandbox.");
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public ENTRY load(ENTRY entry) throws CouldNotPerformException {
        return entry;
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    public void addObserver(Observer<Map<KEY, ENTRY>> observer) {
        throw new UnsupportedOperationException("Not supported for mock sandbox.");
    }

    public void removeObserver(Observer<Map<KEY, ENTRY>> observer) {
        throw new UnsupportedOperationException("Not supported for mock sandbox.");
    }

    public Map<KEY, ENTRY> getValue() throws NotAvailableException {
        throw new UnsupportedOperationException("Not supported for mock sandbox.");
    }

    public boolean isValueAvailable() {
        return true;
    }

    public void shutdown() {
    }

    @Override
    public boolean isSandbox() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("Not supported for mock sandbox.");
    }

    @Override
    public boolean isReady() {
        return true;
    }

    public void waitForValue(long timeout, TimeUnit timeUnit) throws NotAvailableException, InterruptedException {
        throw new UnsupportedOperationException("Not supported for mock sandbox.");
    }

    @Override
    public boolean tryLockRegistry() throws RejectedException {
        throw new RejectedException("MockRegistrySandbox not lockable!");
    }

    @Override
    public void unlockRegistry() {
    }

    public Future<Map<KEY, ENTRY>> getValueFuture() {
        throw new UnsupportedOperationException("Not supported for mock sandbox.");
    }

    @Override
    public Map<KEY, ENTRY> getEntryMap() {
        throw new UnsupportedOperationException("Not supported for mock sandbox.");
    }

    @Override
    public void addDependencyObserver(Observer<Map<KEY, ENTRY>> observer) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeDependencyObserver(Observer<Map<KEY, ENTRY>> observer) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean recursiveTryLockRegistry(Set<Registry> lockedRegistries) throws RejectedException {
        throw new RejectedException("MockRegistrySandbox not lockable!");
    }
}

