/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.registry;

import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import java.io.File;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.protobuf.BuilderSyncSetup;
import org.openbase.jul.extension.protobuf.IdGenerator;
import org.openbase.jul.extension.protobuf.IdentifiableMessage;
import org.openbase.jul.extension.protobuf.container.ProtoBufMessageMap;
import org.openbase.jul.extension.protobuf.container.ProtoBufMessageMapImpl;
import org.openbase.jul.extension.protobuf.container.transformer.IdentifiableMessageTransformer;
import org.openbase.jul.extension.protobuf.processing.ProtoBufFileProcessor;
import org.openbase.jul.iface.Identifiable;
import org.openbase.jul.storage.file.FileProvider;
import org.openbase.jul.storage.registry.FileSynchronizedRegistryImpl;
import org.openbase.jul.storage.registry.ProtoBufFileSynchronizedRegistrySandbox;
import org.openbase.jul.storage.registry.ProtoBufRegistry;
import org.openbase.jul.storage.registry.jp.JPGitRegistryPlugin;
import org.openbase.jul.storage.registry.plugin.GitRegistryPlugin;
import org.slf4j.Logger;

public class ProtoBufFileSynchronizedRegistry<KEY extends Comparable<KEY>, M extends GeneratedMessage, MB extends GeneratedMessage.Builder<MB>, SIB extends GeneratedMessage.Builder<SIB>>
extends FileSynchronizedRegistryImpl<KEY, IdentifiableMessage<KEY, M, MB>, ProtoBufMessageMap<KEY, M, MB>, ProtoBufRegistry<KEY, M, MB>>
implements ProtoBufRegistry<KEY, M, MB> {
    private final ProtoBufMessageMapImpl<KEY, M, MB, SIB> protobufMessageMap;
    private final IdGenerator<KEY, M> idGenerator;
    private final Class<M> messageClass;

    public ProtoBufFileSynchronizedRegistry(Class<M> messageClass, BuilderSyncSetup<SIB> builderSetup, Descriptors.FieldDescriptor fieldDescriptor, IdGenerator<KEY, M> idGenerator, File databaseDirectory, FileProvider<Identifiable<KEY>> fileProvider) throws InstantiationException, InterruptedException {
        this(messageClass, new ProtoBufMessageMapImpl(builderSetup, fieldDescriptor), idGenerator, databaseDirectory, fileProvider);
    }

    public ProtoBufFileSynchronizedRegistry(Class<M> messageClass, ProtoBufMessageMapImpl<KEY, M, MB, SIB> internalMap, IdGenerator<KEY, M> idGenerator, File databaseDirectory, FileProvider<Identifiable<KEY>> fileProvider) throws InstantiationException, InterruptedException {
        super(internalMap, databaseDirectory, new ProtoBufFileProcessor((ProtoBufFileProcessor.TypeToMessageTransformer)new IdentifiableMessageTransformer(messageClass, idGenerator)), fileProvider);
        try {
            this.idGenerator = idGenerator;
            this.messageClass = messageClass;
            this.protobufMessageMap = internalMap;
            this.setName(this.getDatabaseName() + "Registry");
            try {
                if (((Boolean)((JPGitRegistryPlugin)JPService.getProperty(JPGitRegistryPlugin.class)).getValue()).booleanValue()) {
                    this.registerPlugin(new GitRegistryPlugin(this));
                }
            }
            catch (JPServiceException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not access java property!", (Throwable)ex), (Logger)this.logger);
            }
            this.setupSandbox(new ProtoBufFileSynchronizedRegistrySandbox(idGenerator, this.protobufMessageMap.getFieldDescriptor(), this));
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    @Override
    public void shutdown() {
        this.protobufMessageMap.shutdown();
        super.shutdown();
    }

    public void activateVersionControl(Package converterPackage) throws CouldNotPerformException {
        try {
            String entryType;
            try {
                entryType = this.getDatabaseName();
            }
            catch (Exception ex) {
                throw new CouldNotPerformException("Could not detect entry type!", (Throwable)ex);
            }
            super.activateVersionControl(entryType, converterPackage);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not activate version control!", (Throwable)ex);
        }
    }

    public Class<M> getMessageClass() {
        return this.messageClass;
    }

    @Override
    public M register(M message) throws CouldNotPerformException {
        GeneratedMessage result = super.register(new IdentifiableMessage(message, this.idGenerator)).getMessage();
        return (M)result;
    }

    @Override
    public boolean contains(M message) throws CouldNotPerformException {
        return this.contains((M)new IdentifiableMessage(message).getId());
    }

    @Override
    public M update(M message) throws CouldNotPerformException {
        return (M)this.update((M)new IdentifiableMessage(message)).getMessage();
    }

    @Override
    public M remove(M message) throws CouldNotPerformException {
        return (M)this.remove((M)new IdentifiableMessage(message)).getMessage();
    }

    @Override
    public M getMessage(KEY id) throws CouldNotPerformException {
        return (M)((IdentifiableMessage)this.get(id)).getMessage();
    }

    @Override
    public MB getBuilder(KEY key) throws CouldNotPerformException {
        return (MB)((GeneratedMessage.Builder)this.getMessage(key).toBuilder());
    }

    public IdGenerator<KEY, M> getIdGenerator() {
        return this.idGenerator;
    }
}

