/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.registry;

import com.google.protobuf.GeneratedMessage;
import org.openbase.jps.core.JPService;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.exception.VerificationFailedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.protobuf.IdentifiableMessageMap;
import org.openbase.jul.extension.protobuf.ProtobufListDiff;
import org.openbase.jul.iface.Activatable;
import org.openbase.jul.iface.Configurable;
import org.openbase.jul.iface.Identifiable;
import org.openbase.jul.iface.Shutdownable;
import org.openbase.jul.pattern.Factory;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.RecurrenceEventFilter;
import org.openbase.jul.schedule.SyncObject;
import org.openbase.jul.storage.registry.RegistryRemote;
import org.openbase.jul.storage.registry.RemoteRegistry;
import org.openbase.jul.storage.registry.SynchronizableRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistrySynchronizer<KEY, ENTRY extends Configurable<KEY, CONFIG_M>, CONFIG_M extends GeneratedMessage, CONFIG_MB extends GeneratedMessage.Builder<CONFIG_MB>>
implements Activatable,
Shutdownable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final SynchronizableRegistry<KEY, ENTRY> localRegistry;
    private final Observer remoteRegistryChangeObserver;
    private final RecurrenceEventFilter recurrenceSyncFilter;
    private final ProtobufListDiff<KEY, CONFIG_M, CONFIG_MB> entryConfigDiff;
    private final Factory<ENTRY, CONFIG_M> factory;
    protected final RemoteRegistry<KEY, CONFIG_M, CONFIG_MB> remoteRegistry;
    protected final RegistryRemote registryRemote;
    private boolean active;
    private final SyncObject synchronizationLock = new SyncObject("SynchronizationLock");

    @Deprecated
    public RegistrySynchronizer(SynchronizableRegistry<KEY, ENTRY> registry, RemoteRegistry<KEY, CONFIG_M, CONFIG_MB> remoteRegistry, Factory<ENTRY, CONFIG_M> factory) throws InstantiationException {
        this(registry, remoteRegistry, null, factory);
    }

    public RegistrySynchronizer(final SynchronizableRegistry<KEY, ENTRY> registry, RemoteRegistry<KEY, CONFIG_M, CONFIG_MB> remoteRegistry, RegistryRemote registryRemote, Factory<ENTRY, CONFIG_M> factory) throws InstantiationException {
        try {
            this.localRegistry = registry;
            this.remoteRegistry = remoteRegistry;
            this.registryRemote = registryRemote;
            this.entryConfigDiff = new ProtobufListDiff();
            this.factory = factory;
            this.recurrenceSyncFilter = new RecurrenceEventFilter(15000L){

                public void relay() throws Exception {
                    if (!RegistrySynchronizer.this.isActive()) {
                        return;
                    }
                    RegistrySynchronizer.this.logger.debug("Incomming updates passed filter...");
                    try {
                        RegistrySynchronizer.this.internalSync();
                    }
                    finally {
                        registry.notifySynchronization();
                    }
                }
            };
            this.remoteRegistryChangeObserver = (source, data) -> {
                this.logger.debug("Incomming updates...");
                this.recurrenceSyncFilter.trigger();
            };
        }
        catch (Exception ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        if (this.registryRemote != null) {
            this.registryRemote.addDataObserver(this.remoteRegistryChangeObserver);
        } else {
            this.remoteRegistry.addObserver(this.remoteRegistryChangeObserver);
        }
        try {
            if (this.remoteRegistry.isDataAvalable()) {
                this.internalSync();
            }
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Initial sync failed!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
        }
        this.active = true;
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        this.logger.debug("deactivate " + this);
        this.active = false;
        if (this.registryRemote != null) {
            this.registryRemote.removeDataObserver(this.remoteRegistryChangeObserver);
        } else {
            this.remoteRegistry.removeObserver(this.remoteRegistryChangeObserver);
        }
        this.recurrenceSyncFilter.cancel();
    }

    public boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.deactivate();
            SyncObject syncObject = this.synchronizationLock;
            synchronized (syncObject) {
                this.localRegistry.shutdown();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)("Could not shutdown " + this), (Throwable)ex, (Logger)this.logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSync() throws CouldNotPerformException, InterruptedException {
        SyncObject syncObject = this.synchronizationLock;
        synchronized (syncObject) {
            this.logger.debug("Perform registry sync...");
            try {
                this.entryConfigDiff.diff(this.remoteRegistry.getMessages());
                int skippedChanges = 0;
                MultiException.ExceptionStack removeExceptionStack = null;
                for (Object config : this.entryConfigDiff.getRemovedMessageMap().getMessages()) {
                    try {
                        this.remove(config);
                    }
                    catch (CouldNotPerformException ex) {
                        removeExceptionStack = MultiException.push((Object)this, (Exception)((Object)ex), removeExceptionStack);
                    }
                }
                MultiException.ExceptionStack updateExceptionStack = null;
                for (Object config : this.entryConfigDiff.getUpdatedMessageMap().getMessages()) {
                    try {
                        if (this.verifyConfig(config)) {
                            this.update(config);
                            continue;
                        }
                        this.remove(config);
                        this.entryConfigDiff.getOriginMessages().removeMessage((GeneratedMessage)config);
                    }
                    catch (CouldNotPerformException ex) {
                        updateExceptionStack = MultiException.push((Object)this, (Exception)((Object)ex), updateExceptionStack);
                    }
                }
                MultiException.ExceptionStack registerExceptionStack = null;
                for (GeneratedMessage config : this.entryConfigDiff.getNewMessageMap().getMessages()) {
                    try {
                        if (this.verifyConfig(config)) {
                            this.register(config);
                            continue;
                        }
                        ++skippedChanges;
                    }
                    catch (CouldNotPerformException ex) {
                        registerExceptionStack = MultiException.push((Object)this, (Exception)((Object)ex), registerExceptionStack);
                    }
                }
                int errorCounter = MultiException.size((MultiException.ExceptionStack)removeExceptionStack) + MultiException.size((MultiException.ExceptionStack)updateExceptionStack) + MultiException.size(registerExceptionStack);
                int changeCounter = this.entryConfigDiff.getChangeCounter() - skippedChanges;
                if (changeCounter != 0 || errorCounter != 0) {
                    this.logger.info(changeCounter + " registry changes applied." + (errorCounter == 0 ? "" : " " + errorCounter + (errorCounter == 1 ? " is" : " are") + " skipped."));
                }
                IdentifiableMessageMap newOriginEntryMap = new IdentifiableMessageMap();
                for (Configurable entry : this.localRegistry.getEntries()) {
                    newOriginEntryMap.put(this.remoteRegistry.get(entry.getId()));
                }
                this.entryConfigDiff.replaceOriginMap(newOriginEntryMap);
                MultiException.ExceptionStack exceptionStack = null;
                try {
                    int counter = removeExceptionStack != null ? removeExceptionStack.size() : 0;
                    MultiException.checkAndThrow((String)("Could not remove " + counter + " entries!"), (MultiException.ExceptionStack)removeExceptionStack);
                }
                catch (CouldNotPerformException ex) {
                    exceptionStack = MultiException.push((Object)this, (Exception)((Object)ex), exceptionStack);
                }
                try {
                    int counter = updateExceptionStack != null ? updateExceptionStack.size() : 0;
                    MultiException.checkAndThrow((String)("Could not update " + counter + " entries!"), (MultiException.ExceptionStack)updateExceptionStack);
                }
                catch (CouldNotPerformException ex) {
                    exceptionStack = MultiException.push((Object)this, (Exception)((Object)ex), (MultiException.ExceptionStack)exceptionStack);
                }
                try {
                    int counter = registerExceptionStack != null ? registerExceptionStack.size() : 0;
                    MultiException.checkAndThrow((String)("Could not register " + counter + " entries!"), (MultiException.ExceptionStack)registerExceptionStack);
                }
                catch (CouldNotPerformException ex) {
                    exceptionStack = MultiException.push((Object)this, (Exception)((Object)ex), (MultiException.ExceptionStack)exceptionStack);
                }
                MultiException.checkAndThrow((String)"Could not sync all entries!", (MultiException.ExceptionStack)exceptionStack);
            }
            catch (CouldNotPerformException ex) {
                CouldNotPerformException exx = new CouldNotPerformException("Entry registry sync failed!", (Throwable)ex);
                if (JPService.testMode()) {
                    ExceptionPrinter.printHistory((Throwable)exx, (Logger)this.logger);
                    assert (false);
                }
                throw exx;
            }
        }
    }

    public ENTRY register(CONFIG_M config) throws CouldNotPerformException, InterruptedException {
        return (ENTRY)((Configurable)this.localRegistry.register((Identifiable)this.factory.newInstance(config)));
    }

    public ENTRY update(CONFIG_M config) throws CouldNotPerformException, InterruptedException {
        Configurable entry = (Configurable)this.localRegistry.get(this.remoteRegistry.getId(config));
        entry.applyConfigUpdate(config);
        this.localRegistry.update(entry);
        return (ENTRY)entry;
    }

    public ENTRY remove(CONFIG_M config) throws CouldNotPerformException, InterruptedException {
        return (ENTRY)((Configurable)this.localRegistry.remove(this.getId(config)));
    }

    public KEY getId(CONFIG_M entry) throws CouldNotPerformException {
        Object key = entry.getField(entry.getDescriptorForType().findFieldByName("id"));
        if (!this.localRegistry.contains(key)) {
            throw new CouldNotPerformException("Entry for given Key[" + key + "] is not available for local registry!");
        }
        return (KEY)key;
    }

    public boolean verifyConfig(CONFIG_M config) throws VerificationFailedException {
        return true;
    }
}

