/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.registry;

import java.util.HashMap;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.iface.Identifiable;
import org.openbase.jul.pattern.Remote;
import org.openbase.jul.storage.registry.RegistryImpl;
import org.openbase.jul.storage.registry.SynchronizableRegistry;

public class RemoteControllerRegistryImpl<KEY, ENTRY extends Remote & Identifiable<KEY>>
extends RegistryImpl<KEY, ENTRY>
implements SynchronizableRegistry<KEY, ENTRY> {
    private static final long NEVER_SYNCHRONIZED = -1L;
    private long lastSynchronizationTimestamp = -1L;

    public RemoteControllerRegistryImpl() throws InstantiationException {
        super(new HashMap());
    }

    public RemoteControllerRegistryImpl(HashMap<KEY, ENTRY> entryMap) throws InstantiationException {
        super(entryMap);
    }

    @Override
    public void clear() throws CouldNotPerformException {
        for (Remote remote : this.getEntries()) {
            if (remote.isLocked()) continue;
            remote.shutdown();
        }
        super.clear();
    }

    @Override
    public void notifySynchronization() {
        this.lastSynchronizationTimestamp = System.currentTimeMillis();
    }

    @Override
    public boolean isInitiallySynchronized() {
        return this.lastSynchronizationTimestamp != -1L;
    }

    @Override
    public long getLastSynchronizationTimestamp() throws NotAvailableException {
        if (!this.isInitiallySynchronized()) {
            throw new NotAvailableException("SynchronizationTimestamp", (Throwable)new InvalidStateException("RemoteControllerRegistry was never fully synchronized yet!"));
        }
        return this.lastSynchronizationTimestamp;
    }
}

