/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.registry;

import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.NotSupportedException;
import org.openbase.jul.exception.RejectedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.protobuf.IdentifiableMessage;
import org.openbase.jul.schedule.FutureProcessor;
import org.openbase.jul.storage.registry.AbstractRegistry;
import org.openbase.jul.storage.registry.ConsistencyHandler;
import org.openbase.jul.storage.registry.ProtoBufRegistry;
import org.openbase.jul.storage.registry.Registry;
import org.openbase.jul.storage.registry.RegistryRemote;
import org.openbase.jul.storage.registry.plugin.RemoteRegistryPlugin;
import org.slf4j.Logger;

public class RemoteRegistry<KEY, M extends GeneratedMessage, MB extends GeneratedMessage.Builder<MB>>
extends AbstractRegistry<KEY, IdentifiableMessage<KEY, M, MB>, Map<KEY, IdentifiableMessage<KEY, M, MB>>, ProtoBufRegistry<KEY, M, MB>, RemoteRegistryPlugin<KEY, IdentifiableMessage<KEY, M, MB>>>
implements ProtoBufRegistry<KEY, M, MB> {
    private RegistryRemote<?> registryRemote;

    public RemoteRegistry() throws InstantiationException {
        this(new HashMap());
    }

    public RemoteRegistry(Map<KEY, IdentifiableMessage<KEY, M, MB>> internalMap) throws InstantiationException {
        super(internalMap);
    }

    public synchronized void notifyRegistryUpdate(Collection<M> values) throws CouldNotPerformException {
        HashMap<Object, IdentifiableMessage> newRegistryMap = new HashMap<Object, IdentifiableMessage>();
        for (GeneratedMessage value : values) {
            IdentifiableMessage data = new IdentifiableMessage(value);
            newRegistryMap.put(data.getId(), data);
        }
        this.replaceInternalMap(newRegistryMap);
    }

    public KEY getId(M entry) throws CouldNotPerformException {
        Object key = entry.getField(entry.getDescriptorForType().findFieldByName("id"));
        if (!this.contains((M)key)) {
            throw new CouldNotPerformException("Entry for given Key[" + key + "] is not available!");
        }
        return (KEY)key;
    }

    @Override
    public M getMessage(KEY key) throws CouldNotPerformException {
        return (M)((IdentifiableMessage)this.get(key)).getMessage();
    }

    @Override
    public MB getBuilder(KEY key) throws CouldNotPerformException {
        return (MB)((GeneratedMessage.Builder)this.getMessage(key).toBuilder());
    }

    @Override
    public M register(M entry) throws CouldNotPerformException {
        throw new NotSupportedException((Object)"register", (Object)this, "Operation not permitted!");
    }

    @Override
    public M update(M entry) throws CouldNotPerformException {
        throw new NotSupportedException((Object)"update", (Object)this, "Operation not permitted!");
    }

    @Override
    public M remove(M entry) throws CouldNotPerformException {
        throw new NotSupportedException((Object)"remove", (Object)this, "Operation not permitted!");
    }

    @Override
    public boolean contains(M entry) throws CouldNotPerformException {
        KEY key;
        try {
            key = this.getId(entry);
        }
        catch (CouldNotPerformException ex) {
            return false;
        }
        return super.contains(key);
    }

    @Override
    public void loadRegistry() throws CouldNotPerformException {
        throw new NotSupportedException((Object)"loadRegistry", (Object)this, "Operation not permitted!");
    }

    @Override
    public void saveRegistry() throws CouldNotPerformException {
        throw new NotSupportedException((Object)"saveRegistry", (Object)this, "Operation not permitted!");
    }

    @Override
    public List<M> getMessages() throws CouldNotPerformException {
        ArrayList<GeneratedMessage> messageList = new ArrayList<GeneratedMessage>();
        for (IdentifiableMessage messageContainer : this.getEntries()) {
            messageList.add(messageContainer.getMessage());
        }
        return messageList;
    }

    @Override
    public Integer getDBVersion() throws NotAvailableException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void registerConsistencyHandler(ConsistencyHandler<KEY, IdentifiableMessage<KEY, M, MB>, Map<KEY, IdentifiableMessage<KEY, M, MB>>, ProtoBufRegistry<KEY, M, MB>> consistencyHandler) throws CouldNotPerformException {
        throw new NotSupportedException((Object)"registerConsistencyHandler", (Object)this);
    }

    @Override
    public void registerDependency(Registry registry) throws CouldNotPerformException {
        throw new NotSupportedException((Object)"registerDependency", (Object)this);
    }

    @Override
    public boolean tryLockRegistry() throws RejectedException {
        throw new RejectedException("RemoteRegistry not lockable!");
    }

    boolean internalTryLockRegistry() throws RejectedException {
        return super.tryLockRegistry();
    }

    @Override
    public boolean recursiveTryLockRegistry(Set<Registry> lockedRegistries) throws RejectedException {
        throw new RejectedException("RemoteRegistry not externally lockable!");
    }

    boolean internalRecursiveTryLockRegistry(Set<Registry> lockedRegistries) throws RejectedException {
        return super.recursiveTryLockRegistry(lockedRegistries);
    }

    @Override
    public void unlockRegistry() {
    }

    void internalUnlockRegistry() {
        super.unlockRegistry();
    }

    @Override
    public boolean isReadOnly() {
        if (this.registryRemote != null && !this.registryRemote.isConnected()) {
            return true;
        }
        return super.isReadOnly();
    }

    public void waitUntilReady() throws InterruptedException, CouldNotPerformException {
        try {
            this.waitUntilReadyFuture().get();
        }
        catch (CancellationException | ExecutionException ex) {
            throw new CouldNotPerformException("Could not wait unit registry is ready.", (Throwable)ex);
        }
    }

    public Future<Void> waitUntilReadyFuture() {
        try {
            return this.getRegistryRemote().waitUntilReadyFuture();
        }
        catch (NotAvailableException ex) {
            return FutureProcessor.canceledFuture(null, (Exception)((Object)ex));
        }
    }

    public void waitForData() throws InterruptedException {
        try {
            if (this.registryRemote == null) {
                this.waitForValue();
                return;
            }
            this.getRegistryRemote().waitForData();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)"Could not wait until remote registry is ready!", (Throwable)ex, (Logger)this.logger);
        }
    }

    public void setRegistryRemote(RegistryRemote<?> remote) {
        this.registryRemote = remote;
    }

    protected RegistryRemote<?> getRegistryRemote() throws NotAvailableException {
        if (this.registryRemote == null) {
            throw new NotAvailableException("RegistryRemote");
        }
        return this.registryRemote;
    }

    public boolean isDataAvalable() {
        if (this.registryRemote == null) {
            return this.isValueAvailable();
        }
        return this.registryRemote.isDataAvailable();
    }
}

