/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.registry;

import java.util.HashMap;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.iface.Identifiable;
import org.openbase.jul.storage.registry.RegistryImpl;
import org.openbase.jul.storage.registry.SynchronizableRegistry;

public class SynchronizableRegistryImpl<KEY, ENTRY extends Identifiable<KEY>>
extends RegistryImpl<KEY, ENTRY>
implements SynchronizableRegistry<KEY, ENTRY> {
    public static final long NEVER_SYNCHRONIZED = -1L;
    private long lastSynchronizationTimestamp = -1L;

    public SynchronizableRegistryImpl() throws InstantiationException {
        super(new HashMap());
    }

    public SynchronizableRegistryImpl(HashMap<KEY, ENTRY> entryMap) throws InstantiationException {
        super(entryMap);
    }

    @Override
    public void notifySynchronization() {
        this.lastSynchronizationTimestamp = System.currentTimeMillis();
    }

    @Override
    public boolean isInitiallySynchronized() {
        return this.lastSynchronizationTimestamp != -1L;
    }

    @Override
    public long getLastSynchronizationTimestamp() throws NotAvailableException {
        if (!this.isInitiallySynchronized()) {
            throw new NotAvailableException("SynchronizationTimestamp", (Throwable)new InvalidStateException("ControllerRegistry was never fully synchronized yet!"));
        }
        return this.lastSynchronizationTimestamp;
    }
}

