/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.registry.jp;

import java.io.File;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jps.exception.JPValidationException;
import org.openbase.jps.preset.JPShareDirectory;
import org.openbase.jps.preset.JPVarDirectory;
import org.openbase.jps.tools.FileHandler;
import org.openbase.jul.storage.registry.jp.AbstractJPDatabaseDirectory;
import org.openbase.jul.storage.registry.jp.JPInitializeDB;

public class JPDatabaseDirectory
extends AbstractJPDatabaseDirectory {
    public static final String DEFAULT_DB_PATH = "bco/registry/db";
    public static final String[] COMMAND_IDENTIFIERS = new String[]{"--db", "--database"};

    public JPDatabaseDirectory() {
        super(COMMAND_IDENTIFIERS);
    }

    public File getParentDirectory() throws JPServiceException {
        try {
            if (new File((File)((JPVarDirectory)JPService.getProperty(JPVarDirectory.class)).getValue(), DEFAULT_DB_PATH).exists() || JPService.testMode()) {
                return (File)((JPVarDirectory)JPService.getProperty(JPVarDirectory.class)).getValue();
            }
        }
        catch (JPNotAvailableException ex) {
            JPService.printError((String)"Could not detect global var directory!", (Throwable)ex);
        }
        try {
            if (new File((File)((JPShareDirectory)JPService.getProperty(JPShareDirectory.class)).getValue(), DEFAULT_DB_PATH).exists()) {
                return (File)((JPShareDirectory)JPService.getProperty(JPShareDirectory.class)).getValue();
            }
        }
        catch (JPNotAvailableException ex) {
            JPService.printError((String)"Could not detect global share directory!", (Throwable)ex);
        }
        throw new JPServiceException("Could not detect db location!");
    }

    protected File getPropertyDefaultValue() {
        return new File(DEFAULT_DB_PATH);
    }

    @Override
    public void validate() throws JPValidationException {
        if (JPService.testMode()) {
            this.setAutoCreateMode(FileHandler.AutoMode.On);
            this.setExistenceHandling(FileHandler.ExistenceHandling.Must);
        }
        super.validate();
    }

    public String getDescription() {
        return "Specifies the device database directory. Use  " + JPInitializeDB.COMMAND_IDENTIFIERS[0] + " to auto create database directories.";
    }
}

