/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.registry.plugin;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.openbase.jul.exception.NotAvailableException;

public class GitTest {
    public static void main(String[] args) throws IOException, NotAvailableException {
        System.out.println("is tag:" + GitTest.isTag(GitTest.getHead((Repository)new FileRepository("/home/divine/tmp/testgit/.git"))));
        FileRepositoryBuilder repositoryBuilder = (FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(new File("/home/divine/tmp/testgit/.git"));
        if (repositoryBuilder.getGitDir() == null) {
            throw new NotAvailableException("git repository");
        }
        Repository repo = repositoryBuilder.build();
        Git git = new Git(repo);
        try {
            while (true) {
                System.out.println("running");
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException ex) {
            System.out.println("close");
            git.close();
            repo.close();
            System.out.println("finish");
            return;
        }
    }

    private static Ref getHead(Repository repository) throws IOException {
        return repository.getRef("HEAD");
    }

    private static boolean isTag(Ref ref) {
        return !ref.getTarget().getName().contains("refs/heads");
    }
}

