/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.registry.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openbase.jps.core.JPService;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.RejectedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.iface.Identifiable;
import org.openbase.jul.storage.registry.Registry;
import org.openbase.jul.storage.registry.plugin.RegistryPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryPluginPool<KEY, ENTRY extends Identifiable<KEY>, P extends RegistryPlugin<KEY, ENTRY>>
implements RegistryPlugin<KEY, ENTRY> {
    protected final Logger logger = LoggerFactory.getLogger(RegistryPluginPool.class);
    protected final List<P> pluginList = new ArrayList<P>();
    protected Registry<KEY, ENTRY> registry;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    @Override
    public void init(Registry<KEY, ENTRY> registry) throws InitializationException {
        this.registry = registry;
    }

    public void shutdown() {
        this.pluginList.stream().forEach(plugin -> {
            block2: {
                try {
                    plugin.shutdown();
                }
                catch (Exception ex) {
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not shutdown RegistryPlugin[" + plugin + "]!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
                    if ($assertionsDisabled || !JPService.testMode()) break block2;
                    throw new AssertionError();
                }
            }
        });
    }

    public void addPlugin(P plugin) throws InitializationException, InterruptedException {
        try {
            plugin.init(this.registry);
            this.pluginList.add(plugin);
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)("Could not add Plugin[" + plugin.getClass().getName() + "] to Registry[" + this.registry.getClass().getSimpleName() + "]"), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void beforeRegister(ENTRY entry) throws RejectedException {
        if (this.pluginList.isEmpty() || this.lock.isWriteLockedByCurrentThread()) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            for (RegistryPlugin plugin : this.pluginList) {
                try {
                    plugin.beforeRegister(entry);
                }
                catch (RejectedException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not inform RegistryPlugin[" + plugin + "] about planned Entry[" + entry + "] registration!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
                    assert (!JPService.testMode());
                    continue;
                    return;
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void afterRegister(ENTRY entry) throws CouldNotPerformException {
        if (this.pluginList.isEmpty() || this.lock.isWriteLockedByCurrentThread()) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            for (RegistryPlugin plugin : this.pluginList) {
                try {
                    plugin.afterRegister(entry);
                }
                catch (Exception ex) {
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not inform RegistryPlugin[" + plugin + "] about planned Entry[" + entry + "] registration!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
                    assert (!JPService.testMode());
                    continue;
                    return;
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void beforeUpdate(ENTRY entry) throws RejectedException {
        if (this.pluginList.isEmpty() || this.lock.isWriteLockedByCurrentThread()) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            for (RegistryPlugin plugin : this.pluginList) {
                try {
                    plugin.beforeUpdate(entry);
                }
                catch (RejectedException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not inform RegistryPlugin[" + plugin + "] about planned Entry[" + entry + "] update!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
                    assert (!JPService.testMode());
                    continue;
                    return;
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void afterUpdate(ENTRY entry) throws CouldNotPerformException {
        if (this.pluginList.isEmpty() || this.lock.isWriteLockedByCurrentThread()) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            for (RegistryPlugin plugin : this.pluginList) {
                try {
                    plugin.afterUpdate(entry);
                }
                catch (Exception ex) {
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not inform RegistryPlugin[" + plugin + "] about successfully Entry[" + entry + "] update!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
                    assert (!JPService.testMode());
                    continue;
                    return;
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void afterConsistencyModification(ENTRY entry) throws CouldNotPerformException {
        if (this.pluginList.isEmpty() || this.lock.isWriteLockedByCurrentThread()) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            for (RegistryPlugin plugin : this.pluginList) {
                try {
                    plugin.afterConsistencyModification(entry);
                }
                catch (Exception ex) {
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not inform RegistryPlugin[" + plugin + "] about Entry[" + entry + "] modification!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
                    assert (!JPService.testMode());
                    continue;
                    return;
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void beforeRemove(ENTRY entry) throws RejectedException {
        if (this.pluginList.isEmpty() || this.lock.isWriteLockedByCurrentThread()) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            for (RegistryPlugin plugin : this.pluginList) {
                try {
                    plugin.beforeRemove(entry);
                }
                catch (RejectedException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not inform RegistryPlugin[" + plugin + "] about planned Entry[" + entry + "] removal!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
                    assert (!JPService.testMode());
                    continue;
                    return;
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void afterRemove(ENTRY entry) throws CouldNotPerformException {
        if (this.pluginList.isEmpty() || this.lock.isWriteLockedByCurrentThread()) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            for (RegistryPlugin plugin : this.pluginList) {
                try {
                    plugin.afterRemove(entry);
                }
                catch (Exception ex) {
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not inform RegistryPlugin[" + plugin + "] about successfully Entry[" + entry + "] removal!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
                    assert (!JPService.testMode());
                    continue;
                    return;
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void beforeClear() throws CouldNotPerformException {
        if (this.pluginList.isEmpty() || this.lock.isWriteLockedByCurrentThread()) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            for (RegistryPlugin plugin : this.pluginList) {
                try {
                    plugin.beforeClear();
                }
                catch (Exception ex) {
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not inform RegistryPlugin[" + plugin + "] about planned registry earsure!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
                    assert (!JPService.testMode());
                    continue;
                    return;
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void beforeGet(KEY key) throws RejectedException {
        if (this.pluginList.isEmpty()) {
            return;
        }
        for (RegistryPlugin plugin : this.pluginList) {
            try {
                plugin.beforeGet(key);
            }
            catch (RejectedException ex) {
                throw ex;
            }
            catch (Exception ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not inform RegistryPlugin[" + plugin + "] about planned Entry[" + key + "] publishment!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
                assert (!JPService.testMode());
            }
        }
    }

    @Override
    public void beforeGetEntries() throws CouldNotPerformException {
        if (this.pluginList.isEmpty()) {
            return;
        }
        for (RegistryPlugin plugin : this.pluginList) {
            try {
                plugin.beforeGetEntries();
            }
            catch (Exception ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not inform RegistryPlugin[" + plugin + "] about planned registry publishment!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
                assert (!JPService.testMode());
            }
        }
    }

    @Override
    public void checkAccess() throws RejectedException {
        if (this.pluginList.isEmpty()) {
            return;
        }
        for (RegistryPlugin plugin : this.pluginList) {
            try {
                plugin.checkAccess();
            }
            catch (RejectedException ex) {
                throw ex;
            }
            catch (Exception ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not check registry access with RegistryPlugin[" + plugin + "]!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
                assert (!JPService.testMode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void afterRegistryChange() throws CouldNotPerformException {
        if (this.pluginList.isEmpty() || this.lock.isWriteLockedByCurrentThread()) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            for (RegistryPlugin plugin : this.pluginList) {
                try {
                    plugin.afterRegistryChange();
                }
                catch (RejectedException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not inform RegistryPlugin[" + plugin + "] about registry change!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
                    assert (!JPService.testMode());
                    continue;
                    return;
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void afterConsistencyCheck() throws CouldNotPerformException {
        if (this.pluginList.isEmpty() || this.lock.isWriteLockedByCurrentThread()) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            for (RegistryPlugin plugin : this.pluginList) {
                try {
                    plugin.afterConsistencyCheck();
                }
                catch (RejectedException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not inform RegistryPlugin[" + plugin + "] about finished consistency check!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
                    assert (!JPService.testMode());
                    continue;
                    return;
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

