/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.registry.version;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.RejectedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.iface.Writable;
import org.openbase.jul.storage.file.FileProvider;
import org.openbase.jul.storage.registry.ConsistencyHandler;
import org.openbase.jul.storage.registry.FileSynchronizedRegistry;
import org.openbase.jul.storage.registry.jp.JPDatabaseDirectory;
import org.openbase.jul.storage.registry.jp.JPInitializeDB;
import org.openbase.jul.storage.registry.version.DBVersionConverter;
import org.openbase.jul.storage.registry.version.DatabaseEntryDescriptor;
import org.openbase.jul.storage.registry.version.GlobalDBVersionConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBVersionControl {
    public static final String VERSION_FILE_NAME = ".db-version";
    public static final String VERSION_FIELD = "version";
    public static final String DB_CONVERTER_PACKAGE_NAME = "dbconvert";
    public static final String APPLIED_VERSION_CONSISTENCY_HANDLER_FIELD = "applied_consistency_handler";
    public static final String VERSION_FILE_WARNING = "### PLEASE DO NOT MODIFY ###\n";
    protected final Logger logger = LoggerFactory.getLogger(DBVersionControl.class);
    private final JsonParser parser;
    private final Gson gson;
    private int latestDBVersion;
    private int versionOnStart;
    private final Package converterPackage;
    private final List<DBVersionConverter> converterPipeline;
    private final FileProvider entryFileProvider;
    private final String entryType;
    private final File databaseDirectory;
    private final Writable databaseWriteAccess;
    private final List<File> globalDatabaseDirectories;

    public DBVersionControl(String entryType, FileProvider entryFileProvider, Package converterPackage, File databaseDirectory, Writable databaseWriteAccess) throws InstantiationException {
        try {
            this.databaseWriteAccess = databaseWriteAccess;
            this.entryType = entryType;
            this.gson = new GsonBuilder().setPrettyPrinting().create();
            this.parser = new JsonParser();
            this.converterPackage = converterPackage;
            this.entryFileProvider = entryFileProvider;
            this.converterPipeline = this.loadDBConverterPipelineAndDetectLatestVersion(converterPackage);
            this.databaseDirectory = databaseDirectory;
            this.globalDatabaseDirectories = this.detectGlobalDatabaseDirectories();
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public DBVersionControl(String entryType, FileProvider entryFileProvider, Package converterPackage, File databaseDirectory) throws InstantiationException {
        this(entryType, entryFileProvider, converterPackage, databaseDirectory, () -> {
            if (!databaseDirectory.canWrite()) {
                throw new RejectedException("db directory not writable!");
            }
        });
    }

    public void validateAndUpgradeDBVersion() throws CouldNotPerformException {
        this.versionOnStart = this.detectAndUpgradeCurrentDBVersion();
        int latestVersion = this.getLatestDBVersion();
        if (this.versionOnStart == latestVersion) {
            this.logger.debug("Database[" + this.databaseDirectory.getName() + "] is up-to-date.");
            return;
        }
        if (this.versionOnStart > latestVersion) {
            throw new InvalidStateException("DB Version[" + this.versionOnStart + "] is newer than the latest supported Version[" + latestVersion + "]!");
        }
        this.upgradeDB(this.versionOnStart, latestVersion);
    }

    public void upgradeDB(int currentVersion, int targetVersion) throws CouldNotPerformException {
        try {
            this.logger.info("Upgrade Database[" + this.databaseDirectory.getName() + "] from current Version[" + currentVersion + "] to target Version[" + targetVersion + "]...");
            Map<String, Map<File, DatabaseEntryDescriptor>> globalDbSnapshots = null;
            List<DBVersionConverter> currentToTargetConverterPipeline = this.getDBConverterPipeline(currentVersion, this.latestDBVersion);
            int versionOfCurrentTransaction = currentVersion;
            if (!currentToTargetConverterPipeline.isEmpty()) {
                this.databaseWriteAccess.checkWriteAccess();
            }
            Map<File, JsonObject> dbFileEntryMap = this.loadDbSnapshot();
            for (DBVersionConverter converter : currentToTargetConverterPipeline) {
                ++versionOfCurrentTransaction;
                if (globalDbSnapshots == null && converter instanceof GlobalDBVersionConverter) {
                    globalDbSnapshots = this.loadGlobalDbSnapshots();
                }
                for (Map.Entry<File, JsonObject> dbEntry : dbFileEntryMap.entrySet()) {
                    dbFileEntryMap.replace(dbEntry.getKey(), dbEntry.getValue(), this.upgradeDBEntry(dbEntry.getValue(), converter, dbFileEntryMap, globalDbSnapshots));
                }
                this.latestDBVersion = versionOfCurrentTransaction;
                this.storeDbSnapshot(dbFileEntryMap);
                this.storeGlobalDbSnapshots(globalDbSnapshots);
                this.upgradeCurrentDBVersion();
            }
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not upgrade Database[" + this.databaseDirectory.getAbsolutePath() + "] to" + (targetVersion == this.latestDBVersion ? " latest" : "") + " Version[" + targetVersion + "]!", (Throwable)ex);
        }
    }

    public JsonObject upgradeDBEntry(JsonObject entry, DBVersionConverter converter, Map<File, JsonObject> dbSnapshot, Map<String, Map<File, DatabaseEntryDescriptor>> globalDbSnapshots) throws CouldNotPerformException {
        try {
            if (converter instanceof GlobalDBVersionConverter) {
                return ((GlobalDBVersionConverter)converter).upgrade(entry, dbSnapshot, globalDbSnapshots);
            }
            return converter.upgrade(entry, dbSnapshot);
        }
        catch (Exception ex) {
            throw new CouldNotPerformException("Could not upgrade entry with Converter[" + converter.getClass().getSimpleName() + "]!", (Throwable)ex);
        }
    }

    private Map<File, JsonObject> loadDbSnapshot() throws CouldNotPerformException {
        HashMap<File, JsonObject> dbFileEntryMap = new HashMap<File, JsonObject>();
        for (File entry : this.databaseDirectory.listFiles(this.entryFileProvider.getFileFilter())) {
            dbFileEntryMap.put(entry, this.loadDBEntry(entry));
        }
        return dbFileEntryMap;
    }

    private Map<File, DatabaseEntryDescriptor> loadDbSnapshotAsDBEntryDescriptors(File globalDatabaseDirectory) throws CouldNotPerformException {
        HashMap<File, DatabaseEntryDescriptor> dbFileEntryMap = new HashMap<File, DatabaseEntryDescriptor>();
        for (File entry : globalDatabaseDirectory.listFiles(this.entryFileProvider.getFileFilter())) {
            dbFileEntryMap.put(entry, new DatabaseEntryDescriptor(this.loadDBEntry(entry), entry, this.detectCurrentDBVersion(globalDatabaseDirectory), globalDatabaseDirectory));
        }
        return dbFileEntryMap;
    }

    private Map<String, Map<File, DatabaseEntryDescriptor>> loadGlobalDbSnapshots() {
        HashMap<String, Map<File, DatabaseEntryDescriptor>> globalDbSnapshotMap = new HashMap<String, Map<File, DatabaseEntryDescriptor>>();
        this.globalDatabaseDirectories.stream().forEach(globalDatabaseDirectory -> {
            try {
                if (!FileUtils.isSymlink((File)globalDatabaseDirectory)) {
                    if (globalDatabaseDirectory.canWrite()) {
                        globalDbSnapshotMap.put(globalDatabaseDirectory.getName(), this.loadDbSnapshotAsDBEntryDescriptors((File)globalDatabaseDirectory));
                    } else {
                        this.logger.warn("Skip loading of global Database[" + globalDatabaseDirectory.getAbsolutePath() + "] because directory is write protected!");
                    }
                }
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)("Could not load db entries out of " + globalDatabaseDirectory.getAbsolutePath()), (Throwable)ex, (Logger)this.logger);
            }
            catch (IOException ex) {
                ExceptionPrinter.printHistory((String)("Could not check wether [" + globalDatabaseDirectory.getName() + "] is a symlink!"), (Throwable)ex, (Logger)this.logger);
            }
        });
        return globalDbSnapshotMap;
    }

    private void storeDbSnapshot(Map<File, JsonObject> dbFileEntryMap) throws CouldNotPerformException {
        try {
            for (Map.Entry<File, JsonObject> dbEntry : dbFileEntryMap.entrySet()) {
                this.storeEntry(this.formatEntryToHumanReadableString(dbEntry.getValue()), dbEntry.getKey());
            }
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not store db snapshot!", (Throwable)ex);
        }
    }

    private void storeDbSnapshotASDBEntryDescriptors(Map<File, DatabaseEntryDescriptor> dbFileEntryMap) throws CouldNotPerformException {
        try {
            for (Map.Entry<File, DatabaseEntryDescriptor> dbEntry : dbFileEntryMap.entrySet()) {
                this.storeEntry(this.formatEntryToHumanReadableString(dbEntry.getValue().getEntry()), dbEntry.getKey());
            }
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not store db snapshot!", (Throwable)ex);
        }
    }

    private void storeGlobalDbSnapshots(Map<String, Map<File, DatabaseEntryDescriptor>> globalDbSnapshots) throws CouldNotPerformException {
        if (globalDbSnapshots == null) {
            return;
        }
        for (Map.Entry<String, Map<File, DatabaseEntryDescriptor>> entry : globalDbSnapshots.entrySet()) {
            this.storeDbSnapshotASDBEntryDescriptors(entry.getValue());
        }
    }

    public String formatEntryToHumanReadableString(JsonObject jsonEntry) throws CouldNotPerformException {
        String entryAsString;
        try {
            entryAsString = jsonEntry.toString();
            JsonElement el = this.parser.parse(entryAsString);
            entryAsString = this.gson.toJson(el);
        }
        catch (Exception ex) {
            throw new CouldNotPerformException("Could not format entry!", (Throwable)ex);
        }
        return entryAsString;
    }

    public void storeEntry(String entryAsString, File entryFile) throws CouldNotPerformException {
        try {
            FileUtils.writeStringToFile((File)entryFile, (String)entryAsString, (String)"UTF-8");
        }
        catch (Exception ex) {
            throw new CouldNotPerformException("Could not store entry!", (Throwable)ex);
        }
    }

    private JsonObject loadDBEntry(File entry) throws CouldNotPerformException {
        JsonObject jSonEntry;
        try {
            JsonReader jsonReader = new JsonReader((Reader)new StringReader(FileUtils.readFileToString((File)entry, (String)"UTF-8")));
            jsonReader.setLenient(true);
            jSonEntry = new JsonParser().parse(jsonReader).getAsJsonObject();
        }
        catch (JsonIOException | JsonSyntaxException | IOException | IllegalStateException ex) {
            throw new CouldNotPerformException("Could not load File[" + entry.getAbsolutePath() + "]!", ex);
        }
        return jSonEntry;
    }

    public int getLatestDBVersion() {
        return this.latestDBVersion;
    }

    public int detectCurrentDBVersion(File databaseDirectory) throws CouldNotPerformException {
        try {
            File versionFile = new File(databaseDirectory, VERSION_FILE_NAME);
            if (!versionFile.exists()) {
                if (((Boolean)((JPInitializeDB)JPService.getProperty(JPInitializeDB.class)).getValue()).booleanValue()) {
                    return this.getLatestDBVersion();
                }
                throw new CouldNotPerformException("No version information available! Add \"" + JPInitializeDB.COMMAND_IDENTIFIERS[0] + "\" as registry argument to generate the version information.");
            }
            try {
                String versionAsString = FileUtils.readFileToString((File)versionFile, (String)"UTF-8");
                versionAsString = versionAsString.replace(VERSION_FILE_WARNING, "");
                JsonObject versionJsonObject = new JsonParser().parse(versionAsString).getAsJsonObject();
                try {
                    return versionJsonObject.get(VERSION_FIELD).getAsInt();
                }
                catch (JsonSyntaxException ex) {
                    throw new CouldNotPerformException("Field[version] is missing!", (Throwable)ex);
                }
            }
            catch (JsonSyntaxException | IOException ex) {
                throw new CouldNotPerformException("Could not parse db version information!", ex);
            }
        }
        catch (JPServiceException | CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not detect current db version of Database[" + databaseDirectory.getName() + "]!", ex);
        }
    }

    public int detectAndUpgradeCurrentDBVersion() throws CouldNotPerformException {
        try {
            File versionFile = new File(this.databaseDirectory, VERSION_FILE_NAME);
            if (!versionFile.exists()) {
                if (!((Boolean)((JPInitializeDB)JPService.getProperty(JPInitializeDB.class)).getValue()).booleanValue()) {
                    throw new CouldNotPerformException("No version information available! Add \"" + JPInitializeDB.COMMAND_IDENTIFIERS[0] + "\" as registry argument to generate the version information.");
                }
                this.upgradeCurrentDBVersion();
            }
            try {
                String versionAsString = FileUtils.readFileToString((File)versionFile, (String)"UTF-8");
                versionAsString = versionAsString.replace(VERSION_FILE_WARNING, "");
                JsonObject versionJsonObject = new JsonParser().parse(versionAsString).getAsJsonObject();
                return versionJsonObject.get(VERSION_FIELD).getAsInt();
            }
            catch (JsonSyntaxException | IOException ex) {
                throw new CouldNotPerformException("Could not load Field[version]!", ex);
            }
        }
        catch (JPServiceException | CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not detect db version of Database[" + this.databaseDirectory.getName() + "]!", ex);
        }
    }

    public void upgradeCurrentDBVersion() throws CouldNotPerformException {
        try {
            File versionFile = new File(this.databaseDirectory, VERSION_FILE_NAME);
            if (!versionFile.exists()) {
                if (!versionFile.createNewFile()) {
                    throw new CouldNotPerformException("Could not create db version file!");
                }
                JsonObject versionJsonObject = new JsonObject();
                versionJsonObject.addProperty(VERSION_FIELD, (Number)this.latestDBVersion);
                FileUtils.writeStringToFile((File)versionFile, (String)(VERSION_FILE_WARNING + this.formatEntryToHumanReadableString(versionJsonObject)), (String)"UTF-8");
                return;
            }
            try {
                String versionAsString = FileUtils.readFileToString((File)versionFile, (String)"UTF-8");
                versionAsString = versionAsString.replace(VERSION_FILE_WARNING, "");
                JsonObject versionJsonObject = new JsonParser().parse(versionAsString).getAsJsonObject();
                versionJsonObject.remove(VERSION_FIELD);
                versionJsonObject.addProperty(VERSION_FIELD, (Number)this.latestDBVersion);
                FileUtils.writeStringToFile((File)versionFile, (String)(VERSION_FILE_WARNING + this.formatEntryToHumanReadableString(versionJsonObject)), (String)"UTF-8");
            }
            catch (JsonSyntaxException | IOException | CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not write Field[version]!", ex);
            }
        }
        catch (IOException | CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not upgrade current db version of Database[" + this.databaseDirectory.getName() + "]!", ex);
        }
    }

    public List<DBVersionConverter> getDBConverterPipeline(int currentVersion, int targetVersion) throws CouldNotPerformException {
        return this.converterPipeline.subList(currentVersion, targetVersion);
    }

    private List<DBVersionConverter> loadDBConverterPipelineAndDetectLatestVersion(Package converterPackage) throws CouldNotPerformException {
        ArrayList<DBVersionConverter> converterList = new ArrayList<DBVersionConverter>();
        int version = 0;
        String converterClassName = "";
        try {
            try {
                while (true) {
                    converterClassName = converterPackage.getName() + "." + this.entryType + "_" + version + "_To_" + (version + 1) + "_DBConverter";
                    Class<?> converterClass = Class.forName(converterClassName);
                    Constructor<?> converterConstructor = converterClass.getConstructor(DBVersionControl.class);
                    converterList.add((DBVersionConverter)converterConstructor.newInstance(this));
                    ++version;
                }
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                this.logger.debug("Could not load Converter[" + converterClassName + "] so latest db version should be " + version + ".", (Throwable)ex);
                this.latestDBVersion = version;
                return converterList;
            }
        }
        catch (IllegalAccessException | java.lang.InstantiationException ex) {
            throw new CouldNotPerformException("Could not load converter db pipeline of Package[" + converterPackage.getName() + "]!", (Throwable)ex);
        }
    }

    public List<ConsistencyHandler> loadDBVersionConsistencyHandlers(FileSynchronizedRegistry registry) throws CouldNotPerformException {
        ArrayList<ConsistencyHandler> consistencyHandlerList = new ArrayList<ConsistencyHandler>();
        String consistencyHandlerPackage = this.converterPackage.getName() + ".consistency";
        Set<String> executedHandlerList = this.detectExecutedVersionConsistencyHandler();
        String consistencyHandlerName = null;
        try {
            for (int version = this.versionOnStart; version <= this.latestDBVersion; ++version) {
                Class<?> consistencyHandlerClass;
                try {
                    consistencyHandlerName = this.entryType + "_" + version + "_VersionConsistencyHandler";
                    if (executedHandlerList.contains(consistencyHandlerName)) continue;
                    consistencyHandlerClass = Class.forName(consistencyHandlerPackage + "." + consistencyHandlerName);
                }
                catch (ClassNotFoundException ex) {
                    this.logger.debug("No ConsistencyHandler[" + consistencyHandlerName + "] implemented for Version[" + version + "].", (Throwable)ex);
                    continue;
                }
                Constructor<?> constructor = consistencyHandlerClass.getConstructor(this.getClass(), FileSynchronizedRegistry.class);
                ConsistencyHandler newInstance = (ConsistencyHandler)constructor.newInstance(this, registry);
                consistencyHandlerList.add(newInstance);
            }
            return consistencyHandlerList;
        }
        catch (IllegalAccessException | IllegalArgumentException | java.lang.InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new CouldNotPerformException("Could not load consistencyHandler of Package[" + consistencyHandlerPackage + "]!", (Throwable)ex);
        }
    }

    public void registerConsistencyHandlerExecution(ConsistencyHandler versionConsistencyHandler) throws CouldNotPerformException {
        try {
            JsonObject versionJsonObject;
            File versionFile = new File(this.databaseDirectory, VERSION_FILE_NAME);
            if (!versionFile.exists()) {
                throw new NotAvailableException("version db file");
            }
            try {
                String versionAsString = FileUtils.readFileToString((File)versionFile, (String)"UTF-8");
                versionAsString = versionAsString.replace(VERSION_FILE_WARNING, "");
                versionJsonObject = new JsonParser().parse(versionAsString).getAsJsonObject();
            }
            catch (JsonSyntaxException | IOException ex) {
                throw new CouldNotPerformException("Could not load version file!", ex);
            }
            try {
                JsonArray consistencyHandlerJsonArray = versionJsonObject.getAsJsonArray(APPLIED_VERSION_CONSISTENCY_HANDLER_FIELD);
                if (consistencyHandlerJsonArray == null) {
                    consistencyHandlerJsonArray = new JsonArray();
                    versionJsonObject.add(APPLIED_VERSION_CONSISTENCY_HANDLER_FIELD, (JsonElement)consistencyHandlerJsonArray);
                }
                String versionConsistencyHandlerName = versionConsistencyHandler.getClass().getSimpleName();
                for (int i = 0; i < consistencyHandlerJsonArray.size(); ++i) {
                    if (!consistencyHandlerJsonArray.get(i).getAsString().equals(versionConsistencyHandlerName)) continue;
                    return;
                }
                consistencyHandlerJsonArray.add(versionConsistencyHandler.getClass().getSimpleName());
                FileUtils.writeStringToFile((File)versionFile, (String)(VERSION_FILE_WARNING + this.formatEntryToHumanReadableString(versionJsonObject)), (String)"UTF-8");
            }
            catch (IOException | CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not write Field[applied_consistency_handler]!", ex);
            }
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not register ConsistencyHandler[" + versionConsistencyHandler.getClass().getSimpleName() + "] in current db version config of Database[" + this.databaseDirectory.getName() + "]!", (Throwable)ex);
        }
    }

    public Set<String> detectExecutedVersionConsistencyHandler() throws CouldNotPerformException {
        try {
            File versionFile = new File(this.databaseDirectory, VERSION_FILE_NAME);
            if (!versionFile.exists()) {
                throw new CouldNotPerformException("No version information available! Add \"" + JPInitializeDB.COMMAND_IDENTIFIERS[0] + "\" as registry argument to generate the version information.");
            }
            try {
                String versionAsString = FileUtils.readFileToString((File)versionFile, (String)"UTF-8");
                versionAsString = versionAsString.replace(VERSION_FILE_WARNING, "");
                JsonObject versionJsonObject = new JsonParser().parse(versionAsString).getAsJsonObject();
                HashSet<String> handlerList = new HashSet<String>();
                JsonArray consistencyHandlerJsonArray = versionJsonObject.getAsJsonArray(APPLIED_VERSION_CONSISTENCY_HANDLER_FIELD);
                if (consistencyHandlerJsonArray != null) {
                    consistencyHandlerJsonArray.forEach(entry -> handlerList.add(entry.getAsString()));
                }
                return handlerList;
            }
            catch (JsonSyntaxException | IOException ex) {
                throw new CouldNotPerformException("Could not load Field[applied_consistency_handler]!", ex);
            }
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not detect db version of Database[" + this.databaseDirectory.getName() + "]!", (Throwable)ex);
        }
    }

    private List<File> detectGlobalDatabaseDirectories() throws CouldNotPerformException {
        ArrayList<File> globalDatabaseDirectoryList = new ArrayList<File>();
        try {
            DirectoryFileFilter dbFilter = new DirectoryFileFilter(){

                public boolean accept(File file) {
                    return super.accept(file) && !file.equals(DBVersionControl.this.databaseDirectory);
                }
            };
            globalDatabaseDirectoryList.addAll(Arrays.asList(((File)((JPDatabaseDirectory)JPService.getProperty(JPDatabaseDirectory.class)).getValue()).listFiles((FileFilter)dbFilter)));
            return globalDatabaseDirectoryList;
        }
        catch (JPServiceException ex) {
            throw new CouldNotPerformException("Could not detect neighbout databases!", (Throwable)ex);
        }
    }

    public Package getConverterPackage() {
        return this.converterPackage;
    }

    public List<DBVersionConverter> getConverterPipeline() {
        return this.converterPipeline;
    }

    public FileProvider getEntryFileProvider() {
        return this.entryFileProvider;
    }

    public File getDatabaseDirectory() {
        return this.databaseDirectory;
    }
}

