/*
 * Decompiled with CFR 0.152.
 */
package org.openbaton.plugin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.QueueingConsumer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.commons.codec.binary.Base64;
import org.openbaton.catalogue.nfvo.PluginAnswer;
import org.openbaton.exceptions.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginListener
implements Runnable {
    private static final String exchange = "openbaton-exchange";
    private String pluginId;
    private Object pluginInstance;
    private Logger log;
    private QueueingConsumer consumer;
    private Channel channel;
    private Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(byte[].class, (Object)new ByteArrayToBase64TypeAdapter()).setPrettyPrinting().create();
    private boolean exit = false;
    private String brokerIp;
    private int brokerPort;
    private String username;
    private String password;
    private String virtualHost;
    private Connection connection;
    private boolean durable = true;

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public Object getPluginInstance() {
        return this.pluginInstance;
    }

    public void setPluginInstance(Object pluginInstance) {
        this.pluginInstance = pluginInstance;
        this.log = LoggerFactory.getLogger((String)pluginInstance.getClass().getName());
    }

    public boolean isExit() {
        return this.exit;
    }

    public void setExit(boolean exit) {
        this.exit = exit;
    }

    @Override
    public void run() {
        try {
            this.initRabbitMQ();
        }
        catch (IOException | TimeoutException e) {
            e.printStackTrace();
            this.setExit(true);
        }
        block13: while (true) {
            try {
                while (!this.exit) {
                    AMQP.BasicProperties replyProps;
                    AMQP.BasicProperties props;
                    QueueingConsumer.Delivery delivery;
                    try {
                        delivery = this.consumer.nextDelivery();
                        props = delivery.getProperties();
                        replyProps = new AMQP.BasicProperties.Builder().correlationId(props.getCorrelationId()).build();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.exit = true;
                        continue;
                    }
                    this.log.info("\nWaiting for RPC requests");
                    String message = new String(delivery.getBody());
                    this.log.debug("Received message");
                    this.log.trace("Message content received: " + message);
                    PluginAnswer answer = new PluginAnswer();
                    try {
                        answer.setAnswer(this.executeMethod(message));
                    }
                    catch (InvocationTargetException e) {
                        answer.setException(e.getTargetException());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        answer.setException((Throwable)e);
                    }
                    try {
                        String response = this.gson.toJson((Object)answer);
                        this.log.debug("Answer is: " + response);
                        this.log.debug("Reply queue is: " + props.getReplyTo());
                        this.channel.basicPublish(exchange, props.getReplyTo(), replyProps, response.getBytes());
                        this.channel.basicAck(delivery.getEnvelope().getDeliveryTag(), false);
                        continue block13;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        answer.setException((Throwable)e);
                        this.log.debug("Answer is: " + answer);
                        this.log.debug("Reply queue is: " + props.getReplyTo());
                        this.channel.basicPublish(exchange, props.getReplyTo(), replyProps, this.gson.toJson((Object)answer).getBytes());
                        this.channel.basicAck(delivery.getEnvelope().getDeliveryTag(), false);
                        this.setExit(true);
                    }
                }
                break;
            }
            catch (IOException e) {
                e.printStackTrace();
                break;
            }
        }
        try {
            if (this.channel == null || this.connection == null) {
                System.exit(3);
            }
            this.channel.close();
            this.connection.close();
        }
        catch (IOException | TimeoutException e) {
            e.printStackTrace();
        }
    }

    private Serializable executeMethod(String pluginMessageString) throws InvocationTargetException, IllegalAccessException, NotFoundException {
        JsonObject pluginMessageObject = (JsonObject)this.gson.fromJson(pluginMessageString, JsonObject.class);
        List<Object> params = new ArrayList<Object>();
        for (JsonElement param : pluginMessageObject.get("parameters").getAsJsonArray()) {
            Object p = this.gson.fromJson(param, Object.class);
            if (p == null) continue;
            params.add(p);
        }
        Class<?> pluginClass = this.pluginInstance.getClass();
        this.log.debug("There are " + params.size() + " parameters");
        String methodName = pluginMessageObject.get("methodName").getAsString();
        this.log.debug("Looking for method: " + methodName);
        for (Method m : pluginClass.getMethods()) {
            this.log.trace("Method checking is: " + m.getName() + " with " + m.getParameterTypes().length + " parameters");
            byte[] avoid = new byte[]{};
            if (!m.getName().equals(methodName) || m.getParameterTypes().length != params.size() || m.getParameterTypes()[m.getParameterTypes().length - 1].getCanonicalName().equals(avoid.getClass().getCanonicalName())) continue;
            if (!m.getReturnType().equals(Void.class)) {
                if (params.size() != 0) {
                    params = this.getParameters(pluginMessageObject.get("parameters").getAsJsonArray(), m.getParameterTypes());
                    for (Object p : params) {
                        this.log.trace("param class is: " + p.getClass());
                    }
                    return (Serializable)m.invoke(this.pluginInstance, params.toArray());
                }
                return (Serializable)m.invoke(this.pluginInstance, new Object[0]);
            }
            if (params.size() != 0) {
                params = this.getParameters(pluginMessageObject.get("parameters").getAsJsonArray(), m.getParameterTypes());
                for (Object p : params) {
                    this.log.trace("param class is: " + p.getClass());
                }
                m.invoke(this.pluginInstance, params.toArray());
            } else {
                m.invoke(this.pluginInstance, new Object[0]);
            }
            return null;
        }
        throw new NotFoundException("method not found");
    }

    private List<Object> getParameters(JsonArray parameters, Class<?>[] parameterTypes) {
        LinkedList<Object> res = new LinkedList<Object>();
        for (int i = 0; i < parameters.size(); ++i) {
            res.add(this.gson.fromJson(parameters.get(i), parameterTypes[i]));
        }
        return res;
    }

    private void initRabbitMQ() throws IOException, TimeoutException {
        ConnectionFactory factory = new ConnectionFactory();
        factory.setHost(this.brokerIp);
        factory.setPort(this.brokerPort);
        factory.setPassword(this.password);
        factory.setUsername(this.username);
        factory.setVirtualHost(this.virtualHost);
        this.connection = factory.newConnection();
        this.channel = this.connection.createChannel();
        this.channel.queueDeclare(this.pluginId, this.durable, false, true, null);
        this.channel.queueBind(this.pluginId, exchange, this.pluginId);
        this.channel.basicQos(1);
        this.consumer = new QueueingConsumer(this.channel);
        this.channel.basicConsume(this.pluginId, false, (Consumer)this.consumer);
    }

    public String getBrokerIp() {
        return this.brokerIp;
    }

    public void setBrokerIp(String brokerIp) {
        this.brokerIp = brokerIp;
    }

    public int getBrokerPort() {
        return this.brokerPort;
    }

    public void setBrokerPort(int brokerPort) {
        this.brokerPort = brokerPort;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    private static class ByteArrayToBase64TypeAdapter
    implements JsonSerializer<byte[]>,
    JsonDeserializer<byte[]> {
        private ByteArrayToBase64TypeAdapter() {
        }

        public byte[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Base64.decodeBase64((String)json.getAsString());
        }

        public JsonElement serialize(byte[] src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(Base64.encodeBase64String((byte[])src));
        }
    }
}

