/*
 * Decompiled with CFR 0.152.
 */
package org.openbaton.sdk;

import org.openbaton.sdk.api.rest.ConfigurationRestRequest;
import org.openbaton.sdk.api.rest.EventAgent;
import org.openbaton.sdk.api.rest.KeyAgent;
import org.openbaton.sdk.api.rest.NetworkServiceDescriptorRestAgent;
import org.openbaton.sdk.api.rest.NetworkServiceRecordRestAgent;
import org.openbaton.sdk.api.rest.ProjectAgent;
import org.openbaton.sdk.api.rest.UserAgent;
import org.openbaton.sdk.api.rest.VNFFGRestAgent;
import org.openbaton.sdk.api.rest.VNFPackageAgent;
import org.openbaton.sdk.api.rest.VimInstanceRestAgent;
import org.openbaton.sdk.api.rest.VirtualLinkRestAgent;
import org.openbaton.sdk.api.rest.VirtualNetworkFunctionDescriptorRestAgent;
import org.openbaton.sdk.api.util.AbstractRestAgent;
import org.openbaton.sdk.api.util.PropertyReader;

public class RequestFactory {
    private static final String SDK_PROPERTIES_FILE = "sdk.api.properties";
    private static final PropertyReader propertyReader = new PropertyReader("sdk.api.properties");
    private static RequestFactory instance;
    private static ConfigurationRestRequest configurationRequest;
    private static NetworkServiceDescriptorRestAgent networkServiceDescriptorRequest;
    private static NetworkServiceRecordRestAgent networkServiceRecordRequest;
    private static VimInstanceRestAgent vimInstanceRequest;
    private static VirtualLinkRestAgent virtualLinkRequest;
    private static VirtualNetworkFunctionDescriptorRestAgent virtualNetworkFunctionDescriptorRequest;
    private static VNFFGRestAgent vNFFGRequest;
    private static EventAgent eventAgent;
    private static VNFPackageAgent vnfPackageAgent;
    private static ProjectAgent projectAgent;
    private static UserAgent userAgent;
    private static KeyAgent keyAgent;
    private static String username;
    private static String password;
    private String projectId;
    private static boolean sslEnabled;
    private final String nfvoPort;
    private final String nfvoIp;
    private final String version;

    public void setProjectId(String projectId) {
        this.projectId = projectId;
        if (configurationRequest != null) {
            configurationRequest.setProjectId(projectId);
        }
        if (networkServiceDescriptorRequest != null) {
            networkServiceDescriptorRequest.setProjectId(projectId);
        }
        if (networkServiceRecordRequest != null) {
            networkServiceRecordRequest.setProjectId(projectId);
        }
        if (vimInstanceRequest != null) {
            vimInstanceRequest.setProjectId(projectId);
        }
        if (vnfPackageAgent != null) {
            vnfPackageAgent.setProjectId(projectId);
        }
        if (virtualNetworkFunctionDescriptorRequest != null) {
            virtualNetworkFunctionDescriptorRequest.setProjectId(projectId);
        }
        if (projectAgent != null) {
            projectAgent.setProjectId(projectId);
        }
        if (userAgent != null) {
            userAgent.setProjectId(projectId);
        }
        if (eventAgent != null) {
            eventAgent.setProjectId(projectId);
        }
        if (virtualLinkRequest != null) {
            virtualLinkRequest.setProjectId(projectId);
        }
        if (vNFFGRequest != null) {
            vNFFGRequest.setProjectId(projectId);
        }
        if (keyAgent != null) {
            keyAgent.setProjectId(projectId);
        }
    }

    public String getProjectId() {
        return this.projectId;
    }

    private RequestFactory(String username, String password, String projectId, boolean sslEnabled, String nfvoIp, String nfvoPort, String version) {
        RequestFactory.username = username;
        RequestFactory.password = password;
        this.projectId = projectId;
        RequestFactory.sslEnabled = sslEnabled;
        this.nfvoPort = nfvoPort;
        this.nfvoIp = nfvoIp;
        this.version = version;
    }

    public static RequestFactory getInstance(String username, String password, String projectId, boolean sslEnabled, String nfvoIp, String nfvoPort, String version) {
        if (instance == null) {
            return new RequestFactory(username, password, projectId, sslEnabled, nfvoIp, nfvoPort, version);
        }
        return instance;
    }

    public ConfigurationRestRequest getConfigurationAgent() {
        if (configurationRequest == null) {
            configurationRequest = new ConfigurationRestRequest(username, password, this.projectId, sslEnabled, propertyReader.getRestConfigurationUrl(), this.nfvoIp, this.nfvoPort, this.version);
        }
        return configurationRequest;
    }

    public NetworkServiceDescriptorRestAgent getNetworkServiceDescriptorAgent() {
        if (networkServiceDescriptorRequest == null) {
            networkServiceDescriptorRequest = new NetworkServiceDescriptorRestAgent(username, password, this.projectId, sslEnabled, this.nfvoIp, this.nfvoPort, propertyReader.getRestNetworkServiceDescriptorUrl(), this.version);
        }
        return networkServiceDescriptorRequest;
    }

    public NetworkServiceRecordRestAgent getNetworkServiceRecordAgent() {
        if (networkServiceRecordRequest == null) {
            networkServiceRecordRequest = new NetworkServiceRecordRestAgent(username, password, this.projectId, sslEnabled, this.nfvoIp, this.nfvoPort, propertyReader.getRestNetworkServiceRecordUrl(), this.version);
        }
        return networkServiceRecordRequest;
    }

    public VimInstanceRestAgent getVimInstanceAgent() {
        if (vimInstanceRequest == null) {
            vimInstanceRequest = new VimInstanceRestAgent(username, password, this.projectId, sslEnabled, this.nfvoIp, this.nfvoPort, propertyReader.getRestVimInstanceUrl(), this.version);
        }
        return vimInstanceRequest;
    }

    public VirtualLinkRestAgent getVirtualLinkAgent() {
        if (virtualLinkRequest == null) {
            virtualLinkRequest = new VirtualLinkRestAgent(username, password, this.projectId, sslEnabled, this.nfvoIp, this.nfvoPort, propertyReader.getRestVirtualLinkUrl(), this.version);
        }
        return virtualLinkRequest;
    }

    public VirtualNetworkFunctionDescriptorRestAgent getVirtualNetworkFunctionDescriptorAgent() {
        if (virtualNetworkFunctionDescriptorRequest == null) {
            virtualNetworkFunctionDescriptorRequest = new VirtualNetworkFunctionDescriptorRestAgent(username, password, this.projectId, sslEnabled, this.nfvoIp, this.nfvoPort, propertyReader.getRestVirtualNetworkFunctionDescriptorUrl(), this.version);
        }
        return virtualNetworkFunctionDescriptorRequest;
    }

    public VNFFGRestAgent getVNFForwardingGraphAgent() {
        if (vNFFGRequest == null) {
            vNFFGRequest = new VNFFGRestAgent(username, password, this.projectId, sslEnabled, this.nfvoIp, this.nfvoPort, propertyReader.getRestVNFFGUrl(), this.version);
        }
        return vNFFGRequest;
    }

    public EventAgent getEventAgent() {
        if (eventAgent == null) {
            eventAgent = new EventAgent(username, password, this.projectId, sslEnabled, this.nfvoIp, this.nfvoPort, propertyReader.getEventUrl(), this.version);
        }
        return eventAgent;
    }

    public VNFPackageAgent getVNFPackageAgent() {
        if (vnfPackageAgent == null) {
            vnfPackageAgent = new VNFPackageAgent(username, password, this.projectId, sslEnabled, this.nfvoIp, this.nfvoPort, propertyReader.getVNFPackageUrl(), this.version);
        }
        return vnfPackageAgent;
    }

    public ProjectAgent getProjectAgent() {
        if (projectAgent == null) {
            projectAgent = new ProjectAgent(username, password, this.projectId, sslEnabled, this.nfvoIp, this.nfvoPort, propertyReader.getProjectUrl(), this.version);
        }
        return projectAgent;
    }

    public UserAgent getUserAgent() {
        if (userAgent == null) {
            userAgent = new UserAgent(username, password, this.projectId, sslEnabled, this.nfvoIp, this.nfvoPort, propertyReader.getUserUrl(), this.version);
        }
        return userAgent;
    }

    public KeyAgent getKeyAgent() {
        if (keyAgent == null) {
            keyAgent = new KeyAgent(username, password, this.projectId, sslEnabled, this.nfvoIp, this.nfvoPort, propertyReader.getKeyUrl(), this.version);
        }
        return keyAgent;
    }

    public AbstractRestAgent getAbstractAgent(Class clazz, String path) {
        return new AbstractRestAgent(username, password, this.projectId, sslEnabled, this.nfvoIp, this.nfvoPort, path, this.version, clazz);
    }

    static {
        configurationRequest = null;
        networkServiceDescriptorRequest = null;
        networkServiceRecordRequest = null;
        vimInstanceRequest = null;
        virtualLinkRequest = null;
        virtualNetworkFunctionDescriptorRequest = null;
        vNFFGRequest = null;
        eventAgent = null;
        vnfPackageAgent = null;
        projectAgent = null;
        userAgent = null;
        keyAgent = null;
    }
}

