/*
 * Decompiled with CFR 0.152.
 */
package org.openbaton.sdk.api.rest;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.openbaton.catalogue.mano.common.Security;
import org.openbaton.catalogue.mano.descriptor.NetworkServiceDescriptor;
import org.openbaton.catalogue.mano.descriptor.PhysicalNetworkFunctionDescriptor;
import org.openbaton.catalogue.mano.descriptor.VNFDependency;
import org.openbaton.catalogue.mano.descriptor.VirtualNetworkFunctionDescriptor;
import org.openbaton.sdk.api.annotations.Help;
import org.openbaton.sdk.api.exception.SDKException;
import org.openbaton.sdk.api.util.AbstractRestAgent;

public class NetworkServiceDescriptorRestAgent
extends AbstractRestAgent<NetworkServiceDescriptor> {
    public NetworkServiceDescriptorRestAgent(String username, String password, String projectId, boolean sslEnabled, String nfvoIp, String nfvoPort, String path, String version) {
        super(username, password, projectId, sslEnabled, nfvoIp, nfvoPort, path, version, NetworkServiceDescriptor.class);
    }

    @Help(help="Get all the VirtualNetworkFunctionDescriptors of a NetworkServiceDescriptor with specific id")
    @Deprecated
    public List<VirtualNetworkFunctionDescriptor> getVirtualNetworkFunctionDescriptors(String idNSD) throws SDKException {
        String url = idNSD + "/vnfdescriptors";
        return Arrays.asList((VirtualNetworkFunctionDescriptor[])this.requestGetAll(url, VirtualNetworkFunctionDescriptor.class));
    }

    @Help(help="Get the VirtualNetworkFunctionDescriptor with specific id of a NetworkServiceDescriptor with specific id")
    @Deprecated
    public VirtualNetworkFunctionDescriptor getVirtualNetworkFunctionDescriptor(String idNSD, String id_vfn) throws SDKException {
        String url = idNSD + "/vnfdescriptors" + "/" + id_vfn;
        return (VirtualNetworkFunctionDescriptor)this.requestGet(url, VirtualNetworkFunctionDescriptor.class);
    }

    @Help(help="Delete the VirtualNetworkFunctionDescriptor of a NetworkServiceDescriptor with specific id")
    @Deprecated
    public void deleteVirtualNetworkFunctionDescriptors(String idNSD, String id_vfn) throws SDKException {
        String url = idNSD + "/vnfdescriptors" + "/" + id_vfn;
        this.requestDelete(url);
    }

    @Help(help="create the VirtualNetworkFunctionDescriptor of a NetworkServiceDescriptor with specific id")
    @Deprecated
    public VirtualNetworkFunctionDescriptor createVNFD(String idNSD, VirtualNetworkFunctionDescriptor virtualNetworkFunctionDescriptor) throws SDKException {
        String url = idNSD + "/vnfdescriptors" + "/";
        return (VirtualNetworkFunctionDescriptor)this.requestPost(url, (Serializable)virtualNetworkFunctionDescriptor);
    }

    @Help(help="Update the VirtualNetworkFunctionDescriptor of a NetworkServiceDescriptor with specific id")
    @Deprecated
    public VirtualNetworkFunctionDescriptor updateVNFD(String idNSD, String id_vfn, VirtualNetworkFunctionDescriptor virtualNetworkFunctionDescriptor) throws SDKException {
        String url = idNSD + "/vnfdescriptors" + "/" + id_vfn;
        return (VirtualNetworkFunctionDescriptor)this.requestPut(url, (Serializable)virtualNetworkFunctionDescriptor);
    }

    @Help(help="Get all the VirtualNetworkFunctionDescriptor Dependency of a NetworkServiceDescriptor with specific id")
    public List<VNFDependency> getVNFDependencies(String idNSD) throws SDKException {
        String url = idNSD + "/vnfdependencies";
        return Arrays.asList((VNFDependency[])this.requestGetAll(url, VNFDependency.class));
    }

    @Help(help="get the VirtualNetworkFunctionDescriptor dependency with specific id of a NetworkServiceDescriptor with specific id")
    public VNFDependency getVNFDependency(String idNSD, String id_vnfd) throws SDKException {
        String url = idNSD + "/vnfdependencies" + "/" + id_vnfd;
        return (VNFDependency)this.requestGet(url, VNFDependency.class);
    }

    @Help(help="Delete the VirtualNetworkFunctionDescriptor dependency of a NetworkServiceDescriptor with specific id")
    public void deleteVNFDependency(String idNSD, String id_vnfd) throws SDKException {
        String url = idNSD + "/vnfdependencies" + "/" + id_vnfd;
        this.requestDelete(url);
    }

    @Help(help="Create the VirtualNetworkFunctionDescriptor dependency of a NetworkServiceDescriptor with specific id")
    public VNFDependency createVNFDependency(String idNSD, VNFDependency vnfDependency) throws SDKException {
        String url = idNSD + "/vnfdependencies" + "/";
        return (VNFDependency)this.requestPost(url, (Serializable)vnfDependency);
    }

    @Help(help="Update the VirtualNetworkFunctionDescriptor dependency of a NetworkServiceDescriptor with specific id")
    public VNFDependency updateVNFD(String idNSD, String id_vnfd, VNFDependency vnfDependency) throws SDKException {
        String url = idNSD + "/vnfdependencies" + "/" + id_vnfd;
        return (VNFDependency)this.requestPut(url, (Serializable)vnfDependency);
    }

    @Help(help="Get all the PhysicalNetworkFunctionDescriptors of a NetworkServiceDescriptor with specific id")
    public List<PhysicalNetworkFunctionDescriptor> getPhysicalNetworkFunctionDescriptors(String idNSD) throws SDKException {
        String url = idNSD + "/pnfdescriptors";
        return Arrays.asList((PhysicalNetworkFunctionDescriptor[])this.requestGetAll(url, PhysicalNetworkFunctionDescriptor.class));
    }

    @Help(help="Get the PhysicalNetworkFunctionDescriptor with specific id of a NetworkServiceDescriptor with specific id")
    public PhysicalNetworkFunctionDescriptor getPhysicalNetworkFunctionDescriptor(String idNSD, String idPnf) throws SDKException {
        String url = idNSD + "/pnfdescriptors" + "/" + idPnf;
        return (PhysicalNetworkFunctionDescriptor)this.requestGetWithStatusAccepted(url, PhysicalNetworkFunctionDescriptor.class);
    }

    @Help(help="Delete the PhysicalNetworkFunctionDescriptor of a NetworkServiceDescriptor with specific id")
    public void deletePhysicalNetworkFunctionDescriptor(String idNSD, String idPnf) throws SDKException {
        String url = idNSD + "/pnfdescriptors" + "/" + idPnf;
        this.requestDelete(url);
    }

    @Help(help="Create the PhysicalNetworkFunctionDescriptor of a NetworkServiceDescriptor with specific id")
    public PhysicalNetworkFunctionDescriptor createPhysicalNetworkFunctionDescriptor(String idNSD, PhysicalNetworkFunctionDescriptor physicalNetworkFunctionDescriptor) throws SDKException {
        String url = idNSD + "/pnfdescriptors";
        return (PhysicalNetworkFunctionDescriptor)this.requestPost(url, (Serializable)physicalNetworkFunctionDescriptor);
    }

    @Help(help="Update the PhysicalNetworkFunctionDescriptor of a NetworkServiceDescriptor with specific id")
    public PhysicalNetworkFunctionDescriptor updatePNFD(String idNSD, String idPnf, PhysicalNetworkFunctionDescriptor physicalNetworkFunctionDescriptor) throws SDKException {
        String url = idNSD + "/pnfdescriptors" + "/" + idPnf;
        return (PhysicalNetworkFunctionDescriptor)this.requestPut(url, (Serializable)physicalNetworkFunctionDescriptor);
    }

    @Help(help="Get all the Security of a NetworkServiceDescriptor with specific id")
    public Security getSecurities(String idNSD) throws SDKException {
        String url = idNSD + "/security";
        return (Security)this.requestGet(url, Security.class);
    }

    @Help(help="Delete the Security of a NetworkServiceDescriptor with specific id")
    public void deleteSecurity(String idNSD, String id_s) throws SDKException {
        String url = idNSD + "/security" + "/" + id_s;
        this.requestDelete(url);
    }

    @Help(help="create the Security of a NetworkServiceDescriptor with specific id")
    public Security createSecurity(String idNSD, Security security) throws SDKException {
        String url = idNSD + "/security" + "/";
        return (Security)this.requestPost(url, (Serializable)security);
    }

    @Help(help="Update the Security of a NetworkServiceDescriptor with specific id")
    public Security updateSecurity(String idNSD, String id_s, Security security) throws SDKException {
        String url = idNSD + "/security" + "/" + id_s;
        return (Security)this.requestPut(url, (Serializable)security);
    }
}

