/*
 * Decompiled with CFR 0.152.
 */
package org.openbaton.sdk.api.rest;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.openbaton.catalogue.mano.descriptor.VNFComponent;
import org.openbaton.catalogue.mano.record.NetworkServiceRecord;
import org.openbaton.catalogue.mano.record.PhysicalNetworkFunctionRecord;
import org.openbaton.catalogue.mano.record.VNFCInstance;
import org.openbaton.catalogue.mano.record.VNFRecordDependency;
import org.openbaton.catalogue.mano.record.VirtualNetworkFunctionRecord;
import org.openbaton.catalogue.nfvo.Configuration;
import org.openbaton.catalogue.nfvo.messages.Interfaces.NFVMessage;
import org.openbaton.sdk.api.annotations.Help;
import org.openbaton.sdk.api.exception.SDKException;
import org.openbaton.sdk.api.util.AbstractRestAgent;

public class NetworkServiceRecordRestAgent
extends AbstractRestAgent<NetworkServiceRecord> {
    public NetworkServiceRecordRestAgent(String username, String password, String projectId, boolean sslEnabled, String nfvoIp, String nfvoPort, String path, String version) {
        super(username, password, projectId, sslEnabled, nfvoIp, nfvoPort, path, version, NetworkServiceRecord.class);
    }

    @Help(help="Create NetworkServiceRecord from NetworkServiceDescriptor id")
    public NetworkServiceRecord create(String id, HashMap<String, ArrayList<String>> vduVimInstances, ArrayList<String> keys, HashMap<String, Configuration> configurations) throws SDKException {
        HashMap<String, Cloneable> jsonBody = new HashMap<String, Cloneable>();
        jsonBody.put("keys", keys);
        jsonBody.put("vduVimInstances", vduVimInstances);
        jsonBody.put("configurations", configurations);
        return (NetworkServiceRecord)this.requestPost("/" + id, jsonBody, (Type)((Object)NetworkServiceRecord.class));
    }

    @Help(help="Get all the VirtualNetworkFunctionRecords of NetworkServiceRecord with specific id")
    public List<VirtualNetworkFunctionRecord> getVirtualNetworkFunctionRecords(String id) throws SDKException {
        String url = id + "/vnfrecords";
        return Arrays.asList((VirtualNetworkFunctionRecord[])this.requestGetAll(url, VirtualNetworkFunctionRecord.class));
    }

    @Help(help="Get the VirtualNetworkFunctionRecord of NetworkServiceRecord with specific id")
    public VirtualNetworkFunctionRecord getVirtualNetworkFunctionRecord(String id, String id_vnf) throws SDKException {
        String url = id + "/vnfrecords" + "/" + id_vnf;
        return (VirtualNetworkFunctionRecord)this.requestGet(url, VirtualNetworkFunctionRecord.class);
    }

    @Help(help="Delete the VirtualNetworkFunctionRecord of NetworkServiceRecord with specific id")
    public void deleteVirtualNetworkFunctionRecord(String id, String id_vnf) throws SDKException {
        String url = id + "/vnfrecords" + "/" + id_vnf;
        this.requestDelete(url);
    }

    @Help(help="create VNFCInstance in standby")
    public void createVNFCInstanceInStandby(String idNSR, String idVNF, String idVdu, VNFComponent component) throws SDKException {
        String url = idNSR + "/vnfrecords/" + idVNF + "/vdunits/" + idVdu + "/vnfcinstances/standby";
        this.requestPost(url, (Serializable)component);
    }

    @Help(help="switch to standby")
    public void switchToStandby(String idNSR, String idVNF, String idVdu, String idVnfc, VNFCInstance failedVnfcInstance) throws SDKException {
        String url = idNSR + "/vnfrecords/" + idVNF + "/vdunits/" + idVdu + "/vnfcinstances/" + idVnfc + "/switchtostandby";
        this.requestPost(url, (Serializable)failedVnfcInstance);
    }

    @Help(help="Execute a specific action specified in the nfvMessage")
    public void postAction(String idNSR, String idVNF, String idVdu, String idVnfc, NFVMessage nfvMessage) throws SDKException {
        String url = idNSR + "/vnfrecords/" + idVNF + "/vdunits/" + idVdu + "/vnfcinstances/" + idVnfc + "/actions";
        this.requestPost(url, (Serializable)nfvMessage);
    }

    @Help(help="create VirtualNetworkFunctionRecord")
    public VirtualNetworkFunctionRecord createVNFR(String idNSR, VirtualNetworkFunctionRecord virtualNetworkFunctionRecord) throws SDKException {
        String url = idNSR + "/vnfrecords";
        return (VirtualNetworkFunctionRecord)this.requestPost(url, (Serializable)virtualNetworkFunctionRecord);
    }

    @Help(help="create VNFCInstance. Aka SCALE OUT")
    public void createVNFCInstance(String idNSR, String idVNF, VNFComponent component) throws SDKException {
        String url = idNSR + "/vnfrecords/" + idVNF + "/vdunits/vnfcinstances";
        this.requestPost(url, (Serializable)component);
    }

    @Help(help="create VNFCInstance. Aka SCALE OUT")
    public void createVNFCInstance(String idNSR, String idVNF, String idVDU, VNFComponent component) throws SDKException {
        String url = idNSR + "/vnfrecords/" + idVNF + "/vdunits/" + idVDU + "/vnfcinstances";
        this.requestPost(url, (Serializable)component);
    }

    @Help(help="remove VNFCInstance. Aka SCALE IN")
    public void deleteVNFCInstance(String idNSR, String idVNF) throws SDKException {
        String url = idNSR + "/vnfrecords/" + idVNF + "/vdunits/vnfcinstances";
        this.requestDelete(url);
    }

    @Help(help="remove VNFCInstance. Aka SCALE IN")
    public void deleteVNFCInstance(String idNSR, String idVNF, String idVDU) throws SDKException {
        String url = idNSR + "/vnfrecords/" + idVNF + "/vdunits/" + idVDU + "/vnfcinstances";
        this.requestDelete(url);
    }

    @Help(help="remove VNFCInstance. Aka SCALE IN")
    public void deleteVNFCInstance(String idNSR, String idVNF, String idVDU, String idVNFCInstance) throws SDKException {
        String url = idNSR + "/vnfrecords/" + idVNF + "/vdunits/" + idVDU + "/vnfcinstances/" + idVNFCInstance;
        this.requestDelete(url);
    }

    @Help(help="update VirtualNetworkFunctionRecord")
    public String updateVNFR(String idNSR, String id_vnfr, VirtualNetworkFunctionRecord virtualNetworkFunctionRecord) throws SDKException {
        String url = idNSR + "/vnfrecords" + "/" + id_vnfr;
        return this.requestPut(url, (Serializable)virtualNetworkFunctionRecord).toString();
    }

    @Help(help="Get all the VirtualNetworkFunctionRecord dependencies of NetworkServiceRecord with specific id")
    public List<VNFRecordDependency> getVNFDependencies(String idNSR) throws SDKException {
        String url = idNSR + "/vnfdependencies";
        return Arrays.asList((VNFRecordDependency[])this.requestGetAll(url, VNFRecordDependency.class));
    }

    @Help(help="Get the VirtualNetworkFunctionRecord Dependency of a NetworkServiceRecord with specific id")
    public VNFRecordDependency getVNFDependency(String idNSR, String id_vnfrdep) throws SDKException {
        String url = idNSR + "/vnfdependencies" + "/" + id_vnfrdep;
        return (VNFRecordDependency)this.requestGet(url, VNFRecordDependency.class);
    }

    @Help(help="Delete the VirtualNetworkFunctionRecord Dependency of a NetworkServiceRecord with specific id")
    public void deleteVNFDependency(String idNSR, String id_vnfd) throws SDKException {
        String url = idNSR + "/vnfdependencies" + "/" + id_vnfd;
        this.requestDelete(url);
    }

    @Help(help="Create the VirtualNetworkFunctionRecord Dependency of a NetworkServiceRecord with specific id")
    public VNFRecordDependency postVNFDependency(String idNSR, VNFRecordDependency vnfDependency) throws SDKException {
        String url = idNSR + "/vnfdependencies" + "/";
        return (VNFRecordDependency)this.requestPost(url, (Serializable)vnfDependency);
    }

    @Help(help="Update the VirtualNetworkFunctionRecord Dependency of a NetworkServiceRecord with specific id")
    public VNFRecordDependency updateVNFDependency(String idNSR, String id_vnfrDep, VNFRecordDependency vnfDependency) throws SDKException {
        String url = idNSR + "/vnfdependencies" + "/" + id_vnfrDep;
        return (VNFRecordDependency)this.requestPut(url, (Serializable)vnfDependency);
    }

    @Help(help="Start the specified VNFC Instance")
    public void startVNFCInstance(String nsrId, String vnfId, String vduId, String vnfciId) throws SDKException {
        String url = nsrId + "/vnfrecords/" + vnfId + "/vdunits/" + vduId + "/vnfcinstances/" + vnfciId + "/start";
        this.requestPost(url);
    }

    @Help(help="Stop the specified VNFC Instance")
    public void stopVNFCInstance(String nsrId, String vnfId, String vduId, String vnfciId) throws SDKException {
        String url = nsrId + "/vnfrecords/" + vnfId + "/vdunits/" + vduId + "/vnfcinstances/" + vnfciId + "/stop";
        this.requestPost(url);
    }

    @Help(help="Get all the PhysicalNetworkFunctionRecords of a specific NetworkServiceRecord with id")
    public List<PhysicalNetworkFunctionRecord> getPhysicalNetworkFunctionRecords(String idNSR) throws SDKException {
        String url = idNSR + "/pnfrecords";
        return Arrays.asList((PhysicalNetworkFunctionRecord[])this.requestGetAll(url, PhysicalNetworkFunctionRecord.class));
    }

    @Help(help="Get the PhysicalNetworkFunctionRecord of a NetworkServiceRecord with specific id")
    public PhysicalNetworkFunctionRecord getPhysicalNetworkFunctionRecord(String idNSR, String idPnf) throws SDKException {
        String url = idNSR + "/pnfrecords" + "/" + idPnf;
        return (PhysicalNetworkFunctionRecord)this.requestGetWithStatusAccepted(url, PhysicalNetworkFunctionRecord.class);
    }

    @Help(help="Delete the PhysicalNetworkFunctionRecord of a NetworkServiceRecord with specific id")
    public void deletePhysicalNetworkFunctionRecord(String idNSR, String idPnf) throws SDKException {
        String url = idNSR + "/pnfrecords" + "/" + idPnf;
        this.requestDelete(url);
    }

    @Help(help="Create the PhysicalNetworkFunctionRecord of a NetworkServiceRecord with specific id")
    public PhysicalNetworkFunctionRecord postPhysicalNetworkFunctionRecord(String idNSR, PhysicalNetworkFunctionRecord physicalNetworkFunctionRecord) throws SDKException {
        String url = idNSR + "/pnfrecords" + "/";
        return (PhysicalNetworkFunctionRecord)this.requestPost(url, (Serializable)physicalNetworkFunctionRecord);
    }

    @Help(help="Update the PhysicalNetworkFunctionRecord of a NetworkServiceRecord with specific id")
    public PhysicalNetworkFunctionRecord updatePNFD(String idNSR, String idPnf, PhysicalNetworkFunctionRecord physicalNetworkFunctionRecord) throws SDKException {
        String url = idNSR + "/pnfrecords" + "/" + idPnf;
        return (PhysicalNetworkFunctionRecord)this.requestPut(url, (Serializable)physicalNetworkFunctionRecord);
    }
}

