/*
 * Decompiled with CFR 0.152.
 */
package org.openbaton.sdk.api.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.openbaton.sdk.api.annotations.Help;
import org.openbaton.sdk.api.exception.SDKException;
import org.openbaton.sdk.api.util.RestRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractRestAgent<T extends Serializable>
extends RestRequest {
    private final Class<T> clazz;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public AbstractRestAgent(String username, String password, String projectId, boolean sslEnabled, String nfvoIp, String nfvoPort, String path, String version, Class<T> tClass) {
        super(username, password, projectId, sslEnabled, nfvoIp, nfvoPort, path, version);
        this.clazz = tClass;
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    @Help(help="Create the object of type {#}")
    public T create(T object) throws SDKException {
        return (T)this.requestPost((Serializable)object);
    }

    @Help(help="Delete the object of type {#} passing the id")
    public void delete(String id) throws SDKException {
        this.requestDelete(id);
    }

    @Help(help="Find all the objects of type {#}")
    public List<T> findAll() throws SDKException, ClassNotFoundException {
        return Arrays.asList((Serializable[])this.requestGet(null, this.clazz));
    }

    @Help(help="Find the object of type {#} through the id")
    public T findById(String id) throws SDKException, ClassNotFoundException {
        return (T)((Serializable)this.requestGet(id, this.clazz));
    }

    @Help(help="Update the object of type {#} passing the new object and the id of the old object")
    public T update(T object, String id) throws SDKException {
        return (T)this.requestPut(id, (Serializable)object);
    }
}

