/*
 * Decompiled with CFR 0.152.
 */
package org.openbaton.sdk.api.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertyReader {
    private Properties sdkProperties;

    public PropertyReader(String sdkPropertiesPath) {
        this.sdkProperties = this.readProperties(sdkPropertiesPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readProperties(String propertiesPath) {
        Properties properties = null;
        InputStream inputStream = null;
        try {
            inputStream = PropertyReader.class.getClassLoader().getResourceAsStream(propertiesPath);
            properties = new Properties();
            properties.load(inputStream);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return properties;
    }

    public String getApiUrl() {
        return this.sdkProperties.getProperty("apiUrl");
    }

    public String getRestConfigurationUrl() {
        return this.sdkProperties.getProperty("restConfigurationPath");
    }

    public String getRestImageUrl() {
        return this.sdkProperties.getProperty("restImagePath");
    }

    public String getRestNetworkServiceDescriptorUrl() {
        return this.sdkProperties.getProperty("restNetworkServiceDescriptorPath");
    }

    public String getRestNetworkServiceRecordUrl() {
        return this.sdkProperties.getProperty("restNetworkServiceRecordPath");
    }

    public String getRestVimInstanceUrl() {
        return this.sdkProperties.getProperty("restVimInstancePath");
    }

    public String getRestVirtualLinkUrl() {
        return this.sdkProperties.getProperty("restVirtualLinkPath");
    }

    public String getRestVNFFGUrl() {
        return this.sdkProperties.getProperty("restVNFFGPath");
    }

    public String getEventUrl() {
        return this.sdkProperties.getProperty("restEventPath");
    }

    public String getVNFPackageUrl() {
        return this.sdkProperties.getProperty("restVNFPackagePath");
    }

    public String getRestVirtualNetworkFunctionDescriptorUrl() {
        return this.sdkProperties.getProperty("restVirtualNetworkFunctionDescriptorPath");
    }

    public String getProjectUrl() {
        return this.sdkProperties.getProperty("restProjectPath");
    }

    public String getUserUrl() {
        return this.sdkProperties.getProperty("restUserPath");
    }

    public String getKeyUrl() {
        return this.sdkProperties.getProperty("restKeyPath");
    }
}

