/*
 * Decompiled with CFR 0.152.
 */
package org.openbaton.sdk.api.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mashape.unirest.http.JsonNode;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.openbaton.catalogue.nfvo.VNFPackage;
import org.openbaton.sdk.api.exception.SDKException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestRequest {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    protected final String baseUrl;
    protected Gson mapper;
    private String username;
    private String password;
    private String projectId;
    private boolean sslEnabled;
    private String authStr = "openbatonOSClient:secret";
    private String encoding = Base64.encodeBase64String((byte[])this.authStr.getBytes());
    private final String provider;
    private String token = null;
    private String bearerToken = null;
    private CloseableHttpClient httpClient;
    private RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(10000).setConnectTimeout(60000).build();

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public RestRequest(String username, String password, String projectId, boolean sslEnabled, String nfvoIp, String nfvoPort, String path, String version) {
        if (sslEnabled) {
            this.baseUrl = "https://" + nfvoIp + ":" + nfvoPort + "/api/v" + version + path;
            this.provider = "https://" + nfvoIp + ":" + nfvoPort + "/oauth/token";
        } else {
            this.baseUrl = "http://" + nfvoIp + ":" + nfvoPort + "/api/v" + version + path;
            this.provider = "http://" + nfvoIp + ":" + nfvoPort + "/oauth/token";
        }
        this.username = username;
        this.password = password;
        this.projectId = projectId;
        GsonBuilder builder = new GsonBuilder();
        this.mapper = builder.setPrettyPrinting().create();
        this.httpClient = sslEnabled ? this.getHttpClientForSsl() : HttpClientBuilder.create().setDefaultRequestConfig(this.config).setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).build();
    }

    public String requestPost(String id) throws SDKException {
        CloseableHttpResponse response = null;
        HttpPost httpPost = null;
        try {
            this.log.debug("baseUrl: " + this.baseUrl);
            this.log.debug("id: " + this.baseUrl + "/" + id);
            try {
                this.checkToken();
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new SDKException("Could not get token", e.getStackTrace(), "Could not get token because: " + e.getMessage());
            }
            this.log.debug("Executing post on: " + this.baseUrl + "/" + id);
            httpPost = new HttpPost(this.baseUrl + "/" + id);
            httpPost.setHeader((Header)new BasicHeader("accept", "application/json"));
            httpPost.setHeader((Header)new BasicHeader("Content-Type", "application/json"));
            httpPost.setHeader((Header)new BasicHeader("project-id", this.projectId));
            if (this.token != null) {
                httpPost.setHeader((Header)new BasicHeader("authorization", this.bearerToken.replaceAll("\"", "")));
            }
            response = this.httpClient.execute((HttpUriRequest)httpPost);
            this.checkStatus(response, 201);
            String result = "";
            if (response.getEntity() != null) {
                result = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            response.close();
            this.log.trace("received: " + result);
            httpPost.releaseConnection();
            return result;
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
            throw new SDKException("Could not http-post or open the object properly", e.getStackTrace(), "Could not http-post or open the object properly because: " + e.getMessage());
        }
        catch (SDKException e) {
            if (response.getStatusLine().getStatusCode() == 401) {
                this.token = null;
                if (httpPost != null) {
                    httpPost.releaseConnection();
                }
                return this.requestPost(id);
            }
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
            try {
                throw new SDKException("Status is " + response.getStatusLine().getStatusCode(), new StackTraceElement[0], EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new SDKException("Status is " + response.getStatusLine().getStatusCode(), new StackTraceElement[0], "could not provide reason because: " + e.getMessage());
            }
        }
    }

    public Serializable requestPost(Serializable object) throws SDKException {
        return this.requestPost("", object);
    }

    public Serializable requestPost(String id, Serializable object) throws SDKException {
        CloseableHttpResponse response = null;
        HttpPost httpPost = null;
        try {
            this.log.trace("Object is: " + object);
            String fileJSONNode = object instanceof String ? (String)((Object)object) : this.mapper.toJson((Object)object);
            this.log.trace("sending: " + fileJSONNode.toString());
            this.log.debug("baseUrl: " + this.baseUrl);
            this.log.debug("id: " + this.baseUrl + "/" + id);
            try {
                this.checkToken();
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new SDKException("Could not get token", e.getStackTrace(), "Could not get token because: " + e.getMessage());
            }
            this.log.debug("Executing post on: " + this.baseUrl + "/" + id);
            httpPost = new HttpPost(this.baseUrl + "/" + id);
            if (!(object instanceof String)) {
                httpPost.setHeader((Header)new BasicHeader("accept", "application/json"));
                httpPost.setHeader((Header)new BasicHeader("Content-Type", "application/json"));
            }
            httpPost.setHeader((Header)new BasicHeader("project-id", this.projectId));
            if (this.token != null) {
                httpPost.setHeader((Header)new BasicHeader("authorization", this.bearerToken.replaceAll("\"", "")));
            }
            httpPost.setEntity((HttpEntity)new StringEntity(fileJSONNode));
            response = this.httpClient.execute((HttpUriRequest)httpPost);
            this.checkStatus(response, 201);
            String result = "";
            if (response.getEntity() != null) {
                result = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            if (response.getStatusLine().getStatusCode() != 204) {
                if (object instanceof String) {
                    return result;
                }
                JsonParser jsonParser = new JsonParser();
                JsonElement jsonElement = jsonParser.parse(result);
                result = this.mapper.toJson(jsonElement);
                this.log.trace("received: " + result);
                this.log.trace("Casting it into: " + object.getClass());
                return (Serializable)this.mapper.fromJson(result, object.getClass());
            }
            response.close();
            httpPost.releaseConnection();
            return null;
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
            throw new SDKException("Could not http-post or open the object properly", e.getStackTrace(), "Could not http-post or open the object properly because: " + e.getMessage());
        }
        catch (SDKException e) {
            if (response != null && response.getStatusLine().getStatusCode() == 401) {
                this.token = null;
                if (httpPost != null) {
                    httpPost.releaseConnection();
                }
                return this.requestPost(id);
            }
            if (response != null) {
                throw e;
            }
            throw e;
        }
    }

    public Serializable requestPost(String id, Serializable object, Type type) throws SDKException {
        CloseableHttpResponse response = null;
        HttpPost httpPost = null;
        try {
            this.log.trace("Object is: " + object);
            String fileJSONNode = this.mapper.toJson((Object)object);
            this.log.trace("sending: " + fileJSONNode.toString());
            this.log.debug("baseUrl: " + this.baseUrl);
            this.log.debug("id: " + this.baseUrl + "/" + id);
            try {
                this.checkToken();
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new SDKException("Could not get token", e.getStackTrace(), "could not get token because: " + e.getMessage());
            }
            this.log.debug("Executing post on: " + this.baseUrl + "/" + id);
            httpPost = new HttpPost(this.baseUrl + "/" + id);
            httpPost.setHeader((Header)new BasicHeader("accept", "application/json"));
            httpPost.setHeader((Header)new BasicHeader("Content-Type", "application/json"));
            httpPost.setHeader((Header)new BasicHeader("project-id", this.projectId));
            if (this.token != null) {
                httpPost.setHeader((Header)new BasicHeader("authorization", this.bearerToken.replaceAll("\"", "")));
            }
            httpPost.setEntity((HttpEntity)new StringEntity(fileJSONNode));
            response = this.httpClient.execute((HttpUriRequest)httpPost);
            this.checkStatus(response, 201);
            String result = "";
            if (response.getEntity() != null) {
                result = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            if (response.getStatusLine().getStatusCode() != 204) {
                JsonParser jsonParser = new JsonParser();
                JsonElement jsonElement = jsonParser.parse(result);
                result = this.mapper.toJson(jsonElement);
                this.log.trace("received: " + result);
                this.log.trace("Casting it into: " + type);
                return (Serializable)this.mapper.fromJson(result, type);
            }
            response.close();
            httpPost.releaseConnection();
            return null;
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
            throw new SDKException("Could not http-post or open the object properly", e.getStackTrace(), "Could not http-post or open the object properly because: " + e.getMessage());
        }
        catch (SDKException e) {
            if (response.getStatusLine().getStatusCode() == 401) {
                this.token = null;
                if (httpPost != null) {
                    httpPost.releaseConnection();
                }
                return this.requestPost(id);
            }
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
            try {
                throw new SDKException("Status is " + response.getStatusLine().getStatusCode(), new StackTraceElement[0], EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new SDKException("Status is " + response.getStatusLine().getStatusCode(), new StackTraceElement[0], "could not provide reason because: " + e.getMessage());
            }
        }
    }

    public VNFPackage requestPostPackage(File f) throws SDKException {
        CloseableHttpResponse response = null;
        HttpPost httpPost = null;
        try {
            try {
                this.checkToken();
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new SDKException("Could not get token", e.getStackTrace(), e.getMessage());
            }
            this.log.debug("Executing post on " + this.baseUrl);
            httpPost = new HttpPost(this.baseUrl);
            httpPost.setHeader((Header)new BasicHeader("accept", "multipart/form-data"));
            httpPost.setHeader((Header)new BasicHeader("project-id", this.projectId));
            if (this.token != null) {
                httpPost.setHeader((Header)new BasicHeader("authorization", this.bearerToken.replaceAll("\"", "")));
            }
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            multipartEntityBuilder.addBinaryBody("file", f);
            httpPost.setEntity(multipartEntityBuilder.build());
            response = this.httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (ClientProtocolException e) {
            httpPost.releaseConnection();
            throw new SDKException("Could not create VNFPackage from file " + f.getName(), e.getStackTrace(), e.getMessage());
        }
        catch (IOException e) {
            httpPost.releaseConnection();
            throw new SDKException("Could not create VNFPackage from file " + f.getName(), e.getStackTrace(), e.getMessage());
        }
        this.checkStatus(response, 200);
        String result = "";
        if (response.getEntity() != null) {
            try {
                result = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (response.getStatusLine().getStatusCode() != 204) {
            JsonParser jsonParser = new JsonParser();
            JsonElement jsonElement = jsonParser.parse(result);
            result = this.mapper.toJson(jsonElement);
            this.log.debug("Uploaded the VNFPackage");
            this.log.trace("received: " + result);
            this.log.trace("Casting it into: " + VNFPackage.class);
            httpPost.releaseConnection();
            return (VNFPackage)this.mapper.fromJson(result, VNFPackage.class);
        }
        httpPost.releaseConnection();
        return null;
    }

    private void checkToken() throws IOException, SDKException {
        if (!(this.username == null || this.password == null || this.token != null || this.username.equals("") && this.password.equals(""))) {
            this.getAccessToken();
        }
    }

    private JsonNode getJsonNode(Serializable object) throws IOException {
        return new JsonNode(this.mapper.toJson((Object)object));
    }

    public void requestDelete(String id) throws SDKException {
        CloseableHttpResponse response = null;
        HttpDelete httpDelete = null;
        try {
            this.log.debug("baseUrl: " + this.baseUrl);
            this.log.debug("id: " + this.baseUrl + "/" + id);
            try {
                this.checkToken();
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new SDKException("Could not get token", e.getStackTrace(), e.getMessage());
            }
            this.log.info("Executing delete on: " + this.baseUrl + "/" + id);
            httpDelete = new HttpDelete(this.baseUrl + "/" + id);
            httpDelete.setHeader((Header)new BasicHeader("project-id", this.projectId));
            if (this.token != null) {
                httpDelete.setHeader((Header)new BasicHeader("authorization", this.bearerToken.replaceAll("\"", "")));
            }
            response = this.httpClient.execute((HttpUriRequest)httpDelete);
            this.checkStatus(response, 204);
            httpDelete.releaseConnection();
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            if (httpDelete != null) {
                httpDelete.releaseConnection();
            }
            throw new SDKException("Could not http-delete", e.getStackTrace(), e.getMessage());
        }
        catch (SDKException e) {
            if (response.getStatusLine().getStatusCode() == 401) {
                this.token = null;
                if (httpDelete != null) {
                    httpDelete.releaseConnection();
                }
                this.requestDelete(id);
                return;
            }
            if (httpDelete != null) {
                httpDelete.releaseConnection();
            }
            throw new SDKException("Could not http-delete or the api response was wrong", e.getStackTrace(), e.getMessage());
        }
    }

    public Object requestGet(String id, Class type) throws SDKException {
        String url = this.baseUrl;
        if (id != null) {
            url = url + "/" + id;
            return this.requestGetWithStatus(url, null, type);
        }
        return this.requestGetAll(url, type, null);
    }

    protected Object requestGetAll(String url, Class type) throws SDKException {
        url = this.baseUrl + "/" + url;
        return this.requestGetAll(url, type, null);
    }

    private Object requestGetAll(String url, Class type, Integer httpStatus) throws SDKException {
        CloseableHttpResponse response = null;
        HttpGet httpGet = null;
        try {
            try {
                this.checkToken();
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new SDKException("Could not get token", e.getStackTrace(), e.getMessage());
            }
            this.log.debug("Executing get on: " + url);
            httpGet = new HttpGet(url);
            httpGet.setHeader((Header)new BasicHeader("project-id", this.projectId));
            if (this.token != null) {
                httpGet.setHeader((Header)new BasicHeader("authorization", this.bearerToken.replaceAll("\"", "")));
            }
            response = this.httpClient.execute((HttpUriRequest)httpGet);
            if (httpStatus != null) {
                this.checkStatus(response, httpStatus);
            } else {
                this.checkStatus(response, 200);
            }
            String result = "";
            if (response.getEntity() != null) {
                result = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            response.close();
            httpGet.releaseConnection();
            this.log.trace("result is: " + result);
            Class<?> aClass = Array.newInstance(type, 3).getClass();
            this.log.trace("class is: " + aClass);
            Object[] o = (Object[])this.mapper.fromJson(result, aClass);
            this.log.trace("deserialized is: " + o);
            return o;
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
            throw new SDKException("Could not http-get", e.getStackTrace(), e.getMessage());
        }
        catch (SDKException e) {
            if (response != null) {
                if (response.getStatusLine().getStatusCode() == 401) {
                    this.token = null;
                    if (httpGet != null) {
                        httpGet.releaseConnection();
                    }
                    return this.requestGetAll(url, type, httpStatus);
                }
                this.log.error(e.getMessage(), (Throwable)e);
                if (httpGet != null) {
                    httpGet.releaseConnection();
                }
                throw new SDKException("Could not authorize", e.getStackTrace(), e.getMessage());
            }
            this.log.error(e.getMessage(), (Throwable)e);
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
            throw e;
        }
    }

    private Object requestGetWithStatus(String url, Integer httpStatus, Class type) throws SDKException {
        CloseableHttpResponse response = null;
        HttpGet httpGet = null;
        try {
            try {
                this.checkToken();
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new SDKException("Could not get token", e.getStackTrace(), e.getMessage());
            }
            this.log.debug("Executing get on: " + url);
            httpGet = new HttpGet(url);
            httpGet.setHeader((Header)new BasicHeader("project-id", this.projectId));
            if (this.token != null) {
                httpGet.setHeader((Header)new BasicHeader("authorization", this.bearerToken.replaceAll("\"", "")));
            }
            response = this.httpClient.execute((HttpUriRequest)httpGet);
            if (httpStatus != null) {
                this.checkStatus(response, httpStatus);
            } else {
                this.checkStatus(response, 200);
            }
            String result = "";
            if (response.getEntity() != null) {
                result = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            response.close();
            httpGet.releaseConnection();
            this.log.trace("result is: " + result);
            JsonParser jsonParser = new JsonParser();
            JsonElement jsonElement = jsonParser.parse(result);
            result = this.mapper.toJson(jsonElement);
            this.log.trace("result is: " + result);
            Class<?> aClass = Array.newInstance(type, 1).getClass();
            this.log.trace("class is: " + aClass);
            Object object = this.mapper.fromJson(result, type);
            return object;
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new SDKException("Could not http-get", e.getStackTrace(), e.getMessage());
        }
        catch (SDKException e) {
            if (response != null) {
                if (response.getStatusLine().getStatusCode() == 401) {
                    this.token = null;
                    if (httpGet != null) {
                        httpGet.releaseConnection();
                    }
                    Object object = this.requestGetWithStatus(url, httpStatus, type);
                    return object;
                }
                this.log.error(e.getMessage(), (Throwable)e);
                throw new SDKException("Could not authorize", e.getStackTrace(), e.getMessage());
            }
            this.log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
        }
    }

    public Object requestGetWithStatusAccepted(String url, Class type) throws SDKException {
        url = this.baseUrl + "/" + url;
        return this.requestGetWithStatus(url, new Integer(202), type);
    }

    public Serializable requestPut(String id, Serializable object) throws SDKException {
        CloseableHttpResponse response = null;
        HttpPut httpPut = null;
        try {
            this.log.trace("Object is: " + object);
            String fileJSONNode = this.mapper.toJson((Object)object);
            try {
                this.checkToken();
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new SDKException("Could not get token", e.getStackTrace(), e.getMessage());
            }
            this.log.debug("Executing put on: " + this.baseUrl + "/" + id);
            httpPut = new HttpPut(this.baseUrl + "/" + id);
            httpPut.setHeader((Header)new BasicHeader("accept", "application/json"));
            httpPut.setHeader((Header)new BasicHeader("Content-Type", "application/json"));
            httpPut.setHeader((Header)new BasicHeader("project-id", this.projectId));
            if (this.token != null) {
                httpPut.setHeader((Header)new BasicHeader("authorization", this.bearerToken.replaceAll("\"", "")));
            }
            httpPut.setEntity((HttpEntity)new StringEntity(fileJSONNode));
            response = this.httpClient.execute((HttpUriRequest)httpPut);
            this.checkStatus(response, 202);
            String result = "";
            if (response.getEntity() != null) {
                result = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            if (response.getStatusLine().getStatusCode() != 204) {
                response.close();
                httpPut.releaseConnection();
                JsonParser jsonParser = new JsonParser();
                JsonElement jsonElement = jsonParser.parse(result);
                result = this.mapper.toJson(jsonElement);
                this.log.trace("received: " + result);
                this.log.trace("Casting it into: " + object.getClass());
                Serializable serializable = (Serializable)this.mapper.fromJson(result, object.getClass());
                return serializable;
            }
            response.close();
            httpPut.releaseConnection();
            Serializable serializable = null;
            return serializable;
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new SDKException("Could not http-put or the api response was wrong or open the object properly", e.getStackTrace(), e.getMessage());
        }
        catch (SDKException e) {
            if (response.getStatusLine().getStatusCode() == 401) {
                this.token = null;
                if (httpPut != null) {
                    httpPut.releaseConnection();
                }
                Serializable serializable = this.requestPut(id, object);
                return serializable;
            }
            throw new SDKException("Could not http-put or the api response was wrong or open the object properly", e.getStackTrace(), e.getMessage());
        }
        finally {
            if (httpPut != null) {
                httpPut.releaseConnection();
            }
        }
    }

    private void checkStatus(CloseableHttpResponse httpResponse, int httpStatus) throws SDKException {
        if (httpResponse.getStatusLine().getStatusCode() != httpStatus) {
            String body;
            this.log.error("Status expected: " + httpStatus + " obtained: " + httpResponse.getStatusLine().getStatusCode());
            this.log.error("httpresponse: " + httpResponse.toString());
            try {
                body = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new SDKException("Status is " + httpResponse.getStatusLine().getStatusCode(), new StackTraceElement[0], "could not provide reason because: " + e.getMessage());
            }
            this.log.error("Body: " + body);
            throw new SDKException("Status is " + httpResponse.getStatusLine().getStatusCode(), new StackTraceElement[0], body);
        }
    }

    private void getAccessToken() throws IOException, SDKException {
        block8: {
            HttpPost httpPost = new HttpPost(this.provider);
            httpPost.setHeader("Authorization", "Basic " + this.encoding);
            ArrayList<BasicNameValuePair> parametersBody = new ArrayList<BasicNameValuePair>();
            parametersBody.add(new BasicNameValuePair("grant_type", "password"));
            parametersBody.add(new BasicNameValuePair("username", this.username));
            parametersBody.add(new BasicNameValuePair("password", this.password));
            this.log.debug("Username is: " + this.username);
            this.log.debug("Password is: " + this.password);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(parametersBody, StandardCharsets.UTF_8));
            CloseableHttpResponse response = null;
            this.log.debug("httpPost is: " + httpPost.toString());
            response = this.httpClient.execute((HttpUriRequest)httpPost);
            String responseString = null;
            responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            int statusCode = response.getStatusLine().getStatusCode();
            response.close();
            httpPost.releaseConnection();
            this.log.trace(statusCode + ": " + responseString);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            if (statusCode != 200) {
                JsonObject error = (JsonObject)gson.fromJson(responseString, JsonObject.class);
                JsonElement detailMessage = error.get("detailMessage");
                if (detailMessage == null) {
                    detailMessage = error.get("errorMessage");
                }
                if (detailMessage == null) {
                    detailMessage = error.get("message");
                }
                if (detailMessage == null) {
                    detailMessage = error.get("description");
                }
                if (detailMessage == null) {
                    detailMessage = error.get("errorDescription");
                }
                this.log.error("Status Code [" + statusCode + "]: Error signing-in [" + (detailMessage != null ? detailMessage.getAsString() : "no error description") + "]");
                if (detailMessage == null) {
                    this.log.error("Got Error from server: \n" + gson.toJson((JsonElement)error));
                }
                throw new SDKException("Status Code [" + statusCode + "]: Error signing-in [" + (detailMessage != null ? detailMessage.getAsString() : "no error description") + "]", new StackTraceElement[]{}, detailMessage != null ? detailMessage.getAsString() : "no error description");
            }
            JsonObject jobj = (JsonObject)new Gson().fromJson(responseString, JsonObject.class);
            this.log.trace("JsonTokeAccess is: " + jobj.toString());
            try {
                String token = jobj.get("value").getAsString();
                this.log.trace(token);
                this.bearerToken = "Bearer " + token;
                this.token = token;
            }
            catch (NullPointerException e) {
                String error = jobj.get("error").getAsString();
                if (!error.equals("invalid_grant")) break block8;
                throw new SDKException("Error during authentication: " + jobj.get("error_description").getAsString(), e.getStackTrace(), e.getMessage());
            }
        }
    }

    private CloseableHttpClient getHttpClientForSsl() {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error("Could not initialize the HttpClient for SSL connections");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (KeyManagementException e) {
            this.log.error("Could not initialize the HttpClient for SSL connections");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (KeyStoreException e) {
            this.log.error("Could not initialize the HttpClient for SSL connections");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1"}, null, (HostnameVerifier)new NoopHostnameVerifier());
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslConnectionSocketFactory).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(this.config).setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(socketFactoryRegistry)).setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).build();
    }

    private class ParseComError
    implements Serializable {
        String error_description;
        String error;

        private ParseComError() {
        }
    }
}

