/*
 * Decompiled with CFR 0.152.
 */
package org.opencord.dhcpl2relay;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.onlab.packet.BasePacket;
import org.onlab.packet.DHCP;
import org.onlab.packet.DHCPOption;
import org.onlab.packet.DHCPPacketType;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onlab.packet.UDP;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.packet.DefaultInboundPacket;
import org.onosproject.net.packet.DefaultPacketContext;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketServiceAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DhcpL2RelayTestBase {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int TRANSACTION_ID = 1000;
    private static final String EXPECTED_IP = "10.2.0.2";
    List<BasePacket> savedPackets = new LinkedList<BasePacket>();
    PacketProcessor packetProcessor;

    void savePacket(BasePacket packet) {
        this.savedPackets.add(packet);
    }

    BasePacket getPacket() {
        return this.savedPackets.remove(0);
    }

    void sendPacket(Ethernet pkt, ConnectPoint cp) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(pkt.serialize());
        DefaultInboundPacket inPacket = new DefaultInboundPacket(cp, pkt, byteBuffer);
        TestPacketContext context = new TestPacketContext(127L, (InboundPacket)inPacket, null, false);
        this.packetProcessor.process((PacketContext)context);
    }

    private Ethernet construcEthernetPacket(MacAddress srcMac, MacAddress dstMac, String dstIp, byte dhcpReqRsp, MacAddress clientHwAddress, Ip4Address dhcpClientIpAddress) {
        Ethernet ethPkt = new Ethernet();
        ethPkt.setSourceMACAddress(srcMac);
        ethPkt.setDestinationMACAddress(dstMac);
        ethPkt.setEtherType(Ethernet.TYPE_IPV4);
        ethPkt.setVlanID((short)2);
        ethPkt.setPriorityCode((byte)6);
        IPv4 ipv4Reply = new IPv4();
        ipv4Reply.setSourceAddress(0);
        ipv4Reply.setDestinationAddress(dstIp);
        ipv4Reply.setTtl((byte)127);
        UDP udpReply = new UDP();
        udpReply.setSourcePort(68);
        udpReply.setDestinationPort(67);
        DHCP dhcpReply = new DHCP();
        dhcpReply.setOpCode(dhcpReqRsp);
        dhcpReply.setYourIPAddress(dhcpClientIpAddress.toInt());
        dhcpReply.setServerIPAddress(0);
        byte[] serverNameBytes = new byte[64];
        String result = new String(serverNameBytes, StandardCharsets.US_ASCII).trim();
        dhcpReply.setServerName(result);
        byte[] bootFileBytes = new byte[128];
        String result1 = new String(bootFileBytes, StandardCharsets.US_ASCII).trim();
        dhcpReply.setBootFileName(result1);
        dhcpReply.setTransactionId(1000);
        dhcpReply.setClientHardwareAddress(clientHwAddress.toBytes());
        dhcpReply.setHardwareType((byte)1);
        dhcpReply.setHardwareAddressLength((byte)6);
        udpReply.setPayload((IPacket)dhcpReply);
        ipv4Reply.setPayload((IPacket)udpReply);
        ethPkt.setPayload((IPacket)ipv4Reply);
        return ethPkt;
    }

    Ethernet constructDhcpDiscoverPacket(MacAddress clientMac) {
        Ethernet pkt = this.construcEthernetPacket(clientMac, MacAddress.BROADCAST, "255.255.255.255", (byte)1, MacAddress.NONE, Ip4Address.valueOf((String)"0.0.0.0"));
        IPv4 ipv4Packet = (IPv4)pkt.getPayload();
        UDP udpPacket = (UDP)ipv4Packet.getPayload();
        DHCP dhcpPacket = (DHCP)udpPacket.getPayload();
        dhcpPacket.setOptions(this.constructDhcpOptions(DHCPPacketType.DHCPDISCOVER));
        return pkt;
    }

    Ethernet constructDhcpRequestPacket(MacAddress clientMac) {
        Ethernet pkt = this.construcEthernetPacket(clientMac, MacAddress.BROADCAST, "255.255.255.255", (byte)1, MacAddress.NONE, Ip4Address.valueOf((String)"0.0.0.0"));
        IPv4 ipv4Packet = (IPv4)pkt.getPayload();
        UDP udpPacket = (UDP)ipv4Packet.getPayload();
        DHCP dhcpPacket = (DHCP)udpPacket.getPayload();
        dhcpPacket.setOptions(this.constructDhcpOptions(DHCPPacketType.DHCPREQUEST));
        return pkt;
    }

    Ethernet constructDhcpOfferPacket(MacAddress servMac, MacAddress clientMac, String ipAddress, String dhcpClientIpAddress) {
        Ethernet pkt = this.construcEthernetPacket(servMac, clientMac, ipAddress, (byte)2, clientMac, Ip4Address.valueOf((String)dhcpClientIpAddress));
        IPv4 ipv4Packet = (IPv4)pkt.getPayload();
        UDP udpPacket = (UDP)ipv4Packet.getPayload();
        DHCP dhcpPacket = (DHCP)udpPacket.getPayload();
        dhcpPacket.setOptions(this.constructDhcpOptions(DHCPPacketType.DHCPOFFER));
        return pkt;
    }

    Ethernet constructDhcpAckPacket(MacAddress servMac, MacAddress clientMac, String ipAddress, String dhcpClientIpAddress) {
        Ethernet pkt = this.construcEthernetPacket(servMac, clientMac, ipAddress, (byte)2, clientMac, Ip4Address.valueOf((String)dhcpClientIpAddress));
        IPv4 ipv4Packet = (IPv4)pkt.getPayload();
        UDP udpPacket = (UDP)ipv4Packet.getPayload();
        DHCP dhcpPacket = (DHCP)udpPacket.getPayload();
        dhcpPacket.setOptions(this.constructDhcpOptions(DHCPPacketType.DHCPACK));
        return pkt;
    }

    private List<DHCPOption> constructDhcpOptions(DHCPPacketType packetType) {
        DHCPOption option = new DHCPOption();
        ArrayList<DHCPOption> optionList = new ArrayList<DHCPOption>();
        option.setCode(DHCP.DHCPOptionCode.OptionCode_MessageType.getValue());
        option.setLength((byte)1);
        byte[] optionData = new byte[]{(byte)packetType.getValue()};
        option.setData(optionData);
        optionList.add(option);
        option = new DHCPOption();
        option.setCode(DHCP.DHCPOptionCode.OptionCode_RequestedIP.getValue());
        option.setLength((byte)4);
        optionData = Ip4Address.valueOf((String)EXPECTED_IP).toOctets();
        option.setData(optionData);
        optionList.add(option);
        option = new DHCPOption();
        option.setCode(DHCP.DHCPOptionCode.OptionCode_END.getValue());
        option.setLength((byte)1);
        optionList.add(option);
        return optionList;
    }

    final class TestPacketContext
    extends DefaultPacketContext {
        private TestPacketContext(long time, InboundPacket inPkt, OutboundPacket outPkt, boolean block) {
            super(time, inPkt, outPkt, block);
        }

        public void send() {
        }
    }

    class MockPacketService
    extends PacketServiceAdapter {
        MockPacketService() {
        }

        public void addProcessor(PacketProcessor processor, int priority) {
            DhcpL2RelayTestBase.this.packetProcessor = processor;
        }

        public void emit(OutboundPacket packet) {
            try {
                Ethernet eth = (Ethernet)Ethernet.deserializer().deserialize(packet.data().array(), 0, packet.data().array().length);
                DhcpL2RelayTestBase.this.savePacket((BasePacket)eth);
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }
}

