/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.morpheus.api.io.neo4j.sync;

import java.io.Serializable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.scala.Logger$;
import org.apache.logging.log4j.scala.Logging;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.neo4j.driver.v1.summary.ResultSummary;
import org.opencypher.morpheus.api.MorpheusSession;
import org.opencypher.morpheus.api.io.neo4j.sync.MergeWriters$;
import org.opencypher.okapi.api.graph.PropertyGraph;
import org.opencypher.okapi.api.schema.PropertyGraphSchema;
import org.opencypher.okapi.neo4j.io.MetaLabelSupport$;
import org.opencypher.okapi.neo4j.io.Neo4jConfig;
import org.opencypher.okapi.neo4j.io.Neo4jHelpers;
import org.opencypher.okapi.neo4j.io.Neo4jHelpers$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

public final class Neo4jGraphMerge$
implements Logging {
    public static Neo4jGraphMerge$ MODULE$;
    private final ExtendedLogger logger;

    static {
        new Neo4jGraphMerge$();
    }

    public ExtendedLogger logger() {
        return this.logger;
    }

    public void org$apache$logging$log4j$scala$Logging$_setter_$logger_$eq(ExtendedLogger x$1) {
        this.logger = x$1;
    }

    public void createIndexes(String graphName, Neo4jConfig config, Map<String, Set<String>> nodeKeys) {
        Option maybeMetaLabel = MetaLabelSupport$.MODULE$.RichGraphName(graphName).getMetaLabel();
        Neo4jHelpers.RichConfig$.MODULE$.withSession$extension(Neo4jHelpers$.MODULE$.RichConfig(config), (Function1 & Serializable & scala.Serializable)session -> {
            BoxedUnit boxedUnit;
            Option option = maybeMetaLabel;
            if (None$.MODULE$.equals(option)) {
                nodeKeys.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    String query;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        String label = (String)tuple2._1();
                        Set keys = (Set)tuple2._2();
                        String nodeVar = "n";
                        String propertyString = ((TraversableOnce)keys.map((Function1 & Serializable & scala.Serializable)k -> new StringBuilder(3).append(nodeVar).append(".`").append((String)k).append("`").toString(), Set$.MODULE$.canBuildFrom())).mkString("(", ", ", ")");
                        query = new StringBuilder(43).append("CREATE CONSTRAINT ON (").append(nodeVar).append(Neo4jHelpers.RichLabelString$.MODULE$.cypherLabelPredicate$extension(Neo4jHelpers$.MODULE$.RichLabelString(label))).append(") ASSERT ").append(propertyString).append(" IS NODE KEY").toString();
                        if (MODULE$.logger().isEnabled(Level.DEBUG)) {
                            Logger$.MODULE$.logMessage$extension1(MODULE$.logger(), Level.DEBUG, null, (CharSequence)new StringBuilder(31).append("Creating node key constraints: ").append(query).toString(), null);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    ResultSummary resultSummary = session.run(query).consume();
                    return resultSummary;
                });
                nodeKeys.keySet().foreach((Function1 & Serializable & scala.Serializable)label -> {
                    BoxedUnit boxedUnit;
                    String cmd = new StringBuilder(20).append("CREATE INDEX ON ").append(Neo4jHelpers.RichLabelString$.MODULE$.cypherLabelPredicate$extension(Neo4jHelpers$.MODULE$.RichLabelString(label))).append("(`").append(Neo4jHelpers.Neo4jDefaults$.MODULE$.metaPropertyKey()).append("`)").toString();
                    if (MODULE$.logger().isEnabled(Level.DEBUG)) {
                        Logger$.MODULE$.logMessage$extension1(MODULE$.logger(), Level.DEBUG, null, (CharSequence)new StringBuilder(38).append("Creating index for meta property key: ").append(cmd).toString(), null);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return session.run(cmd).consume();
                });
                boxedUnit = BoxedUnit.UNIT;
            } else if (option instanceof Some) {
                BoxedUnit boxedUnit2;
                Some some = (Some)option;
                String ml = (String)some.value();
                nodeKeys.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    String cmd;
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        String label = (String)tuple2._1();
                        Set properties = (Set)tuple2._2();
                        String propertyString = ((TraversableOnce)properties.map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(2).append("`").append((String)p).append("`").toString(), Set$.MODULE$.canBuildFrom())).mkString("(", ", ", ")");
                        cmd = new StringBuilder(16).append("CREATE INDEX ON ").append(Neo4jHelpers.RichLabelString$.MODULE$.cypherLabelPredicate$extension(Neo4jHelpers$.MODULE$.RichLabelString(label))).append(propertyString).toString();
                        if (MODULE$.logger().isEnabled(Level.DEBUG)) {
                            Logger$.MODULE$.logMessage$extension1(MODULE$.logger(), Level.DEBUG, null, (CharSequence)new StringBuilder(30).append("Creating index for node keys: ").append(cmd).toString(), null);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    ResultSummary resultSummary = session.run(cmd).consume();
                    return resultSummary;
                });
                String command = new StringBuilder(20).append("CREATE INDEX ON ").append(Neo4jHelpers.RichLabelString$.MODULE$.cypherLabelPredicate$extension(Neo4jHelpers$.MODULE$.RichLabelString(ml))).append("(`").append(Neo4jHelpers.Neo4jDefaults$.MODULE$.metaPropertyKey()).append("`)").toString();
                if (MODULE$.logger().isEnabled(Level.DEBUG)) {
                    Logger$.MODULE$.logMessage$extension1(MODULE$.logger(), Level.DEBUG, null, (CharSequence)new StringBuilder(63).append("Creating sub-graph index for meta label and meta property key: ").append(command).toString(), null);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = session.run(command).consume();
            } else {
                throw new MatchError((Object)option);
            }
            return boxedUnit;
        });
    }

    public void merge(String graphName, PropertyGraph graph, Neo4jConfig config, Option<Map<String, Set<String>>> nodeKeys, Option<Map<String, Set<String>>> relationshipKeys, MorpheusSession morpheus) {
        BoxedUnit boxedUnit;
        PropertyGraphSchema updatedSchema = this.combineElementKeys(graph.schema(), nodeKeys, relationshipKeys);
        Option maybeMetaLabel = MetaLabelSupport$.MODULE$.RichGraphName(graphName).getMetaLabel();
        String maybeMetaLabelString = Neo4jHelpers.RichLabelSet$.MODULE$.cypherLabelPredicate$extension(Neo4jHelpers$.MODULE$.RichLabelSet(Option$.MODULE$.option2Iterable(maybeMetaLabel).toSet()));
        Future writesCompleted = Future$.MODULE$.sequence(MergeWriters$.MODULE$.writeNodes((Option<String>)maybeMetaLabel, graph, config, (Map<String, Set<String>>)updatedSchema.nodeKeys()), Set$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)_ -> Future$.MODULE$.sequence(MergeWriters$.MODULE$.writeRelationships((Option<String>)maybeMetaLabel, graph, config, (Map<String, Set<String>>)updatedSchema.relationshipKeys()), Set$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (ResultSummary)Neo4jHelpers.RichConfig$.MODULE$.withSession$extension(Neo4jHelpers$.MODULE$.RichConfig(config), (Function1 & Serializable & scala.Serializable)session -> session.run(new StringBuilder(19).append("MATCH (n").append(maybeMetaLabelString).append(") REMOVE n.").append(Neo4jHelpers.Neo4jDefaults$.MODULE$.metaPropertyKey()).toString()).consume()), ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)_ -> Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}, ExecutionContext.Implicits$.MODULE$.global()), ExecutionContext.Implicits$.MODULE$.global()), ExecutionContext.Implicits$.MODULE$.global()), ExecutionContext.Implicits$.MODULE$.global());
        Await$.MODULE$.result((Awaitable)writesCompleted, (Duration)Duration$.MODULE$.Inf());
        if (this.logger().isEnabled(Level.DEBUG)) {
            Logger$.MODULE$.logMessage$extension1(this.logger(), Level.DEBUG, null, (CharSequence)"Merge successful", null);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Option<Map<String, Set<String>>> merge$default$4() {
        return None$.MODULE$;
    }

    public Option<Map<String, Set<String>>> merge$default$5() {
        return None$.MODULE$;
    }

    private PropertyGraphSchema combineElementKeys(PropertyGraphSchema schema, Option<Map<String, Set<String>>> nodeKeys, Option<Map<String, Set<String>>> relationshipKeys) {
        PropertyGraphSchema withNodeKeys = (PropertyGraphSchema)((TraversableOnce)nodeKeys.getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).foldLeft((Object)schema, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            PropertyGraphSchema acc;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    acc = (PropertyGraphSchema)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            String label = (String)tuple2._1();
            Set keys = (Set)tuple2._2();
            PropertyGraphSchema propertyGraphSchema = acc.withNodeKey(label, keys);
            return propertyGraphSchema;
        });
        return (PropertyGraphSchema)((TraversableOnce)relationshipKeys.getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).foldLeft((Object)withNodeKeys, (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            Tuple2 tuple2;
            PropertyGraphSchema acc;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$2, x1$2);
                    if (tuple22 == null) break block2;
                    acc = (PropertyGraphSchema)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            String typ = (String)tuple2._1();
            Set keys = (Set)tuple2._2();
            PropertyGraphSchema propertyGraphSchema = acc.withRelationshipKey(typ, keys);
            return propertyGraphSchema;
        });
    }

    private Neo4jGraphMerge$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

