/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.StringBuilderFormattable;

public final class MarkerManager {
    private static final ConcurrentMap<String, Marker> MARKERS = new ConcurrentHashMap<String, Marker>();

    private MarkerManager() {
    }

    public static void clear() {
        MARKERS.clear();
    }

    public static boolean exists(String key2) {
        return MARKERS.containsKey(key2);
    }

    public static Marker getMarker(String name2) {
        Marker result = (Marker)MARKERS.get(name2);
        if (result == null) {
            MARKERS.putIfAbsent(name2, new Log4jMarker(name2));
            result = (Marker)MARKERS.get(name2);
        }
        return result;
    }

    @Deprecated
    public static Marker getMarker(String name2, String parent2) {
        Marker parentMarker = (Marker)MARKERS.get(parent2);
        if (parentMarker == null) {
            throw new IllegalArgumentException("Parent Marker " + parent2 + " has not been defined");
        }
        return MarkerManager.getMarker(name2, parentMarker);
    }

    @Deprecated
    public static Marker getMarker(String name2, Marker parent2) {
        return MarkerManager.getMarker(name2).addParents(parent2);
    }

    private static void requireNonNull(Object obj, String message) {
        if (obj == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static class Log4jMarker
    implements Marker,
    StringBuilderFormattable {
        private static final long serialVersionUID = 100L;
        private final String name;
        private volatile Marker[] parents;

        private Log4jMarker() {
            this.name = null;
            this.parents = null;
        }

        public Log4jMarker(String name2) {
            MarkerManager.requireNonNull(name2, "Marker name cannot be null.");
            this.name = name2;
            this.parents = null;
        }

        @Override
        public synchronized Marker addParents(Marker ... parentMarkers) {
            MarkerManager.requireNonNull(parentMarkers, "A parent marker must be specified");
            Marker[] localParents = this.parents;
            int count = 0;
            int size2 = parentMarkers.length;
            if (localParents != null) {
                for (Marker parent2 : parentMarkers) {
                    if (Log4jMarker.contains(parent2, localParents) || parent2.isInstanceOf(this)) continue;
                    ++count;
                }
                if (count == 0) {
                    return this;
                }
                size2 = localParents.length + count;
            }
            Marker[] markers = new Marker[size2];
            if (localParents != null) {
                System.arraycopy(localParents, 0, markers, 0, localParents.length);
            }
            int index2 = localParents == null ? 0 : localParents.length;
            for (Marker parent3 : parentMarkers) {
                if (localParents != null && (Log4jMarker.contains(parent3, localParents) || parent3.isInstanceOf(this))) continue;
                markers[index2++] = parent3;
            }
            this.parents = markers;
            return this;
        }

        @Override
        public synchronized boolean remove(Marker parent2) {
            MarkerManager.requireNonNull(parent2, "A parent marker must be specified");
            Marker[] localParents = this.parents;
            if (localParents == null) {
                return false;
            }
            int localParentsLength = localParents.length;
            if (localParentsLength == 1) {
                if (localParents[0].equals(parent2)) {
                    this.parents = null;
                    return true;
                }
                return false;
            }
            int index2 = 0;
            Marker[] markers = new Marker[localParentsLength - 1];
            for (int i = 0; i < localParentsLength; ++i) {
                Marker marker = localParents[i];
                if (marker.equals(parent2)) continue;
                if (index2 == localParentsLength - 1) {
                    return false;
                }
                markers[index2++] = marker;
            }
            this.parents = markers;
            return true;
        }

        @Override
        public Marker setParents(Marker ... markers) {
            if (markers == null || markers.length == 0) {
                this.parents = null;
            } else {
                Marker[] array = new Marker[markers.length];
                System.arraycopy(markers, 0, array, 0, markers.length);
                this.parents = array;
            }
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Marker[] getParents() {
            if (this.parents == null) {
                return null;
            }
            return Arrays.copyOf(this.parents, this.parents.length);
        }

        @Override
        public boolean hasParents() {
            return this.parents != null;
        }

        @Override
        @PerformanceSensitive(value={"allocation", "unrolled"})
        public boolean isInstanceOf(Marker marker) {
            MarkerManager.requireNonNull(marker, "A marker parameter is required");
            if (this == marker) {
                return true;
            }
            Marker[] localParents = this.parents;
            if (localParents != null) {
                int localParentsLength = localParents.length;
                if (localParentsLength == 1) {
                    return Log4jMarker.checkParent(localParents[0], marker);
                }
                if (localParentsLength == 2) {
                    return Log4jMarker.checkParent(localParents[0], marker) || Log4jMarker.checkParent(localParents[1], marker);
                }
                for (int i = 0; i < localParentsLength; ++i) {
                    Marker localParent = localParents[i];
                    if (!Log4jMarker.checkParent(localParent, marker)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        @PerformanceSensitive(value={"allocation", "unrolled"})
        public boolean isInstanceOf(String markerName) {
            MarkerManager.requireNonNull(markerName, "A marker name is required");
            if (markerName.equals(this.getName())) {
                return true;
            }
            Marker marker = (Marker)MARKERS.get(markerName);
            if (marker == null) {
                return false;
            }
            Marker[] localParents = this.parents;
            if (localParents != null) {
                int localParentsLength = localParents.length;
                if (localParentsLength == 1) {
                    return Log4jMarker.checkParent(localParents[0], marker);
                }
                if (localParentsLength == 2) {
                    return Log4jMarker.checkParent(localParents[0], marker) || Log4jMarker.checkParent(localParents[1], marker);
                }
                for (int i = 0; i < localParentsLength; ++i) {
                    Marker localParent = localParents[i];
                    if (!Log4jMarker.checkParent(localParent, marker)) continue;
                    return true;
                }
            }
            return false;
        }

        @PerformanceSensitive(value={"allocation", "unrolled"})
        private static boolean checkParent(Marker parent2, Marker marker) {
            Marker[] localParents;
            if (parent2 == marker) {
                return true;
            }
            Marker[] markerArray = localParents = parent2 instanceof Log4jMarker ? ((Log4jMarker)parent2).parents : parent2.getParents();
            if (localParents != null) {
                int localParentsLength = localParents.length;
                if (localParentsLength == 1) {
                    return Log4jMarker.checkParent(localParents[0], marker);
                }
                if (localParentsLength == 2) {
                    return Log4jMarker.checkParent(localParents[0], marker) || Log4jMarker.checkParent(localParents[1], marker);
                }
                for (int i = 0; i < localParentsLength; ++i) {
                    Marker localParent = localParents[i];
                    if (!Log4jMarker.checkParent(localParent, marker)) continue;
                    return true;
                }
            }
            return false;
        }

        @PerformanceSensitive(value={"allocation"})
        private static boolean contains(Marker parent2, Marker ... localParents) {
            for (Marker marker : localParents) {
                if (marker != parent2) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Marker)) {
                return false;
            }
            Marker marker = (Marker)o;
            return this.name.equals(marker.getName());
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.formatTo(sb);
            return sb.toString();
        }

        @Override
        public void formatTo(StringBuilder sb) {
            sb.append(this.name);
            Marker[] localParents = this.parents;
            if (localParents != null) {
                Log4jMarker.addParentInfo(sb, localParents);
            }
        }

        @PerformanceSensitive(value={"allocation"})
        private static void addParentInfo(StringBuilder sb, Marker ... parents2) {
            sb.append("[ ");
            boolean first2 = true;
            for (Marker marker : parents2) {
                Marker[] p;
                if (!first2) {
                    sb.append(", ");
                }
                first2 = false;
                sb.append(marker.getName());
                Marker[] markerArray = p = marker instanceof Log4jMarker ? ((Log4jMarker)marker).parents : marker.getParents();
                if (p == null) continue;
                Log4jMarker.addParentInfo(sb, p);
            }
            sb.append(" ]");
        }
    }
}

