/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.builder.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.builder.api.Component;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;

class DefaultComponentBuilder<T extends ComponentBuilder<T>, CB extends ConfigurationBuilder<? extends Configuration>>
implements ComponentBuilder<T> {
    private final CB builder;
    private final String type;
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();
    private final List<Component> components = new ArrayList<Component>();
    private final String name;
    private final String value;

    public DefaultComponentBuilder(CB builder, String type) {
        this(builder, null, type, null);
    }

    public DefaultComponentBuilder(CB builder, String name2, String type) {
        this(builder, name2, type, null);
    }

    public DefaultComponentBuilder(CB builder, String name2, String type, String value2) {
        this.type = type;
        this.builder = builder;
        this.name = name2;
        this.value = value2;
    }

    @Override
    public T addAttribute(String key2, boolean value2) {
        return this.put(key2, Boolean.toString(value2));
    }

    @Override
    public T addAttribute(String key2, Enum<?> value2) {
        return this.put(key2, value2.name());
    }

    @Override
    public T addAttribute(String key2, int value2) {
        return this.put(key2, Integer.toString(value2));
    }

    @Override
    public T addAttribute(String key2, Level level) {
        return this.put(key2, level.toString());
    }

    @Override
    public T addAttribute(String key2, Object value2) {
        return this.put(key2, value2.toString());
    }

    @Override
    public T addAttribute(String key2, String value2) {
        return this.put(key2, value2);
    }

    @Override
    public T addComponent(ComponentBuilder<?> builder) {
        this.components.add((Component)builder.build());
        return (T)this;
    }

    @Override
    public Component build() {
        Component component = new Component(this.type, this.name, this.value);
        component.getAttributes().putAll(this.attributes);
        component.getComponents().addAll(this.components);
        return component;
    }

    public CB getBuilder() {
        return this.builder;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected T put(String key2, String value2) {
        this.attributes.put(key2, value2);
        return (T)this;
    }
}

